/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mstate.h,v 1.26 2002/01/04 13:56:52 ostborn Exp $
*/

#ifndef _M_STATE_H_
#define _M_STATE_H_

#include <time.h>

#include "mconfig.h"
#include "mhash.h"
#include "mlist.h"

#define M_STATE_TYPE_UNSET	0
#define M_STATE_TYPE_WEB	1
#define M_STATE_TYPE_TELECOM	2
#define M_STATE_TYPE_GLOBAL	3
#define M_STATE_TYPE_TRAFFIC	4
#define M_STATE_TYPE_MAIL	5

#define M_STATE_SECTION_WEB	"web"
#define M_STATE_SECTION_TELECOM "telecom"
#define M_STATE_SECTION_TRAFFIC	"traffic"
#define M_STATE_SECTION_GLOBAL	"global"
#define M_STATE_SECTION_MAIL	"mail"

#define M_STATE_SUMMARY		"summary"

#define M_STATE_WEB_SUMMARY		"summary"
#define M_STATE_WEB_REQ_URL		"req_url"
#define M_STATE_WEB_REQ_METHOD		"req_meth"
#define M_STATE_WEB_REQ_PROTOCOL	"req_prot"
#define M_STATE_WEB_REF_URL		"ref_url"
#define M_STATE_WEB_OS			"os"
#define M_STATE_WEB_USERAGENT		"useragent"
#define M_STATE_WEB_HOST		"host"
#define M_STATE_WEB_STATUS		"status"
#define M_STATE_WEB_VISIT		"visit"
#define M_STATE_WEB_HOURS		"hours"
#define M_STATE_WEB_DAYS		"days"
#define M_STATE_WEB_COUNTRIES		"countries"
#define M_STATE_WEB_ROBOTS		"robots"
#define M_STATE_WEB_SEARCHSITE		"searchsite"
#define M_STATE_WEB_SEARCHSTRING	"searchstring"
#define M_STATE_WEB_INT_ERROR		"int_error"
#define M_STATE_WEB_MISSING_FILE	"missing_file"
#define M_STATE_WEB_BOOKMARKS		"bookmarks"
#define M_STATE_WEB_INDEXED_PAGES	"indexed_pages"
#define M_STATE_WEB_EXTENSIONS          "extensions"
#define M_STATE_WEB_VISITS              "visit_path"
#define M_STATE_WEB_VIEWS               "views"
#define M_STATE_WEB_SRVHOST             "srvhost"

#define M_STATE_TRAFFIC_INCOMMING	"incomming"
#define M_STATE_TRAFFIC_OUTGOING	"outgoing"
#define M_STATE_TRAFFIC_INTERNAL	"internal"
#define M_STATE_TRAFFIC_EXTERNAL	"external"

#define M_STATE_MAIL_SENDER             "sender"
#define M_STATE_MAIL_RECEIPIENT         "receipient"
#define M_STATE_MAIL_VIRUS              "virus"
#define M_STATE_MAIL_SCANNER            "scanner"
#define M_STATE_MAIL_SUBJECT            "subject"
#define M_STATE_MAIL_SEND_DOMAIN        "send_domain"
#define M_STATE_MAIL_RECP_DOMAIN        "recp_domain"
#define M_STATE_MAIL_HOURS		"hours"
#define M_STATE_MAIL_DAYS		"days"

#define M_STATE_WRITE_DEFAULT	0
#define M_STATE_WRITE_BY_MONTH	1

typedef struct {
	long hits;
	long files;
	long pages;
	long visits;
	long hosts;
	double xfersize;
} marray_web;

typedef struct {
	int	year;						/* summary */
	int	month;						/* summary */
	int	week;						/* summary */
	time_t	timestamp;					/* summary */
	
	int	ext_type;
	void 	*ext;
} mstate;

typedef struct {
					/* datatype */		/* saved as */
	mlist *visit_list;		/* data_StrInt */	/* visit */
	
	mhash *indexed_pages;		/* data_StrInt */	/* */
	
	mhash *os_hash;		        /* data_Str3Int */	/* os */
	mhash *req_url_hash;		/* data_StrInt */	/* req_url */
	mhash *ua_hash;		        /* data_Str3Int */	/* useragent */
	mhash *req_prot_hash;		/* data_StrInt */	/* req_prot */
	mhash *req_meth_hash;		/* data_StrInt */	/* req_meth */
	mhash *host_hash;		/* data_Str3Int */	/* host */
	mhash *status_hash;		/* data_StrInt */	/* status */
	mhash *ref_url_hash;		/* data_StrInt */	/* ref_url */
	mhash *robots;			/* data_StrInt */	/* robots */
	mhash *bookmarks;		/* data_StrInt */	/* bookmarks */
	mhash *status_missing_file;	/* data_BrokenLink */	/* missing_file */
	mhash *status_internal_error;	/* data_BrokenLink */	/* int_error */
	mhash *searchstring;		/* data_StrInt */	/* searchstring */
	mhash *searchsite;		/* data_StrInt */	/* searchsite */
	mhash *country_hash;		/* data_Str3Int */	/* countries */
	mhash *extension;               /* data_Count */        /* extensions */
	mhash *visits;                  /* data_SubList */      /* visits */
	mhash *views;                   /* data_StrInt */       /* time per page */
	mhash *vhost_hash;              /* data_Visited */      /* srvhost */
	
	marray_web hours[24];					/* hours */
	marray_web days[31];					/* days */

} mstate_web;

typedef struct {
	long incomming_calls;
	long outgoing_calls;
} marray_telecom;

typedef struct {
	mhash *called_numbers;
	mhash *calling_numbers;
	
	marray_telecom hours[24];				/* hours */
	marray_telecom days[31];				/* days */
} mstate_telecom;

typedef struct {
	mhash *incomming;
	mhash *outgoing;
	mhash *external;
	mhash *internal;
} mstate_traffic;

typedef struct {
	long incomming_mails;
	long outgoing_mails;
	
	long incomming_bytes;
	long outgoing_bytes;
} marray_mail;

typedef struct {
	double local_cur;
	double local_max;
	
	double remote_cur;
	double remote_max;
	
	double deliver_cur;
	double queue_cur;
	
	int count;
} marray_qmail_status;

typedef struct {
	mhash *sender;
	mhash *receipient;
	mhash *send_domain;
	mhash *recp_domain;
	mhash *virus;
	mhash *scanner;
	mhash *subject;
	
	marray_mail hours[24];				/* hours */
	marray_mail days[31];				/* days */
	marray_qmail_status qstat[31][24];
} mstate_mail;

mstate *mstate_init();
mstate_web *mstate_init_web();
mstate_telecom *mstate_init_telecom();
mstate_traffic *mstate_init_traffic();
mstate_mail *mstate_init_mail();

void mstate_free(mstate *state);
void mstate_free_web(mstate_web *state);
void mstate_free_telecom(mstate_telecom *state);
void mstate_free_traffic(mstate_traffic *state);
void mstate_free_mail(mstate_mail *state);

int mstate_read (mconfig *conf, mstate *state, int year, int month, char *subpath);
int mstate_write (mconfig *conf, mstate *state, int _add_month, char *subpath);

int mstate_is_section_end(const char *s);

#endif
