/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.2 2001/10/22 21:12:50 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include <pcre.h>

#include "mconfig.h"
#include "mrecord.h"

typedef struct {
	FILE	*inputfile;
	char	*inputfilename;

	char	*buffer;
	int	buf_len;
	int	buf_inc;

	pcre	*match_syslog;
	pcre	*match_sendmail_to;
	pcre	*match_sendmail_from;
	pcre	*match_sendmail_warning;
	pcre	*match_sendmail_noqueue;
	pcre    *match_timestamp;
} config_input;

int mplugins_input_sendmail_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
