/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.7 2001/09/15 19:14:19 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

int mplugins_input_netscape_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0,i;
	
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));
	
	conf->match_os = mlist_init();
	conf->match_ua = mlist_init();
	conf->inputfilename = NULL;
	
	conf->inputfile = stdin;
	
	conf->buf_len = 256;
	conf->buf_inc = 128;
	conf->buffer = malloc(conf->buf_len * sizeof(char));
	
	conf->match_clf = NULL;
	conf->match_clf_extra = NULL;
	conf->match_referrer_extra = NULL;
	
	if ((conf->match_url = pcre_compile(
		"^([A-Za-z]+) (.+?(\\?(.*?))*)( (.*))*$", 
		0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	} 
	
	if ((conf->match_timestamp = pcre_compile(
		"^([0-9]{2})/([a-zA-Z]{3})/([0-9]{4}):([0-9]{2}):([0-9]{2}):([0-9]{2})", 
		0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	} 
	
	conf->match_timestamp_extra = pcre_study(conf->match_timestamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_referrer = pcre_compile(
		"^(.*?)(\\?(.*?))*$", 
		0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	} 
	
	for (i = 0; i < M_NETSCAPE_MAX_FIELDS; i++) {
		conf->trans_fields[i] = 0;
	}
	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

int mplugins_input_netscape_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;
	
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		fclose(conf->inputfile);
	}
	
	mlist_free(conf->match_os);
	mlist_free(conf->match_ua);
	
	free(conf->buffer);
	
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_input_netscape_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
		{"matchua",	M_CONFIG_TYPE_MATCH,	M_CONFIG_VALUE_APPEND, &(conf->match_ua)},
		{"matchos",	M_CONFIG_TYPE_MATCH,	M_CONFIG_VALUE_APPEND, &(conf->match_os)},
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},
		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_netscape_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;
	
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		if (!(conf->inputfile = fopen(conf->inputfilename, "r"))) {
			fprintf(stderr, "%s %s: %s\n", _("Can't open inputfile "), conf->inputfilename, strerror(errno));
			return -1;
		}
	}
	
	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_netscape_dlinit;
	func->dlclose = mplugins_input_netscape_dlclose;
	func->parse_config = mplugins_input_netscape_parse_config;
	func->set_defaults = mplugins_input_netscape_set_defaults;
	func->get_next_record = mplugins_input_netscape_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	
	return 0;
}
