/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.4 2001/10/06 16:32:16 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>
#include <libxml/tree.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Skeleton */

int mdata_Skeleton_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	fprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.skeleton.x, #x);
	
	/* WR(count, d); */
#endif
	return 0;
}

int mdata_Skeleton_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_SKELETON) return -1;
	
	return 0;
}



int mdata_Skeleton_setdata(mdata *data, const char *str, int count, int type) {
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	if (data->type == M_DATA_TYPE_UNSET) 
		data->type		= M_DATA_TYPE_SKELETON;
	
/*
	data->data.skeleton.count	= count;
	data->data.skeleton.grouped	= type;
*/
	return 0;
}

int mdata_Skeleton_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	long grouped = 0, count = 0;
	int i;
	
	/* add your definitions here */
	const mdata_values data_values[] = {
		{ "grouped", M_DATA_FIELDTYPE_LONG, 	&(grouped) },
		{ "count", M_DATA_FIELDTYPE_LONG, 	&(count) },
		
		{ NULL, M_DATA_FIELDTYPE_UNSET,  NULL}
	};

	return 0;
}



int mdata_Skeleton_append(mdata *dst, mdata *src) {
	fprintf(stderr, "%s.%d: (skeleton) abstract function 'append' !!\n", __FILE__, __LINE__);
	
	return 0;
}

mdata *mdata_Skeleton_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_SKELETON;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	

/*
	data->data.skeleton.count		= 0;
	data->data.skeleton.grouped	= M_DATA_STATE_PLAIN;
*/

	return data;
}

mdata *mdata_Skeleton_copy(mdata *src) {
	mdata *data = mdata_Skeleton_init();
	assert(data);
	
	fprintf(stderr, "%s.%d: (skeleton) abstract function 'copy' !!\n", __FILE__, __LINE__);

/*
	mdata_Skeleton_setdata(data, src->key, src->data.skeleton.count, src->data.skeleton.grouped);
*/	
	return data;
}

mdata *mdata_Skeleton_create(const char *str, int count, int type) {
	mdata *data = mdata_Skeleton_init();
	assert(data);
	mdata_Skeleton_setdata(data, str, count, type);
	
	return data;
}

/* end of Skeleton */
