#include <iostream>
#include <cppunit/Exception.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

//----------------------------------------------------------------------------
int main(int argc, char **argv)
{
    CppUnit::TextUi::TestRunner runner;

    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("StringTokenizer").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("StringTools").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("MathTools").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("File").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Directory").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("XML").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("SDLTools").makeTest());

    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Magnet").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Turret").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Mortar").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Missile").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Ship").makeTest());

    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("PlayGround").makeTest());
    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("GameControl").makeTest());

    runner.addTest(
        CppUnit::TestFactoryRegistry::getRegistry("Level").makeTest());

    try
    {
        if (argc == 2)
        {
            runner.run(argv[1]);
        }
        else
        {
            runner.run();
        }
    }
    catch (CppUnit::Exception &e)
    {
        std::cerr << e.message().shortDescription() << std::endl;
        return -1;
    }
    catch (std::exception &e)
    {
        std::cerr << e.what() << std::endl;
        return -1;
    }
    catch (...)
    {
        std::cerr << "Unexpected exception while running the test cases."
                  << std::endl;
        return -1;
    }

    return 0;
}
