#include "SoundInterface.h"

#include "GuiException.h"
#include "MainMenu.h"
#include "QuitMenu.h"
#include "NewGameMenu.h"
#include "OptionMenu.h"
#include "CreditsMenu.h"

MENU_SINGLETON_INIT(Main);

//----------------------------------------------------------------------
MainMenu::MainMenu()
{
    getWidget(ID_MAIN_MENU_NEW)->SetEventObject(
       MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&MainMenu::onNew);
    getWidget(ID_MAIN_MENU_QUIT)->SetEventObject(
      MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&MainMenu::onQuit);
    getWidget(ID_MAIN_MENU_OPTIONS)->SetEventObject(
      MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&MainMenu::onOptions);
    getWidget(ID_MAIN_MENU_CREDITS)->SetEventObject(
      MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&MainMenu::onCredits);

    getWidget(ID_MAIN_MENU_NEW)->Show(false);
    getWidget(ID_MAIN_MENU_OPTIONS)->Show(false);
    getWidget(ID_MAIN_MENU_CREDITS)->Show(false);
    getWidget(ID_MAIN_MENU_QUIT)->Show(false);
}

//----------------------------------------------------------------------
MainMenu::~MainMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(MainMenu::onQuit)
{
  try
  {
    MenuManager::getInstance()->changeTo(QuitMenu::getInstance());
  }
  catch(GuiException e)
  {
    std::cerr << e << std::endl;
    PG_Application::GetApp()->Quit();
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(MainMenu::onNew)
{
  try
  {
    MenuManager::getInstance()->changeTo(NewGameMenu::getInstance());
  }
  catch(GuiException e)
  {
    std::cerr << e << std::endl;
    PG_Application::GetApp()->Quit();
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(MainMenu::onOptions)
{
  MenuManager::getInstance()->changeTo(OptionMenu::getInstance());
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(MainMenu::onCredits)
{
  MenuManager::getInstance()->changeTo(CreditsMenu::getInstance());
  return true;
}

//----------------------------------------------------------------------
void MainMenu::eventShow()
{
  SoundInterface::getInstance()->playTitleMusic();

  getWidget(ID_MAIN_MENU)->Show(false);
}

//----------------------------------------------------------------------
void MainMenu::eventHide()
{
  getWidget(ID_MAIN_MENU)->Hide();
}
