#################################################################
# xterm.tcl - interface that assumes xterm takes care of output
#
# Copyright (C) 1997-1999 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#################################################################

source [file join $config(lib_dir) lib mmucl_tk.tcl]

proc mmucl::display {str} {
    puts -nonewline $str
    flush stdout

    return
}

proc mmucl::stdin_parse {} {
    meta_parse [gets stdin]
    
    if {[eof stdin]} {
	MCexit
    }
    
    return
}

proc mmucl::interface_init {} {
    gui_init
    
    toolbar .toolbar
    
    menubutton .toolbar.options -menu .toolbar.options.m -text Options \
	    -relief raised
    option_menu .toolbar.options.m
    
    button .toolbar.help -image img_help -command mmucl::MChelp
    balloon_add .toolbar.help Help
    button .toolbar.quit -image img_quit -command mmucl::tk_exit
    balloon_add .toolbar.quit Quit
    
    pack .toolbar.options -padx 3 -side left
    pack .toolbar.quit .toolbar.help -side right
    
    mmucl::user_entry .input
    .input configure -width 60

    grid .toolbar -sticky ew 
    grid .input -sticky ew 
    grid columnconfigure . 0 -weight 1

    tkconf::apply

    wm resizable . 1 0
    focus .input

    fconfigure stdin -blocking 0
    fileevent stdin readable {mmucl::stdin_parse}
    
    rename interface_init ""    
    return
}
