/*
  This file is part of MlView
  Philippe Mechaï (2005)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef MLVIEW_PREFS_CATEGORY_FRAME_SEARCH_H
#define MLVIEW_PREFS_CATEGORY_FRAME_SEARCH_H

#include "mlview-prefs-category-frame.h"

namespace mlview
{
///
/// This structure contains private attributes of the
/// PrefsCategoryFrameGeneral class.
///
struct PrefsCategoryFrameSearchPriv;

///
/// This class is the frame that handles PrefsCategorySearch
/// preferences
///
class PrefsCategoryFrameSearch : public PrefsCategoryFrame
{
	friend class PrefsCategoryFrameSearchPriv;
	PrefsCategoryFrameSearchPriv *m_priv;

public:
	///
	/// Default parameter-less constructor
	///
	PrefsCategoryFrameSearch ();
	///
	/// Default destructor
	///
	~PrefsCategoryFrameSearch ();
};


} // namespace mlview

#endif
