signature CASES =
   sig
      type con
      datatype 'a t = T of 'a * con
   end

functor Cases (S: sig
		     type con
		  end): CASES =
   struct
      open S

      datatype 'a t = T of 'a * con
   end

signature XML_TREE =
   sig
      structure Cases: CASES where type con = int
      datatype u = U of real Cases.t
   end

functor XmlTree (): XML_TREE =
   struct
      structure Cases = Cases (type con = int)

      datatype u = U of real Cases.t

      fun f (U c) =
	 let
	    datatype z = datatype Cases.t
	    val T _ = c
	    val Cases.T _ = c
	 in ()
	 end
   end

structure XmlTree = XmlTree ()
