/* mg-work-matrix.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_WORK_MATRIX__
#define __MG_WORK_MATRIX__

#include <gtk/gtk.h>
#include "mg-conf.h"
#include "mg-enums.h"

G_BEGIN_DECLS

#define MG_WORK_MATRIX_TYPE          (mg_work_matrix_get_type())
#define MG_WORK_MATRIX(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_work_matrix_get_type(), MgWorkMatrix)
#define MG_WORK_MATRIX_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_work_matrix_get_type (), MgWorkMatrixClass)
#define IS_MG_WORK_MATRIX(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_work_matrix_get_type ())


typedef struct _MgWorkMatrix      MgWorkMatrix;
typedef struct _MgWorkMatrixClass MgWorkMatrixClass;
typedef struct _MgWorkMatrixPriv  MgWorkMatrixPriv;

typedef enum {
	MG_WORK_MATRIX_TABULAR_SYNTHETIC = 0,
	MG_WORK_MATRIX_LIST_DETAILLED    = 1,
	MG_WORK_MATRIX_LIST_SYNTHETIC    = 2,
} MgWorkMatrixType;

/* struct for the object's data */
struct _MgWorkMatrix
{
	GtkVBox             object;

	MgWorkMatrixPriv     *priv;
};

/* struct for the object's class */
struct _MgWorkMatrixClass
{
	GtkVBoxClass parent_class;
};

/* 
 * Generic widget's methods 
 */
guint        mg_work_matrix_get_type            (void);
GtkWidget   *mg_work_matrix_new                 (MgConf *conf,
						 MgQuery *rows_select_query, MgTarget *rows_target,
						 MgQuery *cols_select_query, MgTarget *cols_target,
						 MgDbTable *modif_table, GSList *modif_table_fields);
void         mg_work_matrix_set_view_type       (MgWorkMatrix *matrix, MgWorkMatrixType type);

G_END_DECLS

#endif



