/* example.c generated by valac, the Vala compiler
 * generated from example.vala, do not modify */

/*
 * An example how to use Memphis in the Vala programming language.
 *
 * Compile command:
 * valac --pkg cairo --pkg memphis-0.2 --vapidir=../ example.vala
 *
 * Author: Simon Wenner
 * License: Public Domain
 */

#include <glib.h>
#include <glib-object.h>
#include <memphis/memphis.h>
#include <cairo.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))



gint _vala_main (void);



gint _vala_main (void) {
	gint result = 0;
	GError * _inner_error_;
	MemphisMap* map;
	MemphisRuleSet* rules;
	MemphisRenderer* renderer;
	cairo_surface_t* surface;
	cairo_t* cr;
	_inner_error_ = NULL;
	map = memphis_map_new ();
	{
		memphis_map_load_from_file (map, "../../../demos/map.osm", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("example.vala:22: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	rules = memphis_rule_set_new ();
	{
		memphis_rule_set_load_from_file (rules, "../../../demos/default-rules.xml", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("example.vala:30: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (map);
		_g_object_unref0 (rules);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	renderer = memphis_renderer_new_full (rules, map);
	surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 256, 256);
	cr = cairo_create (surface);
	memphis_renderer_draw_tile (renderer, cr, (guint) 8608, (guint) 5754, (guint) 14);
	cairo_surface_write_to_png (surface, "vala_test.png");
	result = 0;
	_g_object_unref0 (map);
	_g_object_unref0 (rules);
	_g_object_unref0 (renderer);
	_cairo_surface_destroy0 (surface);
	_cairo_destroy0 (cr);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main ();
}




