
'\"
'\" Generated from file 'fifo2.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools
.so man.macros
.TH "fifo2" n 2.2  "Memory channels"
.BS
.SH "NAME"
fifo2 \- Create and manipulate pipe fifo channels
.SH "SYNOPSIS"
package require \fBTcl \fR
.sp
package require \fBmemchan \fR
.sp
\fBfifo2\fR \fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The command described here is only available in a not-yet released
version of the package. Use the CVS to get the sources.
.TP
\fBfifo2\fR \fR
creates two stream-oriented in-memory channels and returns their
handles as a two-element list. There is no restriction on the ultimate
size of the channels, they will always grow as much as is necessary to
accomodate the data written into them.
.sp
In contrast to the channels generated by \fBfifo\fR a pair of channels
created here is connected internally in such a way that data written
into one channel can be read from the other. All data written into
them is read in the same order. This also means that the two channels
of the pair are not seekable.
.sp
The channels created here can be transfered between interpreters in
the same thread and between threads. As both channels in the pair can
be transfered independently they can be used to create a bidirectional
connection between two interpreters.
.PP
Memory channels created by \fBfifo2\fR provide two read-only options
which can be queried via the standard \fBfconfigure\fR command. These
are
.TP
-rlength
The value of this option is the number of bytes currently
available for reading from the channel.
.TP
-wlength
The value of this option is the number of bytes currently
written into the channel.
.PP
Note that the two lengths are switched for the channels of a pair. In
other words, the number of bytes written for one of the channels is
the number of bytes readable from the other end.
.PP
As the channels generated by \fBfifo2\fR grow as necessary they are
always writable. This means that a writable \fBfileevent\fR-handler
will fire continuously.
.PP
The channels are also readable if they contain more than zero
bytes. Under this conditions a readable \fBfileevent\fR-handler will
fire continuously.
.SH "SEE ALSO"
memchan, fifo, null
.SH "KEYWORDS"
fifo, stream, memchan, in-memory channel, channel, i/o
.SH "COPYRIGHT"
.nf
Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
.fi
