;;; -*- Mode: Lisp; package:maxima; syntax:common-lisp ;Base: 10 -*- ;;;

(in-package "MAXIMA")
;;** Variable settings were **

;;TRANSCOMPILE:TRUE;
;;TR_SEMICOMPILE:FALSE;
;;TRANSLATE_FAST_ARRAYS:TRUE;
;;TR_WARN_UNDECLARED:COMPILE;
;;TR_WARN_MEVAL:COMPFILE;
;;TR_WARN_FEXPR:COMPFILE;
;;TR_WARN_MODE:ALL;
;;TR_WARN_UNDEFINED_VARIABLE:ALL;
;;TR_FUNCTION_CALL_DEFAULT:GENERAL;
;;TR_ARRAY_AS_REF:TRUE;
;;TR_NUMER:FALSE;
;;DEFINE_VARIABLE:FALSE;

(SIMPLIFY (MFUNCTION-CALL $PUT '|$specfun| 110 '$VERSION))
(PROGN
  (DEFPROP |$floor_rat| T TRANSLATED)
  (ADD2LNC '|$floor_rat| $PROPS)
  (DEFMTRFUN (|$floor_rat| $ANY MDEFINE NIL NIL) (|$m| |$n|)
      (DECLARE (SPECIAL |$n| |$m|) (FIXNUM |$n| |$m|))
      ((LAMBDA ()
         NIL
         NIL
         (SIMPLIFY
             ($FIRST (SIMPLIFY (MFUNCTION-CALL $DIVIDE |$m| |$n|))))))))
(EVAL-WHEN (LOAD) (SETQ $FLOAT2BF T))
(PROGN
  (DEFPROP |$float_bfloatp| T TRANSLATED)
  (ADD2LNC '|$float_bfloatp| $PROPS)
  (DEFMTRFUN (|$float_bfloatp| $BOOLEAN MDEFINE NIL NIL) (|$x|)
      (DECLARE (SPECIAL |$x|))
      ((LAMBDA ()
         NIL
         (OR (MFUNCTION-CALL $FLOATNUMP |$x|)
             (MFUNCTION-CALL $BFLOATP |$x|))))))
(PROGN
  (DEFPROP |$complex_floatp| T TRANSLATED)
  (ADD2LNC '|$complex_floatp| $PROPS)
  (DEFMTRFUN (|$complex_floatp| $BOOLEAN MDEFINE NIL NIL) (|$x|)
      (DECLARE (SPECIAL |$x|))
      ((LAMBDA ()
         NIL
         (COND
           ((MFUNCTION-CALL $ATOM |$x|) NIL)
           (T (AND (MFUNCTION-CALL $CONSTANTP |$x|)
                   (MFUNCTION-CALL |$float_bfloatp|
                       (SIMPLIFY (MFUNCTION-CALL $REALPART |$x|)))
                   (MFUNCTION-CALL |$float_bfloatp|
                       (SIMPLIFY (MFUNCTION-CALL $IMAGPART |$x|))))))))))
(PROGN
  (DEFPROP |$floating_pointp| T TRANSLATED)
  (ADD2LNC '|$floating_pointp| $PROPS)
  (DEFMTRFUN (|$floating_pointp| $BOOLEAN MDEFINE NIL NIL) (|$x|)
      (DECLARE (SPECIAL |$x|))
      ((LAMBDA ()
         NIL
         (OR (MFUNCTION-CALL |$float_bfloatp| |$x|)
             (MFUNCTION-CALL |$complex_floatp| |$x|))))))
(PROGN
  (DEFPROP |$coerce_return_type| T TRANSLATED)
  (ADD2LNC '|$coerce_return_type| $PROPS)
  (DEFMTRFUN (|$coerce_return_type| $ANY MDEFINE NIL NIL) (|$x| |$y|)
      (DECLARE (SPECIAL |$y| |$x|))
      ((LAMBDA ($RATPRINT)
         (DECLARE (SPECIAL $RATPRINT))
         (COND
           ((MFUNCTION-CALL $FLOATNUMP |$x|) ($FLOAT |$y|))
           ((MFUNCTION-CALL $BFLOATP |$x|)
            (SIMPLIFY (MFUNCTION-CALL $BFLOAT |$y|)))
           ((MFUNCTION-CALL |$complex_floatp| |$x|)
            (SIMPLIFY (MFUNCTION-CALL $EXPAND |$y|)))
           (T |$y|)))
       NIL)))
(PROGN
  (DEFPROP |$jacobi_p| T TRANSLATED)
  (ADD2LNC '|$jacobi_p| $PROPS)
  (DEFMTRFUN (|$jacobi_p| $ANY MDEFINE NIL NIL) (|$n| |$a| |$b| |$x|)
      (DECLARE (SPECIAL |$x| |$b| |$a| |$n|))
      ((LAMBDA (|$sofar| |$w| |$abn| |$m| |$s_args|)
         (DECLARE (SPECIAL |$s_args| |$m| |$abn| |$w| |$sofar|)
                  (FIXNUM |$m|))
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1))
                 (OR (NOT (MFUNCTION-CALL $INTEGERP |$a|))
                     (IS-BOOLE-CHECK (MGRP |$a| -1)))
                 (OR (NOT (MFUNCTION-CALL $INTEGERP |$b|))
                     (IS-BOOLE-CHECK (MGRP |$b| -1))))
            (COND
              ((AND (IS-BOOLE-CHECK
                        (SIMPLIFY
                            (MAPPLY-TR '|&and|
                                (SIMPLIFY
                                    (MAP1 (GETOPR '$CONSTANTP)
                                     (LIST '(MLIST) |$a| |$b| |$x|))))))
                    (IS-BOOLE-CHECK
                        (SIMPLIFY
                            (MAPPLY-TR '|&and|
                                (SIMPLIFY
                                    (MAP1 (GETOPR '$FLOATNUMP)
                                     (LIST '(MLIST) |$a| |$b| |$x|)))))))
               (SIMPLIFY
                   (MFUNCTION-CALL |$jacobi_pf| |$n| ($FLOAT |$a|)
                       ($FLOAT |$b|) ($FLOAT |$x|))))
              (T (SETQ |$sofar| 1) (SETQ |$w| 1)
                 (SETQ |$x| (DIV (ADD* |$x| -1) 2))
                 (SETQ |$abn| (ADD* |$a| |$b| |$n|))
                 (DO ((|$m| 1 (F+ 1 |$m|)))
                     ((IS-BOOLE-CHECK (MGRP |$m| |$n|)) '$DONE)
                   (SETQ |$w|
                         (DIV (MUL* |$w| (ADD* |$n| 1 (- |$m|))
                                    (ADD* |$abn| |$m|) |$x|)
                              (MUL* |$m| (ADD* |$a| |$m|))))
                   (SETQ |$sofar| (ADD* |$sofar| |$w|)))
                 (SIMPLIFY
                     (MFUNCTION-CALL |$coerce_return_type| |$x|
                         (MUL* (SIMPLIFY
                                   (LIST '(%BINOMIAL) (ADD* |$n| |$a|)
                                    |$n|))
                               |$sofar|))))))
           ((IS-BOOLE-CHECK
                (SIMPLIFY (MFUNCTION-CALL $FEATUREP |$n| '$INTEGER)))
            (SETQ |$s_args|
                  (LIST '(MLIST)
                        (MUL* (SIMPLIFY
                                  (LIST '(%BINOMIAL) (ADD* |$n| |$a|)
                                        '|$m|))
                              (SIMPLIFY
                                  (LIST '(%BINOMIAL) (ADD* |$n| |$b|)
                                        (ADD* |$n| (*MMINUS '|$m|))))
                              (POWER (ADD* |$x| -1)
                                     (ADD* |$n| (*MMINUS '|$m|)))
                              (POWER (ADD* |$x| 1) '|$m|))
                        '|$m| 1 (ADD* |$n| -1)))
            (DIV (ADD* (MUL* (SIMPLIFY
                                 (LIST '(%BINOMIAL) (ADD* |$n| |$a|) 0))
                             (SIMPLIFY
                                 (LIST '(%BINOMIAL) (ADD* |$n| |$b|)
                                       |$n|))
                             (POWER (ADD* |$x| -1) |$n|))
                       (MUL* (SIMPLIFY
                                 (LIST '(%BINOMIAL) (ADD* |$n| |$a|)
                                       |$n|))
                             (SIMPLIFY
                                 (LIST '(%BINOMIAL) (ADD* |$n| |$b|) 0))
                             (POWER (ADD* |$x| 1) |$n|))
                       (SIMPLIFY (MAPPLY-TR '$SUM |$s_args|)))
                 (POWER 2 |$n|)))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$jacobi_p|
                      (LIST '(MLIST) |$n| |$a| |$b| |$x|))))))
       '|$sofar| '|$w| '|$abn| 0 '((MLIST)))))
(MEVAL '(($GRADEF) ((|$jacobi_p|) |$n| |$a| |$b| |$x|)
         ((%DERIVATIVE) ((|%jacobi_p|) |$n| |$a| |$b| |$x|) |$n|)
         ((%DERIVATIVE) ((|%jacobi_p|) |$n| |$a| |$b| |$x|) |$a|)
         ((%DERIVATIVE) ((|%jacobi_p|) |$n| |$a| |$b| |$x|) |$b|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n|
            ((MPLUS) |$a| ((MMINUS) |$b|)
             ((MTIMES) ((MMINUS) ((MPLUS) ((MTIMES) 2 |$n|) |$a| |$b|))
              |$x|))
            ((|%jacobi_p|) |$n| |$a| |$b| |$x|))
           ((MTIMES) 2 ((MPLUS) |$n| |$a|) ((MPLUS) |$n| |$b|)
            ((|%jacobi_p|) ((MPLUS) |$n| ((MMINUS) 1)) |$a| |$b| |$x|)))
          ((MTIMES) ((MPLUS) ((MTIMES) 2 |$n|) |$a| |$b|)
           ((MPLUS) 1 ((MMINUS) ((MEXPT) |$x| 2)))))))
(PROGN
  (DEFPROP |$jacobi_pf| T TRANSLATED)
  (ADD2LNC '|$jacobi_pf| $PROPS)
  (DEFMTRFUN (|$jacobi_pf| $ANY MDEFINE NIL NIL) (|$n| |$a| |$b| |$x|)
      (DECLARE (SPECIAL |$x| |$b| |$a| |$n|) (FLONUM |$x| |$b| |$a|)
               (FIXNUM |$n|))
      ((LAMBDA (|$sofar| |$w| |$abn| |$np1| |$m|)
         (DECLARE (SPECIAL |$m| |$np1| |$abn| |$w| |$sofar|)
                  (FLONUM |$np1| |$abn| |$w| |$sofar|) (FIXNUM |$m|))
         NIL
         (SETQ |$sofar| 1.0)
         (SETQ |$w| 1.0)
         (SETQ |$x| (//$ (+$ |$x| -1.0) 2.0))
         (SETQ |$abn| (+$ |$a| |$b| (FLOAT |$n|)))
         (SETQ |$np1| (+$ 1.0 (FLOAT |$n|)))
         (DO ((|$m| 1 (F+ 1 |$m|))) ((> |$m| |$n|) '$DONE)
           (SETQ |$w|
                 (//$ (*$ |$w| (+$ |$np1| (FLOAT (- |$m|)))
                          (+$ |$abn| (FLOAT |$m|)) |$x|)
                      (*$ (FLOAT |$m|) (+$ |$a| (FLOAT |$m|)))))
           (SETQ |$sofar| (+$ |$sofar| |$w|)))
         (MUL* (SIMPLIFY
                   (LIST '(%BINOMIAL) (+$ (FLOAT |$n|) |$a|) |$n|))
               |$sofar|))
       0.0 0.0 0.0 0.0 0)))
(PROGN
  (DEFPROP |$ultraspherical| T TRANSLATED)
  (ADD2LNC '|$ultraspherical| $PROPS)
  (DEFMTRFUN (|$ultraspherical| $ANY MDEFINE NIL NIL) (|$n| |$a| |$x|)
      (DECLARE (SPECIAL |$x| |$a| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (DIV (MUL* (SIMPLIFY
                        (LIST '(%GAMMA) (ADD* |$a| (RREMAINDER 1 2))))
                    (SIMPLIFY
                        (LIST '(%GAMMA) (ADD* (MUL* 2 |$a|) |$n|)))
                    (SIMPLIFY
                        (MFUNCTION-CALL |$jacobi_p| |$n|
                            (ADD* |$a| (RTIMES -1 (RREMAINDER 1 2)))
                            (ADD* |$a| (RTIMES -1 (RREMAINDER 1 2)))
                            |$x|)))
              (MUL* (SIMPLIFY (LIST '(%GAMMA) (MUL* 2 |$a|)))
                    (SIMPLIFY
                        (LIST '(%GAMMA)
                              (ADD* |$a| |$n| (RREMAINDER 1 2))))))))))
(PROGN
  (DEFPROP |$assoc_legendre_p| T TRANSLATED)
  (ADD2LNC '|$assoc_legendre_p| $PROPS)
  (DEFMTRFUN (|$assoc_legendre_p| $ANY MDEFINE NIL NIL)
      (|$n| |$m| |$x|) (DECLARE (SPECIAL |$x| |$m| |$n|))
      ((LAMBDA (|$c|)
         (DECLARE (SPECIAL |$c|))
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (MFUNCTION-CALL $INTEGERP |$m|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1)))
            (COND
              ((IS-BOOLE-CHECK
                   (MGRP (SIMPLIFY (LIST '(MABS) |$m|)) |$n|))
               0)
              ((IS-BOOLE-CHECK (MLSP |$m| 0))
               (DIV (MUL* (SIMPLIFY
                              (LIST '(%GAMMA)
                                    (ADD* |$n| (*MMINUS |$m|) 1)))
                          (SIMPLIFY
                              (MFUNCTION-CALL |$assoc_legendre_p| |$n|
                                  (*MMINUS |$m|) |$x|)))
                    (SIMPLIFY (LIST '(%GAMMA) (ADD* |$n| |$m| 1)))))
              (T (COND
                   ((LIKE |$m| 0) (SETQ |$c| 1))
                   (T (SETQ |$c|
                            (SIMPLIFY
                                (LIST '(%GENFACT)
                                      (ADD* (MUL* 2 |$m|) -1)
                                      (ADD* |$m| -1) 2)))))
                 (MUL* |$c| (POWER -1 |$m|)
                       (POWER (ADD* 1 (*MMINUS (POWER |$x| 2)))
                              (DIV |$m| 2))
                       (SIMPLIFY
                           (MFUNCTION-CALL |$ultraspherical|
                               (ADD* |$n| (*MMINUS |$m|))
                               (ADD* |$m| (RREMAINDER 1 2)) |$x|))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$assoc_legendre_p|
                      (LIST '(MLIST) |$n| |$m| |$x|))))))
       '|$c|)))
(MEVAL '(($GRADEF) ((|$assoc_legendre_p|) |$n| |$m| |$x|)
         ((%DERIVATIVE) ((|%assoc_legendre_p|) |$m| |$m| |$x|) |$n|)
         ((%DERIVATIVE) ((|%alegendre_p|) |$n| |$m| |$x|) |$m|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n| |$x| ((|%assoc_legendre_p|) |$n| |$m| |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| |$m|)
             ((|%assoc_legendre_p|) ((MPLUS) |$n| ((MMINUS) 1)) |$m|
              |$x|))))
          ((MPLUS) ((MEXPT) |$x| 2) ((MMINUS) 1)))))
(PROGN
  (DEFPROP |$legendre_q| T TRANSLATED)
  (ADD2LNC '|$legendre_q| $PROPS)
  (DEFMTRFUN (|$legendre_q| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA (|$m| |$leg_p| |$sofar| $RATPRINT)
         (DECLARE (SPECIAL $RATPRINT |$sofar| |$leg_p| |$m|)
                  (FIXNUM |$m|))
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1)))
            (SETQ |$leg_p| '((MLIST)))
            (DO ((|$m| 0 (F+ 1 |$m|)))
                ((IS-BOOLE-CHECK (MGRP |$m| |$n|)) '$DONE)
              (SETQ |$leg_p|
                    (SIMPLIFY
                        (MFUNCTION-CALL $ENDCONS
                            (SIMPLIFY
                                (MFUNCTION-CALL |$legendre_p| |$m|
                                    |$x|))
                            |$leg_p|))))
            (SETQ |$sofar| 0)
            (DO ((|$m| 1 (F+ 1 |$m|)))
                ((IS-BOOLE-CHECK (MGRP |$m| |$n|)) '$DONE)
              (SETQ |$sofar|
                    (ADD* |$sofar|
                          (DIV (MUL* (SIMPLIFY
                                      (MFUNCTION-CALL $PART |$leg_p|
                                       |$m|))
                                     (SIMPLIFY
                                      (MFUNCTION-CALL $PART |$leg_p|
                                       (ADD* |$n| (- |$m|) 1))))
                               |$m|))))
            (ADD* (DIV (MUL* (SIMPLIFY
                                 (MFUNCTION-CALL $PART |$leg_p|
                                     (ADD* |$n| 1)))
                             (SIMPLIFY
                                 (LIST '(%LOG)
                                       (DIV (ADD* 1 |$x|)
                                        (ADD* 1 (*MMINUS |$x|))))))
                       2)
                  (*MMINUS |$sofar|)))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$legendre_q|
                      (LIST '(MLIST) |$n| |$x|))))))
       0 '((MLIST)) '|$sofar| NIL)))
(PROGN
  (DEFPROP |$assoc_legendre_q| T TRANSLATED)
  (ADD2LNC '|$assoc_legendre_q| $PROPS)
  (DEFMTRFUN (|$assoc_legendre_q| $ANY MDEFINE NIL NIL)
      (|$n| |$m| |$x|) (DECLARE (SPECIAL |$x| |$m| |$n|))
      ((LAMBDA (|$x%| |$f| $RATPRINT)
         (DECLARE (SPECIAL $RATPRINT |$f| |$x%|))
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1))
                 (MFUNCTION-CALL $INTEGERP |$m|))
            (COND
              ((IS-BOOLE-CHECK (MLSP |$m| 0))
               (DIV (MUL* (POWER -1 |$m|)
                          (SIMPLIFY
                              (LIST '(MFACTORIAL) (ADD* |$n| |$m|)))
                          (SIMPLIFY
                              (MFUNCTION-CALL |$assoc_legendre_q| |$n|
                                  (*MMINUS |$m|) |$x|)))
                    (SIMPLIFY
                        (LIST '(MFACTORIAL) (ADD* |$n| (*MMINUS |$m|))))))
              (T (SETQ |$f|
                       (SIMPLIFY
                           (MFUNCTION-CALL $RATSIMP
                               (MUL* (POWER -1 |$m|)
                                     (POWER
                                      (ADD* 1 (*MMINUS (POWER |$x| 2)))
                                      (DIV |$m| 2))
                                     (SIMPLIFY
                                      (MFUNCTION-CALL $DIFF
                                       (SIMPLIFY
                                        (MFUNCTION-CALL |$legendre_q|
                                         |$n| |$x%|))
                                       |$x%| |$m|))))))
                 (SIMPLIFY
                     (MFUNCTION-CALL $SUBSTITUTE |$x| |$x%| |$f|)))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$assoc_legendre_q|
                      (LIST '(MLIST) |$n| |$m| |$x|))))))
       '|$x%| '|$f| NIL)))
(PROGN
  (DEFPROP |$chebyshev_t| T TRANSLATED)
  (ADD2LNC '|$chebyshev_t| $PROPS)
  (DEFMTRFUN (|$chebyshev_t| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((OR (AND (MFUNCTION-CALL $INTEGERP |$n|)
                     (IS-BOOLE-CHECK (MGRP |$n| -1)))
                (IS-BOOLE-CHECK
                    (SIMPLIFY
                        (MFUNCTION-CALL $FEATUREP |$n| '$INTEGER))))
            (DIV (MUL* (SIMPLIFY (LIST '(MFACTORIAL) |$n|))
                       (POWER 2 |$n|)
                       (SIMPLIFY
                           (MFUNCTION-CALL |$jacobi_p| |$n|
                               (RREMAINDER -1 2) (RREMAINDER -1 2)
                               |$x|)))
                 (SIMPLIFY
                     (LIST '(%GENFACT) (ADD* (MUL* 2 |$n|) -1) |$n| 2))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$chebyshev_t|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(MEVAL '(($GRADEF) ((|$chebyshev_t|) |$n| |$x|)
         ((%DERIVATIVE) ((|%chebyshev_t|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) ((MMINUS) |$n|) |$x| ((|%chebyshev_t|) |$n| |$x|))
           ((MTIMES) |$n|
            ((|%chebyshev_t|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|)))
          ((MPLUS) 1 ((MMINUS) ((MEXPT) |$x| 2))))))
(PROGN
  (DEFPROP |$chebyshev_u| T TRANSLATED)
  (ADD2LNC '|$chebyshev_u| $PROPS)
  (DEFMTRFUN (|$chebyshev_u| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((OR (AND (MFUNCTION-CALL $INTEGERP |$n|)
                     (IS-BOOLE-CHECK (MGRP |$n| -1)))
                (IS-BOOLE-CHECK
                    (SIMPLIFY
                        (MFUNCTION-CALL $FEATUREP |$n| '$INTEGER))))
            (DIV (MUL* (SIMPLIFY (LIST '(MFACTORIAL) (ADD* |$n| 1)))
                       (POWER 2 |$n|)
                       (SIMPLIFY
                           (MFUNCTION-CALL |$jacobi_p| |$n|
                               (RREMAINDER 1 2) (RREMAINDER 1 2) |$x|)))
                 (SIMPLIFY
                     (LIST '(%GENFACT) (ADD* (MUL* 2 |$n|) 1)
                           (ADD* |$n| 1) 2))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$chebyshev_u|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(MEVAL '(($GRADEF) ((|$chebyshev_u|) |$n| |$x|)
         ((%DERIVATIVE) ((|%chebyshev_u|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) ((MMINUS) |$n|) |$x| ((|%chebyshev_u|) |$n| |$x|))
           ((MTIMES) ((MPLUS) |$n| 1)
            ((|%chebyshev_u|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|)))
          ((MPLUS) 1 ((MMINUS) ((MEXPT) |$x| 2))))))
(PROGN
  (DEFPROP |$laguerre| T TRANSLATED)
  (ADD2LNC '|$laguerre| $PROPS)
  (DEFMTRFUN (|$laguerre| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ($RATPRINT)
         (DECLARE (SPECIAL $RATPRINT))
         NIL
         (SIMPLIFY (MFUNCTION-CALL |$gen_laguerre| |$n| 0 |$x|)))
       NIL)))
(PROGN
  (DEFPROP |$gen_laguerre| T TRANSLATED)
  (ADD2LNC '|$gen_laguerre| $PROPS)
  (DEFMTRFUN (|$gen_laguerre| $ANY MDEFINE NIL NIL) (|$n| |$a| |$x|)
      (DECLARE (SPECIAL |$x| |$a| |$n|))
      ((LAMBDA (|$sofar| |$w| |$m| $RATPRINT)
         (DECLARE (SPECIAL $RATPRINT |$m| |$w| |$sofar|) (FIXNUM |$m|))
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1)))
            (SETQ |$sofar| 1) (SETQ |$w| 1)
            (DO ((|$m| 1 (F+ 1 |$m|)))
                ((IS-BOOLE-CHECK (MGRP |$m| |$n|)) '$DONE)
              (SETQ |$w|
                    (DIV (MUL* (*MMINUS |$w|) |$x|
                               (ADD* |$n| (- |$m|) 1))
                         (MUL* |$m| (ADD* |$m| |$a|))))
              (SETQ |$sofar| (ADD* |$sofar| |$w|)))
            (SIMPLIFY
                (MFUNCTION-CALL |$coerce_return_type| |$x|
                    (MUL* (SIMPLIFY
                              (LIST '(%BINOMIAL) (ADD* |$n| |$a|) |$n|))
                          |$sofar|))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$gen_laguerre|
                      (LIST '(MLIST) |$n| |$a| |$x|))))))
       '|$sofar| '|$w| 0 NIL)))
(MEVAL '(($GRADEF) ((|$gen_laguerre|) |$n| |$a| |$x|)
         ((%DERIVATIVE) ((|%gen_laguerre|) |$n| |$a| |$x|) |$n|)
         ((%DERIVATIVE) ((|$gen_laguerre|) |$n| |$a| |$x|) |$a|)
         ((MQUOTIENT)
          ((MPLUS) ((MTIMES) |$n| ((|$gen_laguerre|) |$n| |$a| |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| |$a|)
             ((|$gen_laguerre|) ((MPLUS) |$n| ((MMINUS) 1)) |$a| |$x|))))
          |$x|)))
(PROGN
  (DEFPROP |$legendre_p| T TRANSLATED)
  (ADD2LNC '|$legendre_p| $PROPS)
  (DEFMTRFUN (|$legendre_p| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((OR (AND (MFUNCTION-CALL $INTEGERP |$n|)
                     (IS-BOOLE-CHECK (MGRP |$n| -1)))
                (IS-BOOLE-CHECK
                    (SIMPLIFY
                        (MFUNCTION-CALL $FEATUREP |$n| '$INTEGER))))
            (SIMPLIFY (MFUNCTION-CALL |$jacobi_p| |$n| 0 0 |$x|)))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$legendre_p|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(MEVAL '(($GRADEF) ((|$legendre_p|) |$n| |$x|)
         ((%DERIVATIVE) ((|%legendre_p|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) ((MMINUS) |$n|) |$x| ((|$legendre_p|) |$n| |$x|))
           ((MTIMES) |$n|
            ((|$legendre_p|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|)))
          ((MPLUS) 1 ((MMINUS) ((MEXPT) |$x| 2))))))
(PROGN
  (DEFPROP |$hermite| T TRANSLATED)
  (ADD2LNC '|$hermite| $PROPS)
  (DEFMTRFUN (|$hermite| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((MFUNCTION-CALL $INTEGERP |$n|)
            (COND
              ((MFUNCTION-CALL $EVENP |$n|)
               (SETQ |$n| (MFUNCTION-CALL |$floor_rat| |$n| 2))
               (SIMPLIFY
                   (MFUNCTION-CALL |$coerce_return_type| |$x|
                       (MUL* (POWER -1 |$n|) (POWER 4 |$n|)
                             (SIMPLIFY (LIST '(MFACTORIAL) |$n|))
                             (SIMPLIFY
                                 (MFUNCTION-CALL |$gen_laguerre| |$n|
                                     (RREMAINDER -1 2) (POWER |$x| 2)))))))
              (T (SETQ |$n| (MFUNCTION-CALL |$floor_rat| |$n| 2))
                 (SIMPLIFY
                     (MFUNCTION-CALL |$coerce_return_type| |$x|
                         (MUL* (POWER -1 |$n|)
                               (POWER 2 (ADD* (MUL* 2 |$n|) 1))
                               (SIMPLIFY (LIST '(MFACTORIAL) |$n|))
                               |$x|
                               (SIMPLIFY
                                   (MFUNCTION-CALL |$gen_laguerre| |$n|
                                    (RREMAINDER 1 2) (POWER |$x| 2)))))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$hermite|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(MEVAL '(($GRADEF) ((|$hermite|) |$n| |$x|)
         ((%DERIVATIVE) ((|%hermite|) |$n| |$x|) |$n|)
         ((MTIMES) 2 |$n|
          ((|$hermite|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|))))
(PROGN
  (DEFPROP |$spherical_hankel2| T TRANSLATED)
  (ADD2LNC '|$spherical_hankel2| $PROPS)
  (DEFMTRFUN (|$spherical_hankel2| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA (|$sofar| |$w| |$m|)
         (DECLARE (SPECIAL |$m| |$w| |$sofar|) (FIXNUM |$m|))
         NIL
         (COND
           ((MFUNCTION-CALL $INTEGERP |$n|)
            (COND
              ((IS-BOOLE-CHECK (MGRP |$n| -1)) (SETQ |$sofar| 1)
               (SETQ |$w| 1)
               (DO ((|$m| 0 (F+ 1 |$m|)))
                   ((IS-BOOLE-CHECK (MGRP |$m| |$n|)) '$DONE)
                 (SETQ |$w|
                       (DIV (MUL* |$w| (ADD* |$n| |$m| 1)
                                  (ADD* |$n| (- |$m|)))
                            (MUL* 2 '$%I |$x| (F+ |$m| 1))))
                 (SETQ |$sofar| (ADD* |$sofar| |$w|)))
               (SETQ |$sofar|
                     (DIV (MUL* (POWER '$%I (ADD* |$n| 1))
                                (SIMPLIFY
                                    ($EXP (MUL* (*MMINUS '$%I) |$x|)))
                                |$sofar|)
                          |$x|))
               (SIMPLIFY
                   (MFUNCTION-CALL |$coerce_return_type| |$x| |$sofar|)))
              (T (MUL* '$%I (POWER -1 |$n|)
                       (SIMPLIFY
                           (MFUNCTION-CALL |$spherical_hankel2|
                               (ADD* (*MMINUS |$n|) -1) |$x|))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$spherical_hankel2|
                      (LIST '(MLIST) |$n| |$x|))))))
       '|$sofar| '|$w| 0)))
(PROGN
  (DEFPROP |$spherical_hankel1| T TRANSLATED)
  (ADD2LNC '|$spherical_hankel1| $PROPS)
  (DEFMTRFUN (|$spherical_hankel1| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      (MUL* (POWER -1 |$n|)
            (SIMPLIFY
                (MFUNCTION-CALL |$spherical_hankel2| |$n|
                    (*MMINUS |$x|))))))
(PROGN
  (DEFPROP |$p_fun| T TRANSLATED)
  (ADD2LNC '|$p_fun| $PROPS)
  (DEFMTRFUN (|$p_fun| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|) (FIXNUM |$n|))
      ((LAMBDA (|$sofar| |$w| |$n1| |$m|)
         (DECLARE (SPECIAL |$m| |$n1| |$w| |$sofar|)
                  (FIXNUM |$m| |$n1|))
         NIL
         (SETQ |$sofar| 1)
         (SETQ |$w| 1)
         (SETQ |$n1| (F+ (MFUNCTION-CALL |$floor_rat| |$n| 2) -1))
         (DO ((|$m| 0 (F+ 1 |$m|))) ((> |$m| |$n1|) '$DONE)
           (SETQ |$w|
                 (DIV (MUL* (*MMINUS |$w|) (F+ |$n| (F* 2 |$m|) 2)
                            (F+ |$n| (F* 2 |$m|) 1)
                            (F+ |$n| (- (F* 2 |$m|)))
                            (F+ |$n| (- (F* 2 |$m|)) -1))
                      (MUL* 4 (F+ (F* 2 |$m|) 1) (F+ (F* 2 |$m|) 2)
                            (POWER |$x| 2))))
           (SETQ |$sofar| (ADD* |$sofar| |$w|)))
         |$sofar|)
       '|$sofar| '|$w| 0 0)))
(PROGN
  (DEFPROP |$q_fun| T TRANSLATED)
  (ADD2LNC '|$q_fun| $PROPS)
  (DEFMTRFUN (|$q_fun| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|) (FIXNUM |$n|))
      ((LAMBDA (|$sofar| |$w| |$n1| |$m|)
         (DECLARE (SPECIAL |$m| |$n1| |$w| |$sofar|)
                  (FIXNUM |$m| |$n1|))
         NIL
         (COND
           ((EQL |$n| 0) 0)
           (T (SETQ |$sofar| 1) (SETQ |$w| 1)
              (SETQ |$n1|
                    (F+ (MFUNCTION-CALL |$floor_rat| (F+ |$n| -1) 2)
                        -1))
              (DO ((|$m| 0 (F+ 1 |$m|))) ((> |$m| |$n1|) '$DONE)
                (SETQ |$w|
                      (DIV (MUL* (*MMINUS |$w|) (F+ |$n| (F* 2 |$m|) 3)
                                 (F+ |$n| (F* 2 |$m|) 2)
                                 (F+ |$n| (- (F* 2 |$m|)) -1)
                                 (F+ |$n| (- (F* 2 |$m|)) -2))
                           (MUL* 4 (F+ (F* 2 |$m|) 3)
                                 (F+ (F* 2 |$m|) 2) (POWER |$x| 2))))
                (SETQ |$sofar| (ADD* |$sofar| |$w|)))
              (DIV (MUL* (FACTORIAL (F+ |$n| 1)) |$sofar|)
                   (MUL* 2 |$x| (FACTORIAL (F+ |$n| -1)))))))
       '|$sofar| '|$w| 0 0)))
(PROGN
  (DEFPROP |$spherical_bessel_j| T TRANSLATED)
  (ADD2LNC '|$spherical_bessel_j| $PROPS)
  (DEFMTRFUN (|$spherical_bessel_j| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((MFUNCTION-CALL $INTEGERP |$n|)
            (COND
              ((IS-BOOLE-CHECK (MGRP |$n| -1))
               (DIV (ADD* (MUL* (SIMPLIFY
                                    (MFUNCTION-CALL |$p_fun| |$n| |$x|))
                                (SIMPLIFY
                                    (LIST '(%SIN)
                                     (ADD* |$x|
                                      (*MMINUS
                                       (DIV (MUL* |$n| '$%PI) 2))))))
                          (MUL* (SIMPLIFY
                                    (MFUNCTION-CALL |$q_fun| |$n| |$x|))
                                (SIMPLIFY
                                    (LIST '(%COS)
                                     (ADD* |$x|
                                      (*MMINUS
                                       (DIV (MUL* |$n| '$%PI) 2)))))))
                    |$x|))
              (T (MUL* (POWER -1 |$n|)
                       (SIMPLIFY
                           (MFUNCTION-CALL |$spherical_bessel_y|
                               (ADD* (*MMINUS |$n|) -1) |$x|))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$spherical_bessel_j|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(PROGN
  (DEFPROP |$spherical_bessel_y| T TRANSLATED)
  (ADD2LNC '|$spherical_bessel_y| $PROPS)
  (DEFMTRFUN (|$spherical_bessel_y| $ANY MDEFINE NIL NIL) (|$n| |$x|)
      (DECLARE (SPECIAL |$x| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((MFUNCTION-CALL $INTEGERP |$n|)
            (COND
              ((IS-BOOLE-CHECK (MGRP |$n| -1))
               (DIV (MUL* (POWER -1 (ADD* |$n| 1))
                          (ADD* (MUL* (SIMPLIFY
                                       (MFUNCTION-CALL |$p_fun| |$n|
                                        |$x|))
                                      (SIMPLIFY
                                       (LIST '(%COS)
                                        (ADD* |$x|
                                         (DIV (MUL* |$n| '$%PI) 2)))))
                                (*MMINUS (MUL*
                                          (SIMPLIFY
                                           (MFUNCTION-CALL |$q_fun|
                                            |$n| |$x|))
                                          (SIMPLIFY
                                           (LIST '(%SIN)
                                            (ADD* |$x|
                                             (DIV (MUL* |$n| '$%PI) 2))))))))
                    |$x|))
              (T (MUL* (POWER -1 (ADD* |$n| 1))
                       (SIMPLIFY
                           (MFUNCTION-CALL |$spherical_bessel_j|
                               (ADD* (*MMINUS |$n|) -1) |$x|))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$spherical_bessel_y|
                      (LIST '(MLIST) |$n| |$x|)))))))))
(MEVAL '(($GRADEF) ((|%spherical_hankel2|) |$n| |$x|)
         ((%DERIVATIVE) ((|%spherical_hankel2|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n|
            ((|$spherical_hankel2|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| 1)
             ((|$spherical_hankel2|) ((MPLUS) |$n| 1) |$x|))))
          ((MPLUS) ((MTIMES) 2 |$n|) 1))))
(MEVAL '(($GRADEF) ((|%spherical_hankel1|) |$n| |$x|)
         ((%DERIVATIVE) ((|%spherical_hankel1|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n|
            ((|$spherical_hankel1|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| 1)
             ((|$spherical_hankel1|) ((MPLUS) |$n| 1) |$x|))))
          ((MPLUS) ((MTIMES) 2 |$n|) 1))))
(MEVAL '(($GRADEF) ((|%spherical_bessel_j|) |$n| |$x|)
         ((%DERIVATIVE) ((|%spherical_bessel_j|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n|
            ((|$spherical_bessel_j|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| 1)
             ((|$spherical_bessel_j|) ((MPLUS) |$n| 1) |$x|))))
          ((MPLUS) ((MTIMES) 2 |$n|) 1))))
(MEVAL '(($GRADEF) ((|%spherical_bessel_y|) |$n| |$x|)
         ((%DERIVATIVE) ((|%spherical_bessel_y|) |$n| |$x|) |$n|)
         ((MQUOTIENT)
          ((MPLUS)
           ((MTIMES) |$n|
            ((|$spherical_bessel_y|) ((MPLUS) |$n| ((MMINUS) 1)) |$x|))
           ((MMINUS)
            ((MTIMES) ((MPLUS) |$n| 1)
             ((|$spherical_bessel_y|) ((MPLUS) |$n| 1) |$x|))))
          ((MPLUS) ((MTIMES) 2 |$n|) 1))))
(PROGN
  (DEFPROP |$assoc_leg_cos| T TRANSLATED)
  (ADD2LNC '|$assoc_leg_cos| $PROPS)
  (DEFMTRFUN (|$assoc_leg_cos| $ANY MDEFINE NIL NIL) (|$n| |$m| |$x|)
      (DECLARE (SPECIAL |$x| |$m| |$n|) (FIXNUM |$m| |$n|))
      ((LAMBDA (|$c|)
         (DECLARE (SPECIAL |$c|))
         NIL
         (COND
           ((EQL |$m| 0) (SETQ |$c| 1))
           (T (SETQ |$c|
                    (SIMPLIFY
                        (MFUNCTION-CALL $GENFACT (F+ (F* 2 |$m|) -1)
                            (RREMAINDER (F+ (F* 2 |$m|) -1) 2) 2)))))
         (MUL* |$c| (POWER (SIMPLIFY (LIST '(%SIN) |$x|)) |$m|)
               (SIMPLIFY
                   (MFUNCTION-CALL |$ultraspherical| (F+ |$n| (- |$m|))
                       (ADD* |$m| (RREMAINDER 1 2))
                       (SIMPLIFY (LIST '(%COS) |$x|))))))
       '|$c|)))
(PROGN
  (DEFPROP |$spherical_harmonic| T TRANSLATED)
  (ADD2LNC '|$spherical_harmonic| $PROPS)
  (DEFMTRFUN (|$spherical_harmonic| $ANY MDEFINE NIL NIL)
      (|$n| |$m| |$theta| |$phi|)
      (DECLARE (SPECIAL |$phi| |$theta| |$m| |$n|))
      ((LAMBDA ()
         NIL
         NIL
         (COND
           ((AND (MFUNCTION-CALL $INTEGERP |$n|)
                 (MFUNCTION-CALL $INTEGERP |$m|)
                 (IS-BOOLE-CHECK (MGRP |$n| -1))
                 (NOT (IS-BOOLE-CHECK (MGRP |$m| |$n|))))
            (COND
              ((IS-BOOLE-CHECK (MLSP |$m| 0))
               (MUL* (POWER -1 |$m|)
                     (SIMPLIFY
                         (MFUNCTION-CALL |$spherical_harmonic| |$n|
                             (*MMINUS |$m|) |$theta| (*MMINUS |$phi|)))))
              (T (RATF (MUL* (SIMPLIFY ($EXP (MUL* '$%I |$m| |$phi|)))
                             (SIMPLIFY (LIST '(%SQRT)
                                        (DIV
                                         (MUL* (ADD* (MUL* 2 |$n|) 1)
                                          (SIMPLIFY
                                           (LIST '(MFACTORIAL)
                                            (ADD* |$n| (*MMINUS |$m|)))))
                                         (MUL* 4 '$%PI
                                          (SIMPLIFY
                                           (LIST '(MFACTORIAL)
                                            (ADD* |$n| |$m|)))))))
                             (SIMPLIFY
                                 (MFUNCTION-CALL |$assoc_leg_cos| |$n|
                                     |$m| |$theta|)))))))
           (T (SIMPLIFY
                  (MFUNCTION-CALL $FUNMAKE '|$spherical_harmonic|
                      (LIST '(MLIST) |$n| |$m| |$theta| |$phi|)))))))))
(MEVAL '(($GRADEF) ((|$spherical_harmonic|) |$n| |$m| |$theta| |$phi|)
         ((%DERIVATIVE)
          ((|$spherical_harmonic|) |$n| |$m| |$theta| |$phi|) |$n|)
         ((%DERIVATIVE)
          ((|$spherical_harmonic|) |$n| |$m| |$theta| |$phi|) |$m|)
         ((MPLUS)
          ((MQUOTIENT)
           ((MTIMES)
            ((MMINUS)
             ((%SQRT)
              ((MTIMES) ((MPLUS) |$n| ((MMINUS) |$m|))
               ((MPLUS) |$n| |$m| 1))))
            (($EXP) ((MTIMES) ((MMINUS) $%I) |$phi|))
            ((|$spherical_harmonic|) |$n| ((MPLUS) |$m| 1) |$theta|
             |$phi|))
           2)
          ((MQUOTIENT)
           ((MTIMES)
            ((%SQRT)
             ((MTIMES) ((MPLUS) |$n| |$m|)
              ((MPLUS) |$n| ((MMINUS) |$m|) 1)))
            (($EXP) ((MTIMES) $%I |$phi|))
            ((|$spherical_harmonic|) |$n| ((MPLUS) |$m| ((MMINUS) 1))
             |$theta| |$phi|))
           2))
         ((MTIMES) $%I |$m|
          ((|$spherical_harmonic|) |$n| |$m| |$theta| |$phi|))))