/****************************************************************************

  module      : Trace_Entry.cpp

  -------------------------------------------------------------------------

  responsible : TorstenS

  special area:
  description : 

  last changed: 2000-11-27  18:15
  see also    :

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg90.h"          // CPP   : GG_kernel_templates
#include "ggg91.h"          // CPP   : GG_kernel_templates

#include "Trace/Trace_Entry.hpp"
#include "Trace/Trace_Manager.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

tgg00_Debug
Trace_OverflowEntry::GetLayer() const
{
    return( m_Layer ); 
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_OverflowEntry::GetSize() const
{
    return( m_EntrySize + INTERNAL_HEADER_SIZE ); 
}

/*---------------------------------------------------------------------------*/

tgg00_VtraceType
Trace_OverflowEntry::GetType() const
{
    return( m_Type ); 
}

/*---------------------------------------------------------------------------*/

bool
Trace_OverflowEntry::Materialize( 
                                 tsp00_BytePtr  pDestination,
                                 SAPDB_Int4     DestinationSize ) const
{
    
    if ( this->GetSize() > DestinationSize )
        return( false );
    
    SAPDB_Int4 Offset = 0;

    //Copy current part number into the trace
    memcpy( pDestination, &m_PartCount, sizeof( m_PartCount ));
    Offset += sizeof( m_PartCount );

    // Copy original trace layer of the complete entry into the trace
    memcpy(( pDestination + Offset ), &m_OriginalLayer, sizeof( m_OriginalLayer ));
    Offset += sizeof( m_OriginalLayer );

    // Copy proper entry into the trace
    memcpy(( pDestination + Offset ), m_pEntry, m_EntrySize );
    
    return( true );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

Trace_CommonEntry::~Trace_CommonEntry()
{
    Trace_Manager::GetInstance().Insert( m_Trans, *this );
};

/*---------------------------------------------------------------------------*/

tgg00_Debug
Trace_CommonEntry::GetLayer() const
{
    return( m_Layer ); 
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_CommonEntry::GetSize() const
{
    return( m_EntrySize );
}

/*---------------------------------------------------------------------------*/

tgg00_VtraceType
Trace_CommonEntry::GetType() const
{
    return( m_Type ); 
}

/*---------------------------------------------------------------------------*/

bool
Trace_CommonEntry::Materialize( 
                               tsp00_BytePtr  pDestination,
                               SAPDB_Int4     DestinationSize ) const
{
    if ( m_EntrySize > DestinationSize ) 
        return( false );
    
    memcpy( pDestination, m_pEntry, m_EntrySize );
    return( true );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

tgg00_Debug
Trace_LargeEntry::GetLayer() const
{
    return( m_Layer ); 
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_LargeEntry::GetNumberOfParts() const
{
    return( m_NumberOfParts ); 
}

/*---------------------------------------------------------------------------*/

tsp00_BytePtr
Trace_LargeEntry::GetPart() const
{
    return( m_pCurrentPart );
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4 
Trace_LargeEntry::GetPartNo() const
{
    return( m_CurrentPartNo );
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_LargeEntry::GetPartSize() const
{
    return( m_CurrentPartSize );
}

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_LargeEntry::GetSize() const
{
    // This is the size of the complete entry if it is materialized
    // in one or more than one trace entries.
    return( 
        m_EntrySize + 
        ( GetNumberOfParts() * INTERNAL_HEADER_SIZE ));
}

/*---------------------------------------------------------------------------*/

tgg00_VtraceType
Trace_LargeEntry::GetType() const
{
    return( m_Type );
}

/*---------------------------------------------------------------------------*/

bool 
Trace_LargeEntry::PartEndReached() const
{
    return( m_CurrentPartNo > m_NumberOfParts );
}

/*---------------------------------------------------------------------------*/

void
Trace_LargeEntry::SetToFirstPart()
{
    m_CurrentPartNo   = 1;
    m_pCurrentPart    = m_pEntry;
    m_CurrentPartSize = 
        ( UsablePartSize() < m_EntrySize ) ? UsablePartSize() : m_EntrySize;
}

/*---------------------------------------------------------------------------*/

void
Trace_LargeEntry::SetToNextPart()
{
    ++m_CurrentPartNo;
    m_pCurrentPart += m_CurrentPartSize;
    
    if ( m_CurrentPartNo < m_NumberOfParts ) return;
    
    // Last part of the complete trace entry is reached
    m_CurrentPartSize = ( m_EntrySize % this->UsablePartSize() );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

Trace_KernelFullEntry::Trace_KernelFullEntry( 
                                             tgg00_TransContext &Trans,
                                             Trace_IBaseEntry   &Entry,
                                             Trace_SeqNo        SequenceNo)
:
m_Info( Entry )
{
    
    m_Header.vhLen_gg11         = tsp00_Int2 (( sizeof( tgg11_VtraceHeader ) + Entry.GetSize() )); // cast to avoid warning C4244 on IA64
    m_Header.vhLayer_gg11       = Entry.GetLayer();
    m_Header.vhType_gg11        = Entry.GetType();
    m_Header.vhTask_gg11        = Trans.trTaskId_gg00;
    m_Header.vhSequenceNo_gg11  = SequenceNo;

    if (! Trans.trWriteTransId_gg00.gg90IsNil() )
        m_Header.vhTrans_gg11  = Trans.trWriteTransId_gg00; //PTS 1108234 JA 2000-12-12
    else
        m_Header.vhTrans_gg11  = Trans.trTransId_gg00;

    if ( NIL_BYTE_GG90 == Trans.trSessionId_gg00[0] )
        m_Header.vhSession_gg11 = Trans.trSessionId_gg00;
    else
        m_Header.vhSession_gg11.gg91BuildInternalTraceSession( Trans.trSubtransId_gg00 );
}

/*---------------------------------------------------------------------------*/

Trace_SeqNo 
Trace_KernelFullEntry::GetSequenceNo() const
{
    return( m_Header.vhSequenceNo_gg11 );
}

/*---------------------------------------------------------------------------*/
    
SAPDB_Int4  
Trace_KernelFullEntry::GetSize() const
{
    return( m_Header.vhLen_gg11 );
}

/*---------------------------------------------------------------------------*/

bool 
Trace_KernelFullEntry::IsValid() const
{
    return
        ( 
        ( 0 < m_Header.vhLen_gg11 ) && 
        ( Trace_IBaseEntry::MaximumSize() + sizeof( m_Header ) 
        > SAPDB_UInt4 (m_Header.vhLen_gg11) ) // cast to avoid warning C4018 on NT
        );
}

/*---------------------------------------------------------------------------*/

bool 
Trace_KernelFullEntry::Materialize( 
                                   tsp00_BytePtr    pDestination,
                                   SAPDB_Int4       DestinationSize  ) const
{
    if ( this->GetSize() > DestinationSize ) 
        return( false );
        
    // Copy m_header to destination
    memcpy( pDestination, &m_Header, sizeof( m_Header ));
    pDestination    += sizeof( m_Header );
    DestinationSize -= sizeof( m_Header );

    // Build entry body on destination space
    return( m_Info.Materialize( pDestination, DestinationSize ));
}


/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
