/*!***************************************************************************

  module      : SQLMan_Context.cpp

  -------------------------------------------------------------------------

  responsible : ThomasA

  special area: SQL Manager
  description : defines SQL manager context.

  last changed: 2000-12-06  19:04
  see also    : example.html ...
  first created:2000-03-09  18:21

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

#include "hak06.h"
#include "hak07.h"
#include "hak10.h"
#include "hak101.h"
#include "hak262.h"
#include "hak91.h"
#include "heo58.h"
#include "SQLManager/SQLMan_Context.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "SQLManager/SQLMan_ContextSessionMembers.hpp"
#include "SQLManager/SQLMan_MessBlock.hpp"
#include "SQLManager/SQLMan_Tracing.hpp"

SQLMan_Context::SQLMan_Context(SQLMan_TransContext& transContext)
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::SQLMan_Context", SQLMan_Trace, 5);
    memset             ( this, 0, sizeof(*this));
    a91init_acv        (*this, transContext);
    a10_init_cache     (*this);
    a91AllocateBuffers (*this);
}

/*----------------------------------------------------------------*/

SQLMan_Context::~SQLMan_Context()
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::~SQLMan_Context", SQLMan_Trace, 5);
    a10free_cache (*this);
    a91free_mem   (*this, false);
}

/*----------------------------------------------------------------*/

void SQLMan_Context::DestroyCppMembers()
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::DestroyCppMembers", SQLMan_Trace, 5);
    SQLMan_ContextSessionMembers* p = REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members);
    if (p)
    {
        destroy(p, this->GetAllocator());
    }
    a_cpp_session_members = NULL;
}

/*----------------------------------------------------------------*/

SQLMan_Context* SQLMan_Context::GetContext()
{
    return REINTERPRET_CAST(SQLMan_Context*, vGetAcvPtrFromCurrentTask());
}

/*----------------------------------------------------------------*/

SQLMan_SessionInfo& SQLMan_Context::GetSessionInfo()
{
    return CppMembers().m_sessionInfo;
}

/*----------------------------------------------------------------*/

SQLMan_ContextSessionMembers& SQLMan_Context::CppMembers()
{
    return *REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members);
}

const SQLMan_ContextSessionMembers& SQLMan_Context::CppMembersConst() const
{
    return *REINTERPRET_CAST(const SQLMan_ContextSessionMembers*, a_cpp_session_members);
}

bool SQLMan_Context::IsStatementActive(SAPDB_Int statementId) const
{
    return CppMembersConst().m_activeStatementDirectory.IsActive(statementId);
}

SAPDB_Int4 SQLMan_Context::RegisterCurrentStatement()
{
    if (CppMembers().m_activeStatementDirectory.RegisterStatement(a_command_count))
    {
      return a_command_count;
    }
    else
    {
        return -1;
    }
}

void SQLMan_Context::UnregisterStatement(SAPDB_Int4 statementId)
{
    CppMembers().m_activeStatementDirectory.UnregisterStatement(statementId);
}

void SQLMan_Context::ReleaseDDLLock()
{
    CppMembers().ReleaseDDLLock();
}

void SQLMan_Context::RequireDDLLock()
{
    CppMembers().RequireDDLLock();
}

/*----------------------------------------------------------------*/

DBProc_Debugger* SQLMan_Context::GetDBProcDebugger() const
{
    return  REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_dbprocDebugger;
}

/*----------------------------------------------------------------*/

SAPDBErr_MessageList& SQLMan_Context::GetErrorList() const
{
    return REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_errorList;
}

void SQLMan_Context::ResetErrorList()
{
    REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_errorList.ClearMessageList();
}

bool SQLMan_Context::IsErrorListEmpty() const
{
    return REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_errorList.IsEmpty();
}
/*----------------------------------------------------------------*/

SysView_PseudoLongHandler& SQLMan_Context::GetPseudoLongHandler() const
{
    return REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)-> m_pseudoLongHandler;
}

/*----------------------------------------------------------------*/

Catalog_ISessionCache& SQLMan_Context::GetSessionCatalogCache()
{
    return REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_sessionCache;
}

/*----------------------------------------------------------------*/

SharedSQL_SQLCache& SQLMan_Context::GetSharedSQL_SQLCache()
{
    return REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_sharedSQL_SQLCache;
}

/*----------------------------------------------------------------*/

void SQLMan_Context::InitCppMembers()
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::InitCppMembers", SQLMan_Trace, 5);
    a_cpp_session_members = new(this->GetAllocator()) SQLMan_ContextSessionMembers(*this);
}

/*----------------------------------------------------------------*/

void SQLMan_Context::IncrementSyntaxTree()
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::IncrementSyntaxTree", SQLMan_Trace, 5);
    if (a_ap_tree != a_session_ap_tree)
    {
        // grow by 128 nodes
        const int supplement = 128;
        int newSize    = (a_ap_max_node + 1 + supplement) * sizeof(tak_ap_node);
        void* pNewTree = GetAllocator().Reallocate(newSize, a_ap_tree);
        if (pNewTree)
        {
            a_ap_tree      = REINTERPRET_CAST(tak_ap_max_tree_ptr, pNewTree);
            a_ap_max_node += supplement;
        }
        else
        {
            SetNoMoreMemoryError();
        }
    }
}

/*----------------------------------------------------------------*/

void SQLMan_Context::NewSyntaxTree(int size)
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::NewSyntaxTree", SQLMan_Trace, 5);
    a_ap_tree = REINTERPRET_CAST(tak_ap_max_tree_ptr, GetAllocator().Allocate(size * sizeof(tak_ap_node)));
    if (a_ap_tree)
    {
        a_ap_max_node = size - 1;
    }
    else
    {
        SetNoMoreMemoryError();
    }
}

/*----------------------------------------------------------------*/

void  SQLMan_Context::RestoreMessBlock(void* pSavedMessBlock)
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::RestoreMessBlock", SQLMan_Trace, 5);
    SQLMan_MessBlock* pMessBlock = REINTERPRET_CAST(SQLMan_MessBlock*, pSavedMessBlock);
    a_mblock.mb_data_len() = 0;
    a06cpy_mblock (*this, *pMessBlock, a_mblock, false, a_mblock.mb_trns()->trError_gg00);
    pMessBlock->DestroyParts(this->GetAllocator());
    this->GetAllocator().Deallocate(pMessBlock);
}

/*----------------------------------------------------------------*/

void* SQLMan_Context::SaveMessBlock()
{
    SAPDBTRACE_METHOD_DEBUG ("SQLMan_Context::SaveMessBlock", SQLMan_Trace, 5);
    SAPDB_UInt4 dummy;
    SQLMan_MessBlock* pMessBlock = REINTERPRET_CAST(SQLMan_MessBlock*, &a_mblock);
    return SQLMan_MessBlock::CreateCopy(*pMessBlock, this->GetAllocator(), 0, dummy); 
}

/*----------------------------------------------------------------*/

void SQLMan_Context::SetDBProcDebugger(DBProc_Debugger* p)
{
    REINTERPRET_CAST(SQLMan_ContextSessionMembers*, a_cpp_session_members)->m_dbprocDebugger = p;
}

/*----------------------------------------------------------------*/

void SQLMan_Context::SetNoMoreMemoryError()
{
   a07_b_put_error (*this, e_no_more_memory, 1);
}

/*----------------------------------------------------------------*/

void SQLMan_Context::SetSharedSQL()
{
    a_createSharedSQL = a101_SharedSQL_GetStatusParameter();
}

/*----------------------------------------------------------------*/

void SQLMan_Context::SetStopMsg (SAPDB_Int2 rc,
                                 const void* msg,
                                 int         msgLength)
{
     a262stop (this, rc, msgLength, REINTERPRET_CAST(tsp00_MoveObjPtr, CONST_CAST(void*, msg)));
}

/*----------------------------------------------------------------*/

void SQLMan_Context::ThrowError (SAPDB_Int2 error, int errorPos)
{
   a07_b_put_error (*this, error, errorPos);
}
