/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class ClientStatementSapDB
    implements java.sql.Statement
{
    private ClientConnectionSapDB clientConnection;
    private Statement             originalStatement;
    
    public ClientStatementSapDB(Statement originalStatement, 
                                ClientConnectionSapDB clientConnection)
    {
        this.clientConnection=clientConnection;
        this.originalStatement=originalStatement;
    }

    public void exceptionOccurred(SQLException sqlEx)
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }
    
    public void close() throws SQLException
    {
        try {
            originalStatement.close();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int param2) throws SQLException
    {
        try {
            return originalStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, String[] param2) throws SQLException
    {
        try {
            return originalStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1) throws SQLException
    {
        try {
            return originalStatement.execute(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int[] param2) throws SQLException
    {
        try {
            return originalStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Connection getConnection() throws SQLException
    {
        return clientConnection;
    }

    public SQLWarning getWarnings() throws SQLException
    {
        try {
            return originalStatement.getWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearWarnings() throws SQLException
    {
        try {
            originalStatement.clearWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet executeQuery(String param1) throws SQLException
    {
        try {
            ResultSet tmp = originalStatement.executeQuery(param1);
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, String[] param2) throws SQLException
    {
        try {
            return originalStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1) throws SQLException
    {
        try {
            return originalStatement.executeUpdate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int[] param2) throws SQLException
    {
        try {
            return originalStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int param2) throws SQLException
    {
        try {
            return originalStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxFieldSize() throws SQLException
    {
        try {
            return originalStatement.getMaxFieldSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxFieldSize(int param1) throws SQLException
    {
        try {
            originalStatement.setMaxFieldSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxRows() throws SQLException
    {
        try {
            return originalStatement.getMaxRows();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxRows(int param1) throws SQLException
    {
        try {
            originalStatement.setMaxRows(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setEscapeProcessing(boolean param1) throws SQLException
    {
        try {
            originalStatement.setEscapeProcessing(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getQueryTimeout() throws SQLException
    {
        try {
            return originalStatement.getQueryTimeout();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setQueryTimeout(int param1) throws SQLException
    {
        try {
            originalStatement.setQueryTimeout(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void cancel() throws SQLException
    {
        try {
            originalStatement.cancel();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setCursorName(String param1) throws SQLException
    {
        try {
            originalStatement.setCursorName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getResultSet() throws SQLException
    {
        try {
            ResultSet tmp = originalStatement.getResultSet();
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getUpdateCount() throws SQLException
    {
        try {
            return originalStatement.getUpdateCount();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults(int param1) throws SQLException
    {
        try {
            return originalStatement.getMoreResults(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults() throws SQLException
    {
        try {
            return originalStatement.getMoreResults();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchDirection(int param1) throws SQLException
    {
        try {
            originalStatement.setFetchDirection(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchDirection() throws SQLException
    {
        try {
            return originalStatement.getFetchDirection();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchSize(int param1) throws SQLException
    {
        try {
            originalStatement.setFetchSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchSize() throws SQLException
    {
        try {
            return originalStatement.getFetchSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetConcurrency() throws SQLException
    {
        try {
            return originalStatement.getResultSetConcurrency();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetType() throws SQLException
    {
        try {
            return originalStatement.getResultSetType();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void addBatch(String param1) throws SQLException
    {
        try {
            originalStatement.addBatch(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearBatch() throws SQLException
    {
        try {
            originalStatement.clearBatch();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int[] executeBatch() throws SQLException
    {
        try {
            return originalStatement.executeBatch();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException
    {
        try {
            ResultSet tmp = originalStatement.getGeneratedKeys();
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetHoldability() throws SQLException
    {
        try {
            return originalStatement.getResultSetHoldability();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

}
