/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.*;

/**
 *
 */
public class UnicodeStringTranslator
    extends StringTranslator
{
    /**
     * @param mode
     * @param ioType
     * @param dataType
     * @param len
     * @param ioLen
     * @param bufpos
     * @param readOnly
     * @param autoIncr
     */
    UnicodeStringTranslator(int mode, int ioType, int dataType, int len,
            int ioLen, int bufpos, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
        characterDatatypePostfix = " UNICODE";
    }
    /**
     *
     * @return java.lang.String
     */
     public String getString (SQLParamController controller, StructuredMem mem) throws java.sql.SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
          byte[] bytes = mem.getBytes(this.bufpos, this.logicalLength*2);
          result = StringUtil.trimLeft(UnicodeUtil.bigUnicode2String(bytes));
        }
        return  result;
    }
     
     public byte[] getBytes (
             SQLParamController controller,
             StructuredMem mem)
         throws SQLException
         {
             String result = this.getString(controller,mem);
             if (result != null)
                try {
                    return result.getBytes("UTF-16BE");
                } catch (UnsupportedEncodingException ex) {
                    throw this.newParseException (result, "UTF-16BE");
                }
            else
               return null;
         }
    /**
     *
     * @return byte[]
     */
    public Object transBytesForInput (
            byte [] val)
    throws java.sql.SQLException
    {
        if (val == null) {
            return val;
        }
        this.checkFieldLimits (val.length);
        return val;
    }
    /**
     *
     * @param newValue java.lang.String
     */
    public Object transStringForInput (
        String arg)
    throws java.sql.SQLException
    {
        if (arg == null) {
            return null;
        }
        char [] chars = arg.toCharArray ();
        byte [] bytes = UnicodeUtil.char2BigUnicode (chars);
        this.checkFieldLimits (bytes.length);
        return bytes;
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     * @param data java.lang.Object
     */
    protected void putSpecific (
        DataPart dataPart,
        Object data)
    {
        dataPart.putDefineByte ((byte) 1, this.bufpos - 1);
        dataPart.putUnicodeBytes ((byte []) data, this.bufpos, this.physicalLength - 1);
    }
}
