package com.sap.dbtech.jdbc.translators;

/**
 * Title:        SAP DB JDBC Driver 3.0
 * Description:
 *     ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
 */
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;


public class SpaceoptionUnicodeStringTranslator extends UnicodeStringTranslator
{
    /**
     * @param mode
     * @param ioType
     * @param dataType
     * @param len
     * @param ioLen
     * @param bufpos
     * @param readOnly
     * @param autoIncr
     */
    SpaceoptionUnicodeStringTranslator(int mode, int ioType, int dataType,
            int len, int ioLen, int bufpos, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
    }

    /**
     *
     * @return java.lang.String
     */
     public String getString (SQLParamController controller, StructuredMem mem) throws java.sql.SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
          byte[] bytes = mem.getBytes(this.bufpos, this.logicalLength*2);
          result = StringUtil.trimLeft(UnicodeUtil.bigUnicode2String(bytes));
          if (result.length()==0)
              result = " ";
        }
        return  result;
    }
}
