/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class DataSourceSapDBBase {
    public static final int DEFAULT_LOGINTIMEOUT = 30;
    protected Properties connectProperties = new Properties();
    protected PrintWriter logWriter;

    public DataSourceSapDBBase() {
        this.connectProperties.setProperty("serverName", "localhost");
        this.connectProperties.setProperty("port", "7210");
    }

    public String getUser() {
        return this.connectProperties.getProperty("user");
    }

    public void setLoginTimeout(int n) {
        this.connectProperties.setProperty("logintimeout", Integer.toString(n));
    }

    public int getLoginTimeout() {
        String string = this.connectProperties.getProperty("logintimeout");
        if (string == null) {
            return 30;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 30;
        }
    }

    public void setTimeout(int n) {
        this.connectProperties.setProperty("timeout", Integer.toString(n));
    }

    public int getTimeout() {
        String string = this.connectProperties.getProperty("timeout");
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getPassword() {
        return this.connectProperties.getProperty("password");
    }

    public String getDescription() {
        return this.connectProperties.getProperty("description");
    }

    public String getDatabaseName() {
        return this.connectProperties.getProperty("databaseName");
    }

    public String getServerName() {
        return this.connectProperties.getProperty("serverName");
    }

    public String getSqlMode() {
        return this.connectProperties.getProperty("sqlmode", "INTERNAL");
    }

    public void setUser(String string) {
        this.connectProperties.setProperty("user", string);
    }

    public void setPassword(String string) {
        this.connectProperties.setProperty("password", string);
    }

    public void setDatabaseName(String string) {
        this.connectProperties.setProperty("databaseName", string.toUpperCase());
    }

    public void setServerName(String string) {
        this.connectProperties.setProperty("serverName", string);
    }

    public void setPort(int n) {
        this.connectProperties.setProperty("port", Integer.toString(n));
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.connectProperties.getProperty("port", "7210"));
        }
        catch (NumberFormatException numberFormatException) {
            return 7210;
        }
    }

    public void setUrl(String string) {
        this.setServerName(this.serverNameFromUrl(string));
        this.setDatabaseName(this.databaseNameFromUrl(string));
        this.setPort(this.portFromUrl(string));
    }

    public String getURL() {
        return "jdbc:sapdb://" + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
    }

    private int portFromUrl(String string) {
        int n;
        String string2;
        int n2 = string.length();
        int n3 = 7210;
        int n4 = "jdbc:sapdb:".length();
        if (n2 >= n4 + 3 && string.substring(n4, n4 + 2).equals("//") && (string2 = string.substring(n4 + 2, n = string.indexOf(47, n4 + 2))).indexOf(":") != -1) {
            try {
                n3 = Integer.parseInt(string2.substring(string2.indexOf(":") + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n3;
    }

    private String serverNameFromUrl(String string) {
        String string2;
        int n;
        int n2 = string.length();
        if (n2 >= (n = "jdbc:sapdb:".length()) + 3 && string.substring(n, n + 2).equals("//")) {
            int n3 = string.indexOf(47, n + 2);
            string2 = string.substring(n + 2, n3);
            if (string2.length() == 0) {
                string2 = "localhost";
            }
            if (string2.indexOf(":") != -1) {
                string2 = string2.substring(0, string2.indexOf(":"));
            }
        } else {
            string2 = "localhost";
        }
        return string2;
    }

    private String databaseNameFromUrl(String string) {
        String string2;
        int n;
        int n2 = string.length();
        if (n2 >= (n = "jdbc:sapdb:".length()) + 3 && string.substring(n, n + 2).equals("//")) {
            int n3 = string.indexOf(47, n + 2);
            string2 = string.substring(n3 + 1, n2);
        } else {
            string2 = string.substring(n, n2);
        }
        return string2.toUpperCase();
    }

    public void setSqlMode(String string) {
        this.connectProperties.setProperty("sqlmode", string);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setTransport(String string) {
        this.connectProperties.setProperty("transport", string);
    }

    public String getTransport() {
        return this.connectProperties.getProperty("transport", "socket");
    }

    public String getCache() {
        return this.connectProperties.getProperty("cache");
    }

    public void setCache(String string) {
        this.connectProperties.setProperty("cache", string);
    }

    public void setCacheSize(String string) {
        this.connectProperties.setProperty("cachesize", string);
    }

    public String getCacheSize() {
        return this.connectProperties.getProperty("cachesize");
    }

    public void setUnicode(String string) {
        this.connectProperties.setProperty("unicode", string);
    }

    public String getUnicode() {
        return this.connectProperties.getProperty("unicode", "false");
    }

    public void setSpaceOption(String string) {
        this.connectProperties.setProperty("spaceoption", string);
    }

    public String getSpaceOption() {
        return this.connectProperties.getProperty("spaceoption", "false");
    }

    public void setReconnect(String string) {
        this.connectProperties.setProperty("reconnect", string);
    }

    public String getReconnect() {
        return this.connectProperties.getProperty("reconnect");
    }

    public void setTrace(String string) {
        this.connectProperties.setProperty("trace", string);
    }

    public String getTrace() {
        return this.connectProperties.getProperty("trace");
    }

    public void setTraceSize(String string) {
        this.connectProperties.setProperty("tracesize", string);
    }

    public String getTraceSize() {
        return this.connectProperties.getProperty("tracesize");
    }

    public void setXATrace(String string) {
        this.connectProperties.setProperty("xatrace", string);
    }

    public String getXATrace() {
        return this.connectProperties.getProperty("xatrace");
    }

    public void setProperties(Properties properties) {
        this.connectProperties = (Properties)properties.clone();
        if (this.connectProperties.getProperty("url") != null && this.connectProperties.getProperty("databaseName") == null) {
            this.setUrl(this.connectProperties.getProperty("url"));
        }
    }

    public Connection openPhysicalConnection() throws SQLException {
        Properties properties = (Properties)this.connectProperties.clone();
        String string = properties.getProperty("serverName", "localhost");
        String string2 = properties.getProperty("databaseName");
        if (string2 == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.database.notset"));
        }
        String string3 = "jdbc:sapdb://" + string + ":" + this.getPort() + "/" + string2;
        return DriverSapDB.singleton().connect(string3, properties);
    }

    public Connection openPhysicalConnection(String string, String string2) throws SQLException {
        Properties properties = (Properties)this.connectProperties.clone();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        String string3 = properties.getProperty("serverName", "localhost");
        String string4 = properties.getProperty("databaseName");
        if (string4 == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.database.notset"));
        }
        String string5 = "jdbc:sapdb://" + string3 + ":" + this.getPort() + "/" + string4;
        return DriverSapDB.singleton().connect(string5, properties);
    }

    public Connection openPhysicalConnection(Properties properties) throws SQLException {
        String string = properties.getProperty("serverName", "localhost");
        String string2 = properties.getProperty("databaseName");
        if (string2 == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.database.notset"));
        }
        String string3 = "jdbc:sapdb://" + string + ":" + properties.getProperty("port", "7210") + "/" + string2;
        return DriverSapDB.singleton().connect(string3, properties);
    }

    protected Reference createReference(String string) {
        Reference reference = new Reference(string, "com.sap.dbtech.jdbcext.DataSourceSapDBFactory", null);
        if (this.getUser() != null) {
            reference.add(new StringRefAddr("user", this.getUser()));
        }
        reference.add(new StringRefAddr("logintimeout", Integer.toString(this.getLoginTimeout())));
        if (this.connectProperties.getProperty("timeout") != null) {
            reference.add(new StringRefAddr("timeout", Integer.toString(this.getTimeout())));
        }
        if (this.getPassword() != null) {
            reference.add(new StringRefAddr("password", this.getPassword()));
        }
        if (this.getDescription() != null) {
            reference.add(new StringRefAddr("description", this.getDescription()));
        }
        if (this.getDatabaseName() != null) {
            reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        }
        if (this.getServerName() != null) {
            reference.add(new StringRefAddr("serverName", this.getServerName()));
        }
        if (this.getSqlMode() != null) {
            reference.add(new StringRefAddr("sqlmode", this.getSqlMode()));
        }
        reference.add(new StringRefAddr("port", Integer.toString(this.getPort())));
        if (this.getTransport() != null) {
            reference.add(new StringRefAddr("transport", this.getTransport()));
        }
        if (this.getCache() != null) {
            reference.add(new StringRefAddr("cache", this.getCache()));
        }
        if (this.getCacheSize() != null) {
            reference.add(new StringRefAddr("cachesize", this.getCacheSize()));
        }
        if (this.getUnicode() != null) {
            reference.add(new StringRefAddr("unicode", this.getUnicode()));
        }
        if (this.getReconnect() != null) {
            reference.add(new StringRefAddr("reconnect", this.getReconnect()));
        }
        if (this.getTrace() != null) {
            reference.add(new StringRefAddr("trace", this.getTrace()));
        }
        if (this.getTraceSize() != null) {
            reference.add(new StringRefAddr("tracesize", this.getTraceSize()));
        }
        if (this.getXATrace() != null) {
            reference.add(new StringRefAddr("xatrace", this.getXATrace()));
        }
        return reference;
    }
}

