/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimestampTranslator;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class UnicodeTimestampTranslator
extends TimestampTranslator {
    UnicodeTimestampTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        super(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[1] - 48) * 1000;
            n += (byArray[3] - 48) * 100;
            n += (byArray[5] - 48) * 10;
            n += byArray[7] - 48;
            int n2 = (byArray[11] - 48) * 10;
            n2 += byArray[13] - 48;
            int n3 = (byArray[17] - 48) * 10;
            n3 += byArray[19] - 48;
            int n4 = (byArray[23] - 48) * 10;
            n4 += byArray[25] - 48;
            int n5 = (byArray[29] - 48) * 10;
            n5 += byArray[31] - 48;
            int n6 = (byArray[35] - 48) * 10;
            n6 += byArray[37] - 48;
            int n7 = (byArray[41] - 48) * 100;
            n7 += (byArray[43] - 48) * 10;
            int n8 = ((n7 += byArray[45] - 48) * 10 + (byArray[47] - 48)) * 100;
            n8 += (byArray[49] - 48) * 10;
            n8 += byArray[51] - 48;
            n8 *= 1000;
            if (calendar == null) {
                timestamp = new Timestamp(n - 1900, n2 - 1, n3, n4, n5, n6, n8);
            } else {
                calendar.clear();
                calendar.set(n, n2 - 1, n3, n4, n5, n6);
                timestamp = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, n8);
            }
        }
        return timestamp;
    }

    protected void putSpecific(DataPart dataPart, Object object) {
        dataPart.putDefineByte(1, this.bufpos - 1);
        dataPart.putUnicodeBytes((byte[])object, this.bufpos, this.physicalLength - 1);
    }

    public Object transTimestampForInput(Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = (byte[])super.transTimestampForInput(timestamp, calendar);
        byte[] byArray2 = UnicodeUtil.bytes2BigUnicode(byArray);
        this.checkFieldLimits(byArray2.length);
        return byArray2;
    }
}

