/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <ctype.h>

#include "mserver.h"

/* Ripped from system man page */
int util_system_wait (const char *command)
{
	extern char **environ;

	int pid, status;
	char my_command[1024];

	if (command == NULL)
	{
		return -1;
	}

	strncpy(my_command, command, 1024);

    	pid = fork();

	if (pid == -1)
	{
        	return -1;
	}
	else if (pid == 0)
	{
		char *myargv[4];

		myargv[0] = "sh";
		myargv[1] = "-c";
		myargv[2] = my_command;
		myargv[3] = 0;

		execve("/bin/sh", myargv, environ);
		/* if everyting works well we'll never get here */
		exit(127);
	}

	do
	{
		if (waitpid(pid, &status, 0) == -1)
		{
			if (errno != EINTR)
			{
				return -1;
			}
		}
		else
		{
			return status;
		}
	}
	while(1);
}

/* Taken from man system(3), and modified to execute in the background */
int util_system (const char *command)
{
	extern char **environ;

	int pid;
	char my_command[1024];

	strncpy(my_command, command, 1024);

	if (command == 0)
	{
		return 1;
	}

    	pid = fork();

	if (pid == -1)
	{
        	return -1;
	}

	if (pid == 0)
	{
		char *myargv[4];
		myargv[0] = "sh";
		myargv[1] = "-c";
		myargv[2] = my_command;
		myargv[3] = 0;
		execve("/bin/sh", myargv, environ);
		exit(127);
	}

	return 0;
}

/* This was originally here for debugging purposes now it is just pretty useless */
unsigned int util_sleep(int sec)
{
	unsigned int retval;

	retval = sleep (sec);
	
	return retval;
}

/* unlink, but will warn about errors */
int util_unlink(const char *pathname)
{
	char error[1024];
	int retval;

	if (!strncmp(pathname, "", 1024))
	{
		syslog(LOG_ERR, "Null Pathname passed to util_unlink!");
		return -1;
	}
	
	retval = unlink(pathname);
	
	if (retval != 0)
	{
		strncpy (error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could not unlink \"%s\": %s", pathname, error);	
	}	
	
	return retval;
}

/* same as time, but will send errors to the syslog */
time_t util_time(time_t *curtime)
{
	char error[1024];

	time_t ret_time;
	time_t pnt_time;

	ret_time = time(&pnt_time);

	if (ret_time != pnt_time)
	{
		strncpy(error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could not get current time: %s", error);
		if (curtime != 0)
		{
			*curtime = 0;
		}
		return 0;
	}
	
	if (curtime != 0)
	{
		*curtime = ret_time;	
	}
	return ret_time;
}

/* fflush, but will warn about errors */
int util_fflush(FILE *stream)
{
	char error[1024];
	int retval;

	retval = fflush(stream);
	
	if (retval != 0)
	{
		strncpy (error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could not flush stream: %s", error);	
	}	
	return retval;
}

/* shutdown, but will warn about errors */
int util_shutdown(int s, int how)
{
	char error[1024];
	int retval;

	retval = shutdown(s, how);
	
	if (retval != 0)
	{
		strncpy (error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could shutdown socket: %s", error);	
	}	

	return retval;
}

/* close, but will warn about errors */
int util_close(int fd)
{
	char error[1024];
	int retval;

	retval = close(fd);
	
	if (retval != 0)
	{
		strncpy (error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could close file (%d): %s", fd, error);	
	}	

	return retval;
}

/* malloc, but will warn about errors */
void *util_malloc(size_t size)
{
	char error[1024];
	void *retval;

	retval = malloc(size);
	
	if (retval == NULL)
	{
		strncpy (error, strerror(errno), 1024);
		syslog(LOG_ERR, "Could not allocate memory: %s", error);	
	}	

	return retval;
}


/*
    Author: Mike Klinkert <michael@cs.vu.nl>

    - bool util_validip(char *ipver);
 	Check if the specified IP-address is valid. If not, return false,
        otherwise return true. It is based on the function auth_checkip_backend
        in the file auth.c
*/
bool util_validip(const char *ipver)
{
	int i, n;
	size_t len;

	n = 0;

	len = strlen(ipver);
	
	for (i = 0; i <= len; i++)
	{
		if (!isdigit(ipver[i]) && (ipver[i] != '.') && (ipver[i] != '\0'))
		{
			syslog(LOG_ERR, "Invalid characters in ip address: '%c'!", ipver[i]);
			return false;
		}
		else
		{
			if (n <= 15)
			{
				n++;
			}
			else
			{
				syslog(LOG_ERR, "Invalid IP address, exceeds 15 characters: %s", ipver);
				return false;
			}
		}
	}
	return true;
}

/*
 *  The following code was originally lifted from samba-2.0.0beta2 and was
 *  bastardized for the masqdialer server, it is under the GNU General
 *  Public License and portions are Copyright (C) 1992-1998 Andrew Tridgell
 */
int util_select(int maxfd, fd_set *fds)
{
	char error[1024];

	int selrtn;

	syslog (LOG_DEBUG, "maxfd: %d", maxfd);

	do
	{

		syslog(LOG_DEBUG, "Select on socket descriptors");
		errno = 0;
		selrtn = select(maxfd, fds, NULL, NULL, NULL);
		
		if (errno != 0)
		{
			if (errno == EINTR)
			{
				syslog(LOG_DEBUG, "Select interrupted");
#ifndef UTIL
				if (child_count() == 0)
				{
					syslog(LOG_INFO, "No more clients left!");
					if (config_getvalue_bool("zeroclientdisconnect", false) == true)
					{
						if (getstat())
						{	
							syslog(LOG_INFO, "Disconnecting modem");
							mserver_kill_silent();
						}
					}	
				}
#endif
			}
			else
			{
				strncpy(error, strerror(errno), 1024);
				syslog(LOG_ERR, "Select error: %s", error);
			}
		}

		syslog(LOG_DEBUG, "%d sockets ready for reading", selrtn);
	}
	while (selrtn < 0 && errno == EINTR);

	return(selrtn);
}
