/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>

#include "mserver.h"

void config_dump(const char *);

FILE *insock;
FILE *outsock;

int main(int argc, char **argv)
{
	int numlocks = 9;
	char *locks[9] = {"ttyS0", "ttyS1", "ttyS2", "ttyS3", "cua0", "cua1", "cua2", "cua3", "modem"};

	int numdevs = 8;
	char *ndevs[8] = {"ppp0", "ppp1", "ppp2", "ppp3", "eth0", "eth1", "eth2", "eth3"};

	char temp[1024];
	int i;

#ifdef DEBUG
	openlog("mserver", LOG_PERROR, LOG_LOCAL2);
#endif

	config_init("");


	config_setvalue("stattype", "pppdlock");
	for(i = 0; i < numlocks; i++)
	{
		config_dump("Trying ...");
		snprintf(temp, 1024, "/var/lock/LCK..%s", locks[i]);	
		config_setvalue("lockfile", temp);

		if (getstat())
		{
			config_dump("The following configuration reports the connection as active ...");
		}
	}

	config_setvalue("stattype", "lockonly");
	for(i = 0; i < numlocks; i++)
	{
		config_dump("Trying ...");
		snprintf(temp, 1024, "/var/lock/LCK..%s", locks[i]);	
		config_setvalue("lockfile", temp);

		if (getstat())
		{
			config_dump("The following configuration reports the connection as active ...");
		}
	}

	config_setvalue("lockfile", "");

	config_setvalue("stattype", "netdev");
	for(i = 0; i < numdevs; i++)
	{
		config_setvalue("netdev", ndevs[i]);
		config_dump("Trying ...");

		if (getstat())
		{
			config_dump("The following configuration reports the connection as active ...");
		}
	}

	config_setvalue("netdev", "");

	config_setvalue("stattype", "exitcode");
	config_setvalue("goodcode", "0");
	config_setvalue("linkcheck", "/bin/ping -c 1 %s");
	config_setvalue("checkhost", "ns1.icsnet.net");

	config_dump("Trying ...");
	if (getstat())
	{
		config_dump("The following configuration reports the connection as active ...");
	}
}

void config_dump(const char *head)
{
	char temp[1024];

	printf("%s\n", head);

	config_getvalue("stattype", temp, 1024);
	printf("stattype: %s\n", temp);

	config_getvalue("netdev", temp, 1024);
	printf("netdev: %s\n", temp);

	config_getvalue("lockfile", temp, 1024);
	printf("lockfile: %s\n", temp);

	config_getvalue("checkhost", temp, 1024);
	printf("checkhost: %s\n", temp);

	config_getvalue("linkcheck", temp, 1024);
	printf("linkcheck: %s\n", temp);

	config_getvalue("goodcode", temp, 1024);
	printf("goodcode: %s\n", temp);

	printf("\n\n");
}
