#!/bin/bash
#Copyright inria / irisa (2013)
#
#
#pierre.peterlongo@inria.fr
#
#This software is a computer program whose purpose is performe optimized targeted assembly from reads
#
#This software is governed by the CeCILL license under French law and
#abiding by the rules of distribution of free software.  You can  use,
#modify and/ or redistribute the software under the terms of the CeCILL
#license as circulated by CEA, CNRS and INRIA at the following URL
#"http:#www.cecill.info".
#
#As a counterpart to the access to the source code and  rights to copy,
#modify and redistribute granted by the license, users are provided only
#with a limited warranty  and the software's author,  the holder of the
#economic rights,  and the successive licensors  have only  limited
#liability.
#
#In this respect, the user's attention is drawn to the risks associated
#with loading,  using,  modifying and/or developing or reproducing the
#software by the user in light of its specific status of free software,
#that may mean  that it is complicated to manipulate,  and  that  also
#therefore means  that it is reserved for developers  and  experienced
#professionals having in-depth computer knowledge. Users are therefore
#encouraged to load and test the software's suitability as regards their
#requirements in conditions enabling the security of their systems and/or
#data to be ensured and,  more generally, to use and operate it in the
#same conditions as regards security.
#
#The fact that you are presently reading this means that you have had
#knowledge of the CeCILL license and that you accept its terms.


k=29
if test $# -eq 0
then
	k=29
else
    k=$1
fi

if [ -d "./tools" ];
then echo "./tools directory already exist"	
else 
	mkdir tools
fi

cd maps
make k=$k
cd ../
cp maps/mapsembler tools
if [ $? -ne 0 ]
then
echo "There was a problem compiling Mapsembler, sorry. Please fix the problem or contact pierre.peterlongo@inria.fr."
exit
fi

cd kissreads_g
make k=$k
cd ..
cp kissreads_g/kissreads_graph tools/phaser
if [ $? -ne 0 ]
then
echo "There was a problem compiling KissreadsGraph, sorry. Please fix the problem or contact pierre.peterlongo@inria.fr."
exit
fi


echo "Compiling is done, if possible, :"
echo -e "\t 1/ copy executables \"tools/mapsembler\", \"tools/phaser\" and \"tools/GSVDesktop in a directory member of the PATH environment variable (e.g. /usb/local/bin)"
echo -e "\t 2/ replace PATH_RS=\"./tools\" by PATH_RS=\"\" in the \"run_mapsembler_and_phaser.sh\" configuration file"
MY_PATH="`( cd \"$MY_PATH\" && pwd )`"  # absolutized and normalized
if [ -z "$MY_PATH" ] ; then
# error; for some reason, the path is not accessible
# to the script (e.g. permissions re-evaled after suid)
exit 1  # fail
fi

cd visu
cp GSV/doc/doc.pdf ../docs/GSV_doc.pdf
sh buildGSV.sh
cd ../
if [ -d "./tools/GSVDesktop/" ];
    then
        rm -R tools/GSVDesktop/
        rm GSVDesktop*
fi

if [ -d "./visu/GSVDesktop/" ];
    then mv visu/GSVDesktop tools/
fi

if [ -f "./GSVDesktop" ];
    then echo "GSVDesktop shortcut already exist"
else

	if [[ "$OSTYPE" == "linux" ]];
   		 then  ln -s tools/GSVDesktop/GSVDesktop ./
	elif [[ "$OSTYPE" == "darwin"* ]];
    		then  ln -s tools/GSVDesktop/GSVDesktop.app ./
	fi
fi

if [ $? -ne 0 ]
    then
    echo "There was a problem compiling Graph Sequence Viewer, sorry. Please fix the problem or contact pierre.peterlongo@inria.fr."
exit
fi

#echo -e "   or"
echo "Leave it as is. In this case, if working outside this current directory (\"$MY_PATH\"), you will have to indicate in the \"run_mapsembler_and_phaser.sh\" where executables \"mapsembler\", \"phaser\" and \"GSV\" are located by changing the value of the PATH_RS variable"
