/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <errno.h>

/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#ifndef _Win32
#include <unistd.h>
#else
#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif
#endif

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define addrconst const
#else
#define addrconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN addr_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((addr_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE addrrestart( addrin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct addr_buffer_state *YY_BUFFER_STATE;

extern int addrleng;
extern FILE *addrin, *addrout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		addrless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the addrless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define addrless(n) \
	do \
		{ \
		/* Undo effects of setting up addrtext. */ \
		*addr_cp = addr_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		addr_c_buf_p = addr_cp = addr_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up addrtext again */ \
		} \
	while ( 0 )

#define unput(c) addrunput( c, addrtext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int addr_size_t;


struct addr_buffer_state
	{
	FILE *addr_input_file;

	char *addr_ch_buf;		/* input buffer */
	char *addr_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	addr_size_t addr_buf_size;

	/* Number of characters read into addr_ch_buf, not including EOB
	 * characters.
	 */
	int addr_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int addr_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int addr_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int addr_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int addr_fill_buffer;

	int addr_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via addrrestart()), so that the user can continue scanning by
	 * just pointing addrin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE addr_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER addr_current_buffer


/* addr_hold_char holds the character lost when addrtext is formed. */
static char addr_hold_char;

static int addr_n_chars;		/* number of characters read into addr_ch_buf */


int addrleng;

/* Points to current character in buffer. */
static char *addr_c_buf_p = (char *) 0;
static int addr_init = 1;		/* whether we need to initialize */
static int addr_start = 0;	/* start state number */

/* Flag which is used to allow addrwrap()'s to do buffer switches
 * instead of setting up a fresh addrin.  A bit of a hack ...
 */
static int addr_did_buffer_switch_on_eof;

void addrrestart YY_PROTO(( FILE *input_file ));

void addr_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void addr_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE addr_create_buffer YY_PROTO(( FILE *file, int size ));
void addr_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void addr_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void addr_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER addr_flush_buffer( addr_current_buffer )

YY_BUFFER_STATE addr_scan_buffer YY_PROTO(( char *base, addr_size_t size ));
YY_BUFFER_STATE addr_scan_string YY_PROTO(( addrconst char *addr_str ));
YY_BUFFER_STATE addr_scan_bytes YY_PROTO(( addrconst char *bytes, int len ));

static void *addr_flex_alloc YY_PROTO(( addr_size_t ));
static void *addr_flex_realloc YY_PROTO(( void *, addr_size_t ));
static void addr_flex_free YY_PROTO(( void * ));

#define addr_new_buffer addr_create_buffer

#define addr_set_interactive(is_interactive) \
	{ \
	if ( ! addr_current_buffer ) \
		addr_current_buffer = addr_create_buffer( addrin, YY_BUF_SIZE ); \
	addr_current_buffer->addr_is_interactive = is_interactive; \
	}

#define addr_set_bol(at_bol) \
	{ \
	if ( ! addr_current_buffer ) \
		addr_current_buffer = addr_create_buffer( addrin, YY_BUF_SIZE ); \
	addr_current_buffer->addr_at_bol = at_bol; \
	}

#define YY_AT_BOL() (addr_current_buffer->addr_at_bol)


#define addrwrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *addrin = (FILE *) 0, *addrout = (FILE *) 0;
typedef int addr_state_type;
extern char *addrtext;
#define addrtext_ptr addrtext

static addr_state_type addr_get_previous_state YY_PROTO(( void ));
static addr_state_type addr_try_NUL_trans YY_PROTO(( addr_state_type current_state ));
static int addr_get_next_buffer YY_PROTO(( void ));
static void addr_fatal_error YY_PROTO(( addrconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up addrtext.
 */
#define YY_DO_BEFORE_ACTION \
	addrtext_ptr = addr_bp; \
	addrleng = (int) (addr_cp - addr_bp); \
	addr_hold_char = *addr_cp; \
	*addr_cp = '\0'; \
	addr_c_buf_p = addr_cp;

#define YY_NUM_RULES 15
#define YY_END_OF_BUFFER 16
static addrconst short int addr_accept[40] =
    {   0,
        0,    0,    8,    8,   10,   10,   12,   12,   16,    5,
        5,    6,    6,    1,    3,    4,    7,    2,    8,   15,
        9,   15,   10,   15,   11,   12,   13,   14,   15,    5,
        5,    6,    8,    0,   10,    0,   12,    0,    0
    } ;

static addrconst int addr_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    6,    1,    1,    1,    1,    1,    7,
        8,    1,    1,    9,    1,    9,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    9,    9,    9,
        1,    9,    1,    9,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
       10,   11,   12,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static addrconst int addr_meta[14] =
    {   0,
        1,    2,    3,    4,    5,    6,    7,    7,    8,    9,
        8,    9,   10
    } ;

static addrconst short int addr_base[48] =
    {   0,
        0,    0,   11,   20,   29,   39,   49,   60,   27,    0,
       73,    0,    0,  182,  182,  182,  182,  182,   14,  182,
      182,   83,   10,   86,  182,    9,  182,  182,   92,    0,
        0,    0,    8,  102,    7,    0,    5,    0,  182,  108,
      118,  128,  138,  147,  152,  162,  172
    } ;

static addrconst short int addr_def[48] =
    {   0,
       39,    1,   40,   40,   41,   41,   42,   42,   39,   43,
       39,   44,   44,   39,   39,   39,   39,   39,   45,   39,
       39,   45,   46,   46,   39,   47,   39,   39,   47,   43,
       11,   44,   45,   45,   46,   24,   47,   29,    0,   39,
       39,   39,   39,   39,   39,   39,   39
    } ;

static addrconst short int addr_nxt[196] =
    {   0,
       10,   11,   12,   13,   13,   14,   15,   16,   17,   18,
       17,   17,   10,   20,   20,   38,   21,   36,   34,   38,
       36,   22,   20,   20,   34,   21,   39,   39,   39,   39,
       22,   20,   20,   39,   39,   39,   39,   39,   20,   24,
       25,   20,   20,   39,   39,   39,   39,   39,   20,   24,
       25,   20,   39,   39,   39,   27,   28,   39,   39,   29,
       39,   20,   20,   39,   39,   39,   27,   28,   39,   39,
       29,   39,   20,   30,   31,   32,   32,   32,   39,   39,
       39,   39,   39,   39,   39,   30,   33,   39,   33,   35,
       39,   39,   39,   39,   39,   35,   39,   35,   37,   37,

       39,   39,   39,   39,   37,   33,   39,   33,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   30,   30,
       39,   39,   39,   39,   39,   39,   39,   30,   32,   32,
       32,   32,   33,   33,   39,   39,   33,   39,   33,   33,
       33,   33,   35,   35,   39,   39,   35,   35,   35,   35,
       39,   35,   37,   37,   39,   37,   37,   37,   39,   37,
       37,    9,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,   39

    } ;

static addrconst short int addr_chk[196] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    3,   37,    3,   35,   33,   26,
       23,    3,    4,    4,   19,    4,    9,    0,    0,    0,
        4,    5,    5,    0,    0,    0,    0,    0,    5,    5,
        5,    6,    6,    0,    0,    0,    0,    0,    6,    6,
        6,    7,    0,    0,    0,    7,    7,    0,    0,    7,
        0,    7,    8,    0,    0,    0,    8,    8,    0,    0,
        8,    0,    8,   11,   11,   11,   11,   11,    0,    0,
        0,    0,    0,    0,    0,   11,   22,    0,   22,   24,
        0,    0,    0,    0,    0,   24,    0,   24,   29,   29,

        0,    0,    0,    0,   29,   34,    0,   34,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   43,   43,
        0,    0,    0,    0,    0,    0,    0,   43,   44,   44,
       44,   44,   45,   45,    0,    0,   45,    0,   45,   45,
       45,   45,   46,   46,    0,    0,   46,   46,   46,   46,
        0,   46,   47,   47,    0,   47,   47,   47,    0,   47,
       47,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,   39

    } ;

static addr_state_type addr_last_accepting_state;
static char *addr_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define addrmore() addrmore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *addrtext;
#line 1 "addr-lex.l"
#define INITIAL 0
#line 2 "addr-lex.l"
/*
 * addr-lex.l -- RFC 822 address lexer
 */

#include "addr.h"
#include <string.h>

#undef YY_INPUT
#define YY_INPUT(b, r, ms) (r = addrinput(b, ms))

int addrinput(char *buf, int max_size);
void addrerror(const char *);

static int ncom;	/* number of open comments */
#define QSTRING 1
#define DOMAINLIT 2
#define COMMENT 3

#line 447 "lex.addr.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int addrwrap YY_PROTO(( void ));
#else
extern int addrwrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void addrunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef addrtext_ptr
static void addr_flex_strncpy YY_PROTO(( char *, addrconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int addr_flex_strlen YY_PROTO(( addrconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int addrinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int addr_start_stack_ptr = 0;
static int addr_start_stack_depth = 0;
static int *addr_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void addr_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void addr_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int addr_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( addrtext, addrleng, 1, addrout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( addr_current_buffer->addr_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( addrin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( addrin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, addrin))==0 && ferror(addrin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(addrin); \
			} \
		}
#endif

/* No semi-colon after return; correct usage is to write "addrterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef addrterminate
#define addrterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) addr_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int addrlex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after addrtext and addrleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register addr_state_type addr_current_state;
	register char *addr_cp, *addr_bp;
	register int addr_act;

#line 21 "addr-lex.l"


#line 612 "lex.addr.c"

	if ( addr_init )
		{
		addr_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! addr_start )
			addr_start = 1;	/* first start state */

		if ( ! addrin )
			addrin = stdin;

		if ( ! addrout )
			addrout = stdout;

		if ( ! addr_current_buffer )
			addr_current_buffer =
				addr_create_buffer( addrin, YY_BUF_SIZE );

		addr_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		addr_cp = addr_c_buf_p;

		/* Support of addrtext. */
		*addr_cp = addr_hold_char;

		/* addr_bp points to the position in addr_ch_buf of the start of
		 * the current run.
		 */
		addr_bp = addr_cp;

		addr_current_state = addr_start;
addr_match:
		do
			{
			register YY_CHAR addr_c = addr_ec[YY_SC_TO_UI(*addr_cp)];
			if ( addr_accept[addr_current_state] )
				{
				addr_last_accepting_state = addr_current_state;
				addr_last_accepting_cpos = addr_cp;
				}
			while ( addr_chk[addr_base[addr_current_state] + addr_c] != addr_current_state )
				{
				addr_current_state = (int) addr_def[addr_current_state];
				if ( addr_current_state >= 40 )
					addr_c = addr_meta[(unsigned int) addr_c];
				}
			addr_current_state = addr_nxt[addr_base[addr_current_state] + (unsigned int) addr_c];
			++addr_cp;
			}
		while ( addr_base[addr_current_state] != 182 );

addr_find_action:
		addr_act = addr_accept[addr_current_state];
		if ( addr_act == 0 )
			{ /* have to back up */
			addr_cp = addr_last_accepting_cpos;
			addr_current_state = addr_last_accepting_state;
			addr_act = addr_accept[addr_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( addr_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*addr_cp = addr_hold_char;
			addr_cp = addr_last_accepting_cpos;
			addr_current_state = addr_last_accepting_state;
			goto addr_find_action;

case 1:
YY_RULE_SETUP
#line 23 "addr-lex.l"
{ BEGIN QSTRING; return addrtext[0]; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 24 "addr-lex.l"
{ BEGIN DOMAINLIT; return addrtext[0]; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 25 "addr-lex.l"
{ ncom = 1; BEGIN COMMENT; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 26 "addr-lex.l"
{ addrerror("address parse error, "
					  "unexpected `')'' "
					  "(unbalanced comment)");
				  addrterminate(); }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 31 "addr-lex.l"
return ATOM;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 33 "addr-lex.l"
/* ignore whitespace */
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 34 "addr-lex.l"
return addrtext[0];
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 36 "addr-lex.l"
return QTEXT;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 37 "addr-lex.l"
{ BEGIN INITIAL; return addrtext[0]; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 39 "addr-lex.l"
return DTEXT;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 40 "addr-lex.l"
{ BEGIN INITIAL; return addrtext[0]; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 42 "addr-lex.l"
/* ignore comments */
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 43 "addr-lex.l"
ncom++;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 44 "addr-lex.l"
{ ncom--; if (ncom == 0) BEGIN INITIAL; }
	YY_BREAK
case YY_STATE_EOF(COMMENT):
#line 45 "addr-lex.l"
{ addrerror("address parse error, "
					  "expecting `')'' "
					  "(unterminated comment)");
				  addrterminate(); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 50 "addr-lex.l"
ECHO;
	YY_BREAK
#line 780 "lex.addr.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(QSTRING):
case YY_STATE_EOF(DOMAINLIT):
	addrterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int addr_amount_of_matched_text = (int) (addr_cp - addrtext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*addr_cp = addr_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( addr_current_buffer->addr_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed addrin at a new source and called
			 * addrlex().  If so, then we have to assure
			 * consistency between addr_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			addr_n_chars = addr_current_buffer->addr_n_chars;
			addr_current_buffer->addr_input_file = addrin;
			addr_current_buffer->addr_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for addr_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since addr_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( addr_c_buf_p <= &addr_current_buffer->addr_ch_buf[addr_n_chars] )
			{ /* This was really a NUL. */
			addr_state_type addr_next_state;

			addr_c_buf_p = addrtext_ptr + addr_amount_of_matched_text;

			addr_current_state = addr_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * addr_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			addr_next_state = addr_try_NUL_trans( addr_current_state );

			addr_bp = addrtext_ptr + YY_MORE_ADJ;

			if ( addr_next_state )
				{
				/* Consume the NUL. */
				addr_cp = ++addr_c_buf_p;
				addr_current_state = addr_next_state;
				goto addr_match;
				}

			else
				{
				addr_cp = addr_c_buf_p;
				goto addr_find_action;
				}
			}

		else switch ( addr_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				addr_did_buffer_switch_on_eof = 0;

				if ( addrwrap() )
					{
					/* Note: because we've taken care in
					 * addr_get_next_buffer() to have set up
					 * addrtext, we can now set up
					 * addr_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					addr_c_buf_p = addrtext_ptr + YY_MORE_ADJ;

					addr_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! addr_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				addr_c_buf_p =
					addrtext_ptr + addr_amount_of_matched_text;

				addr_current_state = addr_get_previous_state();

				addr_cp = addr_c_buf_p;
				addr_bp = addrtext_ptr + YY_MORE_ADJ;
				goto addr_match;

			case EOB_ACT_LAST_MATCH:
				addr_c_buf_p =
				&addr_current_buffer->addr_ch_buf[addr_n_chars];

				addr_current_state = addr_get_previous_state();

				addr_cp = addr_c_buf_p;
				addr_bp = addrtext_ptr + YY_MORE_ADJ;
				goto addr_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of addrlex */


/* addr_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int addr_get_next_buffer()
	{
	register char *dest = addr_current_buffer->addr_ch_buf;
	register char *source = addrtext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( addr_c_buf_p > &addr_current_buffer->addr_ch_buf[addr_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( addr_current_buffer->addr_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( addr_c_buf_p - addrtext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (addr_c_buf_p - addrtext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( addr_current_buffer->addr_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		addr_current_buffer->addr_n_chars = addr_n_chars = 0;

	else
		{
		int num_to_read =
			addr_current_buffer->addr_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = addr_current_buffer;

			int addr_c_buf_p_offset =
				(int) (addr_c_buf_p - b->addr_ch_buf);

			if ( b->addr_is_our_buffer )
				{
				int new_size = b->addr_buf_size * 2;

				if ( new_size <= 0 )
					b->addr_buf_size += b->addr_buf_size / 8;
				else
					b->addr_buf_size *= 2;

				b->addr_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					addr_flex_realloc( (void *) b->addr_ch_buf,
							 b->addr_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->addr_ch_buf = 0;

			if ( ! b->addr_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			addr_c_buf_p = &b->addr_ch_buf[addr_c_buf_p_offset];

			num_to_read = addr_current_buffer->addr_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&addr_current_buffer->addr_ch_buf[number_to_move]),
			addr_n_chars, num_to_read );

		addr_current_buffer->addr_n_chars = addr_n_chars;
		}

	if ( addr_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			addrrestart( addrin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			addr_current_buffer->addr_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	addr_n_chars += number_to_move;
	addr_current_buffer->addr_ch_buf[addr_n_chars] = YY_END_OF_BUFFER_CHAR;
	addr_current_buffer->addr_ch_buf[addr_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	addrtext_ptr = &addr_current_buffer->addr_ch_buf[0];

	return ret_val;
	}


/* addr_get_previous_state - get the state just before the EOB char was reached */

static addr_state_type addr_get_previous_state()
	{
	register addr_state_type addr_current_state;
	register char *addr_cp;

	addr_current_state = addr_start;

	for ( addr_cp = addrtext_ptr + YY_MORE_ADJ; addr_cp < addr_c_buf_p; ++addr_cp )
		{
		register YY_CHAR addr_c = (*addr_cp ? addr_ec[YY_SC_TO_UI(*addr_cp)] : 13);
		if ( addr_accept[addr_current_state] )
			{
			addr_last_accepting_state = addr_current_state;
			addr_last_accepting_cpos = addr_cp;
			}
		while ( addr_chk[addr_base[addr_current_state] + addr_c] != addr_current_state )
			{
			addr_current_state = (int) addr_def[addr_current_state];
			if ( addr_current_state >= 40 )
				addr_c = addr_meta[(unsigned int) addr_c];
			}
		addr_current_state = addr_nxt[addr_base[addr_current_state] + (unsigned int) addr_c];
		}

	return addr_current_state;
	}


/* addr_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = addr_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static addr_state_type addr_try_NUL_trans( addr_state_type addr_current_state )
#else
static addr_state_type addr_try_NUL_trans( addr_current_state )
addr_state_type addr_current_state;
#endif
	{
	register int addr_is_jam;
	register char *addr_cp = addr_c_buf_p;

	register YY_CHAR addr_c = 13;
	if ( addr_accept[addr_current_state] )
		{
		addr_last_accepting_state = addr_current_state;
		addr_last_accepting_cpos = addr_cp;
		}
	while ( addr_chk[addr_base[addr_current_state] + addr_c] != addr_current_state )
		{
		addr_current_state = (int) addr_def[addr_current_state];
		if ( addr_current_state >= 40 )
			addr_c = addr_meta[(unsigned int) addr_c];
		}
	addr_current_state = addr_nxt[addr_base[addr_current_state] + (unsigned int) addr_c];
	addr_is_jam = (addr_current_state == 39);

	return addr_is_jam ? 0 : addr_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void addrunput( int c, register char *addr_bp )
#else
static void addrunput( c, addr_bp )
int c;
register char *addr_bp;
#endif
	{
	register char *addr_cp = addr_c_buf_p;

	/* undo effects of setting up addrtext */
	*addr_cp = addr_hold_char;

	if ( addr_cp < addr_current_buffer->addr_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = addr_n_chars + 2;
		register char *dest = &addr_current_buffer->addr_ch_buf[
					addr_current_buffer->addr_buf_size + 2];
		register char *source =
				&addr_current_buffer->addr_ch_buf[number_to_move];

		while ( source > addr_current_buffer->addr_ch_buf )
			*--dest = *--source;

		addr_cp += (int) (dest - source);
		addr_bp += (int) (dest - source);
		addr_current_buffer->addr_n_chars =
			addr_n_chars = addr_current_buffer->addr_buf_size;

		if ( addr_cp < addr_current_buffer->addr_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--addr_cp = (char) c;


	addrtext_ptr = addr_bp;
	addr_hold_char = *addr_cp;
	addr_c_buf_p = addr_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int addrinput()
#else
static int input()
#endif
	{
	int c;

	*addr_c_buf_p = addr_hold_char;

	if ( *addr_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* addr_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( addr_c_buf_p < &addr_current_buffer->addr_ch_buf[addr_n_chars] )
			/* This was really a NUL. */
			*addr_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = addr_c_buf_p - addrtext_ptr;
			++addr_c_buf_p;

			switch ( addr_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because addr_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					addrrestart( addrin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( addrwrap() )
						return EOF;

					if ( ! addr_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return addrinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					addr_c_buf_p = addrtext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) addr_c_buf_p;	/* cast for 8-bit char's */
	*addr_c_buf_p = '\0';	/* preserve addrtext */
	addr_hold_char = *++addr_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void addrrestart( FILE *input_file )
#else
void addrrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! addr_current_buffer )
		addr_current_buffer = addr_create_buffer( addrin, YY_BUF_SIZE );

	addr_init_buffer( addr_current_buffer, input_file );
	addr_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void addr_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void addr_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( addr_current_buffer == new_buffer )
		return;

	if ( addr_current_buffer )
		{
		/* Flush out information for old buffer. */
		*addr_c_buf_p = addr_hold_char;
		addr_current_buffer->addr_buf_pos = addr_c_buf_p;
		addr_current_buffer->addr_n_chars = addr_n_chars;
		}

	addr_current_buffer = new_buffer;
	addr_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (addrwrap()) processing, but the only time this flag
	 * is looked at is after addrwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	addr_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void addr_load_buffer_state( void )
#else
void addr_load_buffer_state()
#endif
	{
	addr_n_chars = addr_current_buffer->addr_n_chars;
	addrtext_ptr = addr_c_buf_p = addr_current_buffer->addr_buf_pos;
	addrin = addr_current_buffer->addr_input_file;
	addr_hold_char = *addr_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE addr_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE addr_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) addr_flex_alloc( sizeof( struct addr_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in addr_create_buffer()" );

	b->addr_buf_size = size;

	/* addr_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->addr_ch_buf = (char *) addr_flex_alloc( b->addr_buf_size + 2 );
	if ( ! b->addr_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in addr_create_buffer()" );

	b->addr_is_our_buffer = 1;

	addr_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void addr_delete_buffer( YY_BUFFER_STATE b )
#else
void addr_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == addr_current_buffer )
		addr_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->addr_is_our_buffer )
		addr_flex_free( (void *) b->addr_ch_buf );

	addr_flex_free( (void *) b );
	}


#ifndef _Win32
#include <unistd.h>
#else
#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif
#endif

#ifdef YY_USE_PROTOS
void addr_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void addr_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	addr_flush_buffer( b );

	b->addr_input_file = file;
	b->addr_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->addr_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->addr_is_interactive = 0;
#else
	b->addr_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void addr_flush_buffer( YY_BUFFER_STATE b )
#else
void addr_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->addr_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->addr_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->addr_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->addr_buf_pos = &b->addr_ch_buf[0];

	b->addr_at_bol = 1;
	b->addr_buffer_status = YY_BUFFER_NEW;

	if ( b == addr_current_buffer )
		addr_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE addr_scan_buffer( char *base, addr_size_t size )
#else
YY_BUFFER_STATE addr_scan_buffer( base, size )
char *base;
addr_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) addr_flex_alloc( sizeof( struct addr_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in addr_scan_buffer()" );

	b->addr_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->addr_buf_pos = b->addr_ch_buf = base;
	b->addr_is_our_buffer = 0;
	b->addr_input_file = 0;
	b->addr_n_chars = b->addr_buf_size;
	b->addr_is_interactive = 0;
	b->addr_at_bol = 1;
	b->addr_fill_buffer = 0;
	b->addr_buffer_status = YY_BUFFER_NEW;

	addr_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE addr_scan_string( addrconst char *addr_str )
#else
YY_BUFFER_STATE addr_scan_string( addr_str )
addrconst char *addr_str;
#endif
	{
	int len;
	for ( len = 0; addr_str[len]; ++len )
		;

	return addr_scan_bytes( addr_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE addr_scan_bytes( addrconst char *bytes, int len )
#else
YY_BUFFER_STATE addr_scan_bytes( bytes, len )
addrconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	addr_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) addr_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in addr_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = addr_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in addr_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->addr_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void addr_push_state( int new_state )
#else
static void addr_push_state( new_state )
int new_state;
#endif
	{
	if ( addr_start_stack_ptr >= addr_start_stack_depth )
		{
		addr_size_t new_size;

		addr_start_stack_depth += YY_START_STACK_INCR;
		new_size = addr_start_stack_depth * sizeof( int );

		if ( ! addr_start_stack )
			addr_start_stack = (int *) addr_flex_alloc( new_size );

		else
			addr_start_stack = (int *) addr_flex_realloc(
					(void *) addr_start_stack, new_size );

		if ( ! addr_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	addr_start_stack[addr_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void addr_pop_state()
	{
	if ( --addr_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(addr_start_stack[addr_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int addr_top_state()
	{
	return addr_start_stack[addr_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void addr_fatal_error( addrconst char msg[] )
#else
static void addr_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine addrless() so it works in section 3 code. */

#undef addrless
#define addrless(n) \
	do \
		{ \
		/* Undo effects of setting up addrtext. */ \
		addrtext[addrleng] = addr_hold_char; \
		addr_c_buf_p = addrtext + n; \
		addr_hold_char = *addr_c_buf_p; \
		*addr_c_buf_p = '\0'; \
		addrleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef addrtext_ptr
#ifdef YY_USE_PROTOS
static void addr_flex_strncpy( char *s1, addrconst char *s2, int n )
#else
static void addr_flex_strncpy( s1, s2, n )
char *s1;
addrconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int addr_flex_strlen( addrconst char *s )
#else
static int addr_flex_strlen( s )
addrconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *addr_flex_alloc( addr_size_t size )
#else
static void *addr_flex_alloc( size )
addr_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *addr_flex_realloc( void *ptr, addr_size_t size )
#else
static void *addr_flex_realloc( ptr, size )
void *ptr;
addr_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void addr_flex_free( void *ptr )
#else
static void addr_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	addrlex();
	return 0;
	}
#endif
#line 50 "addr-lex.l"


/* take input from address string provided by sieve parser */
int addrinput(char *buf, int max_size)
{
    extern char *addrptr;	/* current position in address string */
    int n;			/* number of characters to read from string */

    (void) addrunput;

    n = strlen(addrptr) < max_size ? strlen(addrptr) : max_size;
    if (n > 0) {
	memcpy(buf, addrptr, n);
	addrptr += n;
    }
    return n;
}
