/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Symbol.cc
    \brief Implementation of Symbol graphics class (template).
    
    Magics Team - ECMWF 2004
    
    Started: Jan 2004
    
    Changes:
    
*/
#include "Symbol.h"

using namespace magics;


Symbol::Symbol() : marker_(0), height_(0.2),outline_(false)
{
}



Symbol::~Symbol() 
{
}

	
void Symbol::print(ostream& out)  const
{
	out << "Symbol<P>[";
	BasicGraphicsObject::print(out);
	out << ", height = " << height_;
	out << ", marker = " << marker_;
	out << ", nb_points = " << this->size();
	out << "]";
}
SymbolProperties::SymbolProperties(Colour colour, double height, const string& marker, const string& label) : 
        colour_(colour), 
        height_(height),
        marker_(marker),
        label_(label), position_(Symbol::M_NONE)
        { font_.size(height_); font_.colour(colour_); }
    
SymbolProperties::SymbolProperties(Colour colour, double height, int marker, const string& label) : 
        colour_(colour), 
        height_(height),
        marker_(Symbol::convert(marker)),
        label_(label),position_(Symbol::M_NONE)
        { font_.size(height_); font_.colour(colour_); }
	
SymbolProperties::SymbolProperties() : 
        colour_(Colour("none")), 
        height_(0),
        marker_(Symbol::convert(1)),
        label_(""), position_(Symbol::M_NONE)
        { font_.size(height_); font_.colour(colour_); }
        
void SymbolProperties::setSymbol(const string& symbol, int marker)
{
	marker_ = !symbol.empty() ? symbol : Symbol::convert(marker);
}

        
Symbol* SymbolProperties::symbol(const string& type) const
{
	Symbol* symbol = 0;
	
	const unsigned text_size = text_.size();
	
	if ( magCompare(type, "marker") )	
			symbol = new Symbol();

	if ( magCompare(type, "text") )
	{
		if ( text_size == 0 ) {
			SimpleTextSymbol* stext = new SimpleTextSymbol(label_); 
			stext->position(position_);
			symbol = stext;
			stext->font(font_);
			vector<string> helper;		
			helper.push_back(label_);
			stext->text(helper);
			
			
		}
		
		else { 
			TextSymbol* text = new TextSymbol();		
			text->position(position_);
			symbol = text;
			text->font(font_);
			text->text(text_);
			
		}
	}
	if ( magCompare(type, "number") )
	{
		TextSymbol* text = new TextSymbol();		
		text->position(position_);
		symbol = text;
		text->font(font_);
		text->text(text_); 
		symbol->setColour(Colour("none"));
		symbol->setSymbol(marker_);
		symbol->setHeight(0.0);
		return symbol;
	}
	
	symbol->setColour(colour_);
	symbol->setSymbol(marker_);
	symbol->setHeight(height_);
	symbol->outline(outline_, outlineColour_, outlineThickness_, outlineStyle_);

	return symbol;
}


void ComplexSymbol::print(ostream& out) const
{
	out << "ComplexSymbol[" << endl;
	for (vector<GraphicsItem*>::const_iterator item = items_.begin(); item != items_.end(); ++item)
		out << **item  << ", " << endl;
	out << "]" << endl;
}
