C     This example demonstrates the plotting of wind arrows
C     and flags.


      PROGRAM WIND


C     Open MAGICS and set the output file type/name
C     Note that 'PS' is the default so we don't need to 
C     specify it here.

      CALL POPEN
      CALL PSETC ('OUTPUT_FORMAT',  'PNG')
      CALL PSETC ('OUTPUT_NAME',    'wind')


C     Set up all the parameters we'll use in all the examples

      CALL PSETC ('MAP_COASTLINE_COLOUR',            'GREY')
      CALL PSETC ('MAP_GRID_COLOUR',                 'GREY')
      CALL PSETC ('MAP_LABEL_COLOUR',                'GREY')


C     Area specification (SOUTH, WEST, NORTH, EAST)

      CALL PSETR ('SUBPAGE_LOWER_LEFT_LATITUDE',    25.0)
      CALL PSETR ('SUBPAGE_LOWER_LEFT_LONGITUDE',   65.0)
      CALL PSETR ('SUBPAGE_UPPER_RIGHT_LATITUDE',   70.0)
      CALL PSETR ('SUBPAGE_UPPER_RIGHT_LONGITUDE', 145.0)


C     Tell MAGICS where the U/V fields are in the file
C     Note that these values are the defaults and so are not
C     actually necessary in this example

      CALL PSETI ('GRIB_WIND_POSITION_1', 1)               
      CALL PSETI ('GRIB_WIND_POSITION_2', 2)


C     Load the data file

      CALL PSETC ('GRIB_INPUT_FILE_NAME', '../data/uv500.grb')
      CALL PGRIB



C     --- Plot wind arrows with default settings ---

      CALL PSETI ('TEXT_LINE_COUNT',  2)
      CALL PSETC ('TEXT_LINE_1',     'Wind arrows, default settings')
      CALL PSETC ('TEXT_LINE_2',     '')
      CALL PCOAST 
      CALL PWIND
      CALL PTEXT



C     Close MAGICS

      CALL PCLOSE
      END

