/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

#include "MagJSon.h"


using namespace magics;
using namespace json_spirit;

MagJSon::MagJSon()
{	
		
}
void MagJSon::execute(const string& magml, const map<string, string>& params)
{
	
	TempFile file;
	
	prepare(magml, params, file);	 	
	parse(file.name());
}

void MagJSon::parse(const string& file)
{
	Log::dev()<< "parse-->" << file.c_str() << endl;
	 ifstream is( file.c_str());
	 
     Value value;
     try {
		    bool e = read( is, value );
		   /*f ( !e ) {
		    	Log::dev()<< "bool PB!!" << endl;
		    	return;
		    }
		    */
		    if (value.type() !=  obj_type) {
		    	Log::dev()<< "type PB!!" << endl;
		    	return;
		    }
		    
		    Object o = value.get_value< Object >();
	        
		    for (vector<Pair>::const_iterator p = o.begin(); p !=  o.end(); ++p) {
		    		write(cout, p->name_, p->value_);
		   }
     }
     catch (...) 
     {
    	 Log::dev()<< "PB!!" << endl;
     }
}

void MagJSon::write(ostream& out, const string& param, const json_spirit::Value& value)
{
	switch(value.type()) {
	        case obj_type :
	        	
	            write(out, value.get_value< Object >());
	           
	            break;
	        case array_type :	        	
	        	write(out, value.get_value< Array >());
	            break;
	        case str_type :
	        	out << "<" << param <<  " = \"" << value.get_value< string >() << "\"";
	            break;
	        case bool_type :
	            //set(value.get_value< bool >());
	            break;
	        case int_type :
	        	out << "<" << param <<  " = \"" << value.get_value< int >() << "\"";
	            break;
	        case real_type:
	        	out << "<" << param <<  " = \"" << value.get_value< double >() << "\"";
	            break;
	        case null_type :
	            Log::dev()<< "null" << endl;
	            break;
	        default:
	            Log::dev()<< "not yet" << endl;
	    }

}

void MagJSon::write(ostream& out, const json_spirit::Value& value)
{
	switch(value.type()) {
	        case obj_type :
	        	out << "Object" << endl;
	            break;
	        case array_type :
	        	write(out, value.get_value< Array >());
	            break;
	            break;
	        case str_type :
	        	out << value.get_value< string >();
	            break;
	        case bool_type :
	        	out << ( value.get_value< bool >() ) ? "on" : "off";
	            break;
	        case int_type :
	        	out << value.get_value< int >();
	            break;
	        case real_type:
	        	out << value.get_value< double >();
	            break;
	        case null_type :
	            Log::dev()<< "null" << endl;
	            break;
	        default:
	            Log::dev()<< "not yet" << endl;
	    }

}







void MagJSon::write(ostream& out, const  json_spirit::Array& a)
{	
	string sep = "";
	out << "\"";
	for( unsigned int i = 0; i < a.size(); ++i ) {
		out << sep;
		write(out,  a[i]);
		sep = "/";
	 }
	 out << "\"";    
}

void MagJSon::write(ostream& out, const  json_spirit::Object& o)
{	
	for (vector<Pair>::const_iterator p = o.begin(); p !=  o.end(); ++p) {
		if (p->value_.type() != obj_type ) {			
			        
		out <<  p->name_ << "=\""; 
		write(out, p->value_);
		out << "\" ";
		}
		else {
			
		}
	}
}




