/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: source.h,v 1.23 2003/04/08 13:32:29 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SOURCE_H_INCLUDED
#define ZORP_SOURCE_H_INCLUDED

#include <zorp/stream.h>
#include <zorp/zorplib.h>
#include <zorp/io.h>

#ifdef __cplusplus
extern "C" {
#endif

GSource *z_threshold_source_new(guint idle_threshold, guint busy_threshold);
void z_threshold_source_set_threshold(GSource *source, guint idle_threshold, guint busy_threshold);

void z_timeout_source_set_timeout(GSource *s, gulong new_timeout);
GSource *z_timeout_source_new(gulong initial_timeout);

#ifdef __cplusplus
}
#endif

#endif
