/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: process.h,v 1.4 2004/01/09 10:44:31 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_PROCESS_H_INCLUDED
#define ZORP_PROCESS_H_INCLUDED

#include <sys/types.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef G_OS_WIN32
  typedef unsigned int uid_t; 
  typedef unsigned int gid_t;
#endif

#ifdef G_OS_WIN32
  gboolean z_process_daemonize(uid_t uid, gid_t gid, const gchar *pidfile);
#else
  gboolean z_process_daemonize(const gchar *progname, uid_t uid, gid_t gid, const gchar *pidfile);
#endif

void z_process_failed(guint ret_num, gboolean may_exit);
void z_process_ok(void);

#ifdef __cplusplus
}
#endif

#endif
