#!/usr/src/ruby
#
#  makerd.rb
#
#  Copyright (C) UENO Katsuhiro 2002
#

Headlines = {
  'en' => {
    'ѡ饹' => 'SuperClass',
    '󥯥롼ɤƤ⥸塼' => 'Included Module',
    '⥸塼ؿ' => 'Module Functions',
    '饹᥽å' => 'Class Methods',
    '᥽å' => 'Methods',
    '' => 'Constants',
  }
}


lang = ARGV.shift
lang = 'ja' unless lang

headlines = Headlines[lang]
headline_proc = nil

if headlines then
  src = "proc { |s|\n  case s\n"
  headlines.each { |k,v|
    src << "  when /\\A=== *#{k}:\\Z/ then \"=== #{v}:\\n\"\n"
  }
  src << "  else s\n  end\n}\n"
  headline_proc = eval(src)
end

while line = gets
  line = headline_proc.call(line) if headline_proc
  if /\A(#?\s*)([a-z_][a-z_]|#+)\|[ \t]*\|?/ =~ line then
    next unless $2 == lang or $2 == '__'
    line = $1 + $'
  end
  print line
end
