# -*- ruby -*-
#
# Using <xt:property>. See also sample10.rb.
#

require 'xtemplate'

class Link
  attr_reader :url, :name

  def initialize(url, name)
    @url = url
    @name = name
  end

  def href(ty = nil)
    ty ||= 'http'
    "#{ty}://#{@url}/"
  end
end

data ={
  'links' => [
    Link.new("www.foo.my", "anchor1"),
    Link.new("www.bar.my", "anchor2"),
    Link.new("ftp.foo.my", "anchor3"),
  ]
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<html>
<body>
  <ul>
    <xt:select id="/links{link}" xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
    <li><a><xt:attribute id="." name="href"><xt:property id="link" name="href" with="'http'" /></xt:attribute><xt:property id="link" name="name" /></a></li>
    </xt:select>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
