/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPoolEntry;

public class ClassFile {
    private static final int CLASS_MAGIC = -889275714;
    private ConstantPool constantPool;
    private String className;

    public void read(InputStream stream) throws IOException, ClassFormatError {
        DataInputStream classStream = new DataInputStream(stream);
        if (classStream.readInt() != -889275714) {
            throw new ClassFormatError("No Magic Code Found - probably not a Java class file.");
        }
        int minorVersion = classStream.readUnsignedShort();
        int majorVersion = classStream.readUnsignedShort();
        this.constantPool = new ConstantPool();
        this.constantPool.read(classStream);
        this.constantPool.resolve();
        int accessFlags = classStream.readUnsignedShort();
        int thisClassIndex = classStream.readUnsignedShort();
        int superClassIndex = classStream.readUnsignedShort();
        ClassCPInfo classInfo = (ClassCPInfo)this.constantPool.getEntry(thisClassIndex);
        this.className = classInfo.getClassName();
    }

    public Vector getClassRefs() {
        Vector<String> classRefs = new Vector<String>();
        int i = 0;
        while (i < this.constantPool.size()) {
            ClassCPInfo classEntry;
            ConstantPoolEntry entry = this.constantPool.getEntry(i);
            if (entry != null && entry.getTag() == 7 && !(classEntry = (ClassCPInfo)entry).getClassName().equals(this.className)) {
                classRefs.addElement(ClassFileUtils.convertSlashName(classEntry.getClassName()));
            }
            ++i;
        }
        return classRefs;
    }

    public String getFullClassName() {
        return ClassFileUtils.convertSlashName(this.className);
    }
}

