/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.trax;

import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax2.SAXTwoOMBuilder;
import com.jclark.xsl.sax2.XMLProcessorImpl;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.tr.XMLProcessor;
import com.jclark.xsl.trax.TemplatesImpl;
import com.jclark.xsl.trax.TransformerFactoryImpl;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

class TemplatesHandlerImpl
extends XMLFilterImpl
implements TemplatesHandler {
    private TransformerFactoryImpl _factory;
    private String _systemId = null;
    private Templates _templates = null;
    private SAXTwoOMBuilder _builder = null;
    private XMLProcessor _sheetModelBuilder = null;
    private Engine _engine = null;

    protected TemplatesHandlerImpl(TransformerFactoryImpl factory, XMLProcessor sheetModelBuilder) throws SAXException {
        this._factory = factory;
        this._sheetModelBuilder = sheetModelBuilder;
        this._engine = new EngineImpl(this._sheetModelBuilder, new ExtensionHandlerImpl());
    }

    public Templates getTemplates() {
        try {
            Sheet sheet = this._engine.createSheet(this._builder.getRootNode());
            if (sheet == null) {
                throw new Exception("unable to build xheet");
            }
            this._templates = new TemplatesImpl(sheet, this._engine, this._factory);
        }
        catch (Exception ex) {
            System.err.println("trouble creating sheet");
            ex.printStackTrace();
            return null;
        }
        return this._templates;
    }

    public void startDocument() throws SAXException {
        this._builder = XMLProcessorImpl.createBuilder(this._systemId, 0, this._engine.getSheetLoadContext(), this._engine.getNameTable());
        super.setContentHandler(this._builder);
        super.setDTDHandler(this._builder);
        this._builder.startDocument();
    }

    public void endDocument() throws SAXException {
        this._builder.endDocument();
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public String getSystemId() {
        return this._systemId;
    }
}

