/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;

class MultiLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    MultiLevelNumberAction(Pattern count, Pattern from, NumberListFormatTemplate formatTemplate) {
        this.count = count;
        this.from = from;
        this.formatTemplate = formatTemplate;
    }

    public void invoke(ProcessContext context, Node node, Result result) throws XSLException {
        int n;
        NumberListFormat format = this.formatTemplate.instantiate(context, node);
        if (this.count == null) {
            n = node.getType() == 0 ? this.numberUp(node.getName(), format, context, node, result) : 0;
        } else {
            Cache cache = (Cache)context.get(this);
            if (cache == null) {
                cache = new Cache();
                context.put(this, cache);
            }
            n = this.numberUp(format, context, cache, node, result);
        }
        if (n == 0) {
            result.characters(format.getPrefix(0));
        }
        result.characters(format.getSuffix());
    }

    private int numberUp(NumberListFormat format, ProcessContext context, Cache cache, Node node, Result result) throws XSLException {
        Node parent;
        do {
            int n;
            parent = node.getParent();
            if (this.from != null && this.from.matches(node, context)) break;
            if (!this.count.matches(node, context)) continue;
            int level = this.numberUp(format, context, cache, parent, result);
            CacheEntry entry = cache.get(level);
            if (parent == null) {
                n = 1;
            } else if (node.equals(entry.child)) {
                n = entry.n;
            } else if (parent.equals(entry.parent) && entry.child.compareTo(node) < 0) {
                n = entry.n;
                SafeNodeIterator iter = entry.child.getFollowingSiblings();
                while (true) {
                    Node tem;
                    if (!this.count.matches(tem = iter.next(), context)) {
                        continue;
                    }
                    ++n;
                    if (tem.equals(node)) break;
                }
                entry.n = n;
                entry.child = node;
            } else {
                n = 0;
                SafeNodeIterator iter = parent.getChildren();
                while (true) {
                    Node tem;
                    if (!this.count.matches(tem = iter.next(), context)) {
                        continue;
                    }
                    ++n;
                    if (tem.equals(node)) break;
                }
                entry.parent = parent;
                entry.child = node;
                entry.n = n;
            }
            result.characters(format.getPrefix(level));
            result.characters(format.formatNumber(level, n));
            return level + 1;
        } while ((node = parent) != null);
        return 0;
    }

    private int numberUp(Name name, NumberListFormat format, ProcessContext context, Node node, Result result) throws XSLException {
        int i = 0;
        for (Node tem = node.getParent(); tem != null; tem = tem.getParent()) {
            if (!name.equals(tem.getName())) continue;
            i = this.numberUp(name, format, context, tem, result);
            break;
        }
        int n = 0;
        SafeNodeIterator iter = node.getParent().getChildren();
        while (true) {
            Node tem;
            if (!name.equals((tem = iter.next()).getName()) || tem.getType() != 0) {
                continue;
            }
            ++n;
            if (tem.equals(node)) break;
        }
        result.characters(format.getPrefix(i));
        result.characters(format.formatNumber(i, n));
        return i + 1;
    }

    static final class Cache {
        static final int SPARE = 4;
        CacheEntry[] entries;

        Cache() {
        }

        CacheEntry get(int level) {
            if (this.entries == null) {
                this.entries = new CacheEntry[level + 1 + 4];
            } else if (level >= this.entries.length) {
                CacheEntry[] old = this.entries;
                this.entries = new CacheEntry[level + 1 + 4];
                System.arraycopy(old, 0, this.entries, 0, old.length);
            }
            if (this.entries[level] == null) {
                this.entries[level] = new CacheEntry();
            }
            return this.entries[level];
        }
    }

    static final class CacheEntry {
        Node parent;
        Node child;
        int n;

        CacheEntry() {
        }
    }
}

