/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.util.HashMap;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DitaValReader
extends AbstractReader
implements ContentHandler {
    private HashMap filterMap = new HashMap();
    private ContentImpl content;
    private XMLReader reader;

    public DitaValReader() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void read(String filename) {
        try {
            this.reader.parse(filename);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public Content getContent() {
        this.content = new ContentImpl();
        this.content.setCollection(this.filterMap.entrySet());
        return this.content;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("prop")) {
            String action = atts.getValue("action");
            String key = atts.getValue("att") + "=" + atts.getValue("val");
            if (action != null) {
                if (this.filterMap.get(key) == null) {
                    this.filterMap.put(key, action);
                } else {
                    System.out.println("duplicate condition in filter file");
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

