/*  xfce4
 *  
 *  Copyright (C) 2003 Jasper Huijsmans (huysmans@users.sourceforge.net)
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _LIBXFCEGUI4_DIALOGS_H
#define _LIBXFCEGUI4_DIALOGS_H

#include <stdarg.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

/* new wrappers aroung gtk_message_dialog */
extern void xfce_err (const gchar *, ...);
extern void xfce_verr (const gchar *, va_list);
extern void xfce_warn (const gchar *, ...);
extern void xfce_vwarn (const gchar *, va_list);
extern void xfce_info (const gchar *, ...);
extern void xfce_vinfo (const gchar *, va_list);

/* wrappers around gtk_message_dialog (OBSOLETE) */
void show_info (const char *text);
void show_warning (const char *text);
void show_error (const char *text);

/* confirmation dialog; has 'cancel' and 'confirm' buttons.
   if 'action' is given this text is used on the confirm button
   together with the stock icon given by 'stock'.
   if 'action' is NULL, the stock text is used as well.
*/
gboolean confirm (const char *text, const char *stock, const char *action);


/* create a header with optional icon (may be NULL) in larger bold font;
 * background and foreground colors are taken from gtk */
GtkWidget *create_header (GdkPixbuf * icon, const char *text);

/* creates a button with stock icon and text */
GtkWidget *mixed_button_new (const char *stock, const char *text);

/* Create a small italic label */
GtkWidget *small_label (const char *text);

/* command execution with error dialog */
gboolean exec_command (gchar * command);
gboolean exec_command_full_with_envp (gchar ** argv, gchar ** envp);

#endif /* _LIBXFCEGUI4_DIALOGS_H */
