/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

extern int WX11_INTERLINE_SPACE;
extern int WX11_SPACE_BETWEEN_BORDERS;


void WX11_ComandoFocus (CmdInfo *cmd, int mode)
{
	Display *dpy=WX11_GetDisplay();
	Pixmap pixmap;
	unsigned int gradiant_from,gradiant_to;
	if (mode)
	{
		gradiant_from=WX11_ColorLight(cmd->Bg);
		gradiant_to  =WX11_ColorDarkSmall (cmd->Bg);
	}
	else
	{
		gradiant_from=(cmd->Gradiant) ? WX11_ColorLightSmall(cmd->Bg) : cmd->Bg;
		gradiant_to  =WX11_ColorDarkSmall (cmd->Bg);
	}


	if (mode || cmd->Gradiant)
	{
        	pixmap=XCreatePixmap(dpy, cmd->win, cmd->Width, cmd->Height, WX11_GetDepth ());

        	WX11_ColorGradiant (pixmap, cmd->Width, cmd->Height, gradiant_from,gradiant_to);

        	XSetWindowBackgroundPixmap (dpy,cmd->win,pixmap);

        	XFreePixmap(dpy, pixmap);
		
	}
	else
		XSetWindowBackground(dpy, cmd->win, WX11_RGB(gradiant_from));


	XClearWindow (WX11_GetDisplay(),cmd->win);
}


void WX11_MapFlush (CmdInfo *cmd)
{
    //
    // Map cmd and all subcmd
    //
    XMapWindow (WX11_GetDisplay(),cmd->win);
	
    XFlush (WX11_GetDisplay()); // Solo per Tipo MAIN ?!

}

void WX11_LabelPrint (CmdInfo *cmd,GC gc)
{
    //
    // Draw Label String
    // TODO should use this function
    // 
    char *tmp,*pi,*pe;
    int posx=0;
    int posy=0;

    if (cmd->Tipo==BUTTON)
    {
        posx=(cmd->Width-XTextWidth(cmd->Font, cmd->Label,strlen(cmd->Label)))/2;
        posy=((cmd->Height/2)+(cmd->Font->ascent/2))-2;
    }
    else if (cmd->Tipo==MENU_ITEM || cmd->Tipo==CHECK_BOX)
    {
	posx=WX11_SPACE_BETWEEN_BORDERS+20;
        posy=cmd->Font->ascent;
    }
    else
    {
	posx=WX11_SPACE_BETWEEN_BORDERS;
        posy=cmd->Font->ascent;
    }

    if (!cmd || !cmd->Label) return;

    tmp=(char *) malloc (sizeof(char) * strlen(cmd->Label)+1);
    if (!tmp) return;

    strcpy (tmp,cmd->Label);
    pi=tmp;
    pe=pi;

    int lf=0;
    for (;;)
    {
        if (*pe=='\n')
        { *pe='\0'; lf=1; }
        if (*pe=='\0')
        {
            //
            XSetFont(WX11_GetDisplay(), gc, cmd->Font->fid);
            XDrawString(WX11_GetDisplay(),cmd->win,gc,posx,posy,pi,pe-pi);
            //
            if (!lf) break;
            lf=0; pi=pe+1; posy+=(cmd->Font->ascent)+WX11_INTERLINE_SPACE;
        }
        pe++;
    }

    free (tmp);
}

void WX11_PrintFlush (CmdInfo *cmd)
{
    //
    // force Redraw
    //
    // if cmd==NULL flush all cmd
    //
    CmdInfo *Pb=cmd;
    unsigned int colorbg,colorfg;
    //int posx,posy;
    GC gc;
    //
    if (Pb==NULL) Pb=PrimoComando (0,NULL);
    while (Pb)
    {
        gc=WX11_GCGet();

        if (Pb->Tipo==BORDO)
            Pb=Pb->Next;

        colorfg=Pb->Fg;


/*
        if ((Pb->MouseOver || Pb->Focus))
        {
            if (Pb->Tipo==BUTTON)
                colorbg=WX11_ColorLight(WX11_ColorGet(BUTTONBG));
            else
                colorbg= WX11_ColorLightSmall(WX11_ColorGet(BUTTONBG));

	    WX11_ComandoFocus (Pb, colorbg, WX11_ColorDarkSmall(WX11_ColorGet(BUTTONBG)));

            XClearWindow (WX11_GetDisplay(),Pb->win);
        }
*/

/*
        if ((Pb->Tipo==BUTTON || Pb->IsButton))
        {
            if (Pb->MouseOver || Pb->Focus)
                colorbg=WX11_ColorLight(WX11_ColorGet(BUTTONBG));
            else
                colorbg= WX11_ColorLightSmall(WX11_ColorGet(BUTTONBG));

		WX11_ComandoFocus (Pb, colorbg, WX11_ColorDarkSmall(WX11_ColorGet(BUTTONBG)));

	    printf ("zap\n");
            XClearWindow (WX11_GetDisplay(),Pb->win);
        }
*/


        if (Pb->Tipo==MENU)//if (Pb->Tipo==MENU || Pb->Tipo==MENU_ITEM)
        {
            if (Pb->Focus)
                colorbg=WX11_ColorLight(WX11_ColorGet(MENUBG));
            else
                colorbg=Pb->Bg;

            XSetWindowBackground(WX11_GetDisplay(), Pb->win, WX11_RGB(colorbg));
            XClearWindow (WX11_GetDisplay(),Pb->win);
        }
        if (Pb->Tipo==MENU_ITEM)//if (Pb->Tipo==MENU || Pb->Tipo==MENU_ITEM)
        {
            if (Pb->MouseOver || Pb->Focus)
                colorbg=WX11_ColorLight(WX11_ColorGet(MENUBG));
            else
                colorbg=Pb->Bg;

            XSetWindowBackground(WX11_GetDisplay(), Pb->win, WX11_RGB(colorbg));
            XClearWindow (WX11_GetDisplay(),Pb->win);
        }
        if (Pb->Tipo==LIST_BOX || Pb->Tipo==COMBO_BOX)
        {
            if (Pb->Focus || Pb->Stato)
                colorbg=WX11_ColorLight(WX11_ColorGet(MENUBG));
            else if (Pb->MouseOver)
                colorbg= WX11_ColorLightSmall(WX11_ColorGet(MENUBG));
            else
                colorbg=Pb->Bg;

            XSetWindowBackground(WX11_GetDisplay(), Pb->win, WX11_RGB(colorbg));
            XClearWindow (WX11_GetDisplay(),Pb->win);
        }

        XSetForeground(WX11_GetDisplay(), gc, WX11_RGB(colorfg));
/*
        if (Pb->pixmap && Pb->ximage==NULL)
        {
            XSetBackground(WX11_GetDisplay(), gc, WX11_RGB(Pb->Bg));
            XCopyPlane(WX11_GetDisplay(), Pb->pixmap, Pb->win, gc,0, 0, 
            Pb->bitmap_width, Pb->bitmap_height,1, 1,1);
        }
*/

	if (Pb->pix)
	{
		if (Pb->pix_depth==1)
		{
			XCopyPlane(WX11_GetDisplay(), Pb->pix, Pb->win, Pb->gc,0, 0, Pb->pix_width, Pb->pix_height,Pb->pix_x, Pb->pix_y,1);
		}
		else
			XCopyArea(WX11_GetDisplay(), Pb->pix, Pb->win, Pb->gc, 0, 0, Pb->pix_width, Pb->pix_height, Pb->pix_x, Pb->pix_y);

		//XCopyPlane(WX11_GetDisplay(), Pb->pixmap, Pb->win, gc,0, 0, 
            	//Pb->bitmap_width, Pb->bitmap_height,1, 1,1);
	}
/*
        if (Pb->ximage)
        {
            //printf ("print image\n");
            GC g = gc;
            if (Pb->pixmap)
            {
                if (!Pb->gc)
                {   Pb->gc=WX11_GCNew (Pb->win); }
                g=Pb->gc;
                //
                int x=0;
                int y=0;
                XSetClipMask(WX11_GetDisplay(), g, Pb->pixmap);
                XSetClipOrigin(WX11_GetDisplay(), g, x, y);
            }
            XPutImage (WX11_GetDisplay(), Pb->win, g, Pb->ximage, 0, 0, 0, 0, Pb->ximage_width, Pb->ximage_height);

        }
*/
        if (Pb->Label && strlen(Pb->Label))
        {
            WX11_LabelPrint (Pb,gc);
        }
		
        if (Pb->Tipo==INPUT && Pb->Focus==1)
        {
            //
        }

        if (Pb->Bordo)
            WX11_BorderRelief (Pb);

        if (Pb->Tipo==SCROLL_UP || 
            Pb->Tipo==SCROLL_DN || 
            Pb->Tipo==SCROLL_SX ||
            Pb->Tipo==SCROLL_DX )
                WX11_DrawArrow (Pb);

        if (cmd) Pb=NULL; else Pb=Pb->Next;
			
    }
}

