/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "support.h"

START_TEST (check_md5_1)
{
	char *data = "";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "d41d8cd98f00b204e9800998ecf8427e"), NULL);
}
END_TEST

START_TEST (check_md5_2)
{
	char *data = "a";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "0cc175b9c0f1b6a831c399e269772661"), NULL);
}
END_TEST

START_TEST (check_md5_3)
{
	char *data = "abc";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "900150983cd24fb0d6963f7d28e17f72"), NULL);
}
END_TEST

START_TEST (check_md5_4)
{
	char *data = "message digest";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "f96b697d7cb7938d525a2f31aaf161d0"), NULL);
}
END_TEST

START_TEST (check_md5_5)
{
	char *data = "abcdefghijklmnopqrstuvwxyz";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "c3fcd3d76192e4007dfb496cca67e13b"), NULL);
}
END_TEST

START_TEST (check_md5_6)
{
	char *data = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "d174ab98d277d9f5a5611c2c9f419d9f"), NULL);
}
END_TEST

START_TEST (check_md5_7)
{
	char *data =  "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
	unsigned char digest[16];

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, NULL);
	fail_unless(!strcmp(md5, "57edf4a22be3c955ac49da2e2107b67a"), NULL);
}
END_TEST

Suite *md5_suite(void)
{
	Suite *s = suite_create("MD5");
	//Suite *s2 = suite_create("MD5");
	
	create_case(s, "check_md5_1", check_md5_1);
	create_case(s, "check_md5_2", check_md5_2);
	create_case(s, "check_md5_3", check_md5_3);
	create_case(s, "check_md5_4", check_md5_4);
	create_case(s, "check_md5_5", check_md5_5);
	create_case(s, "check_md5_6", check_md5_6);
	create_case(s, "check_md5_7", check_md5_7);
	
	return s;
}

int main(void)
{
	int nf;

	Suite *s = md5_suite();
	
	SRunner *sr;
	sr = srunner_create(s);
	srunner_run_all(sr, CK_NORMAL);
	nf = srunner_ntests_failed(sr);
	srunner_free(sr);
	return (nf == 0) ? 0 : 1;
}
