/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_SUPPORT_H_
#define _SML_SUPPORT_H_

/*! @ingroup SmlDebugAPI
 * @brief The type of the trace */
typedef enum {
	/** Used when entering a function. This will indent the callgraph */
	TRACE_ENTRY,
	/** Used when exiting a function. This will unindent the callgraph */
	TRACE_EXIT,
	/** Used for traces inside a function. Does not indent. */
	TRACE_INTERNAL,
	/** Used for reporting errors. Does not ident. */
	TRACE_ERROR,
	/** Used when exiting a function with a error. This will unindent the callgraph */
	TRACE_EXIT_ERROR
} SmlTraceType;

void smlLog(const char *logname, const char *data, unsigned int size);
void smlTrace(SmlTraceType type, const char *message, ...);
char *smlPrintBinary(const char *data, int len);
char *smlPrintHex(const char *data, int len);
char *smlRandStr(int maxlength, SmlBool exact);
void *smlTryMalloc0(long n_bytes, SmlError **error);

typedef struct SmlThread {
	GThread *thread;
	GCond *started;
	GMutex *started_mutex;
	GMainContext *context;
	GMainLoop *loop;
} SmlThread;

SmlThread *smlThreadNew(GMainContext *context, SmlError **error);
void smlThreadFree(SmlThread *thread);
void smlThreadStart(SmlThread *thread);
void smlThreadStop(SmlThread *thread);

#endif //_SML_SUPPORT_H_
