/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_ATOM_H
#define PXMCHEM_ATOM_H

#include "libpolyxmass-globals.h"
#include "libpolyxmass-masspair.h"



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* typedef's
 */
typedef struct _PxmAtom PxmAtom;
typedef struct _PxmAtomcount PxmAtomcount;


struct _PxmAtom
{
  gchar *name;
  gchar *symbol;

  gdouble avg;
  gdouble mono;

  GPtrArray *massGPA;
  GPtrArray *abundGPA;
};


struct _PxmAtomcount
{
  gchar atom [MAX_ATOM_SYMBOL_LEN + 1];
  gint count;
};


/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmAtomcount *
pxmchem_atomcount_new (void);


PxmAtomcount *
pxmchem_atomcount_dup (const PxmAtomcount *atomcount);


PxmAtom *
pxmchem_atom_new (void);


PxmAtom *
pxmchem_atom_new_by_symbol (gchar *symbol, GPtrArray *atom_refGPA);


PxmAtom *
pxmchem_atom_dup (const PxmAtom *atom);


/* DATA MODIFYING FUNCTIONS
 */
gboolean
pxmchem_atom_set_name (PxmAtom *atom, gchar *name);

gboolean
pxmchem_atom_set_symbol (PxmAtom *atom, gchar *symbol);


gboolean
pxmchem_atom_fill_masspair (gchar *symbol, PxmMasspair *masspair,
			    GPtrArray *atom_refGPA);

/* LOCATING FUNCTIONS
 */
gint
pxmchem_atom_get_index_by_ptr (GPtrArray *GPA,  PxmAtom *atom);

gint
pxmchem_atom_get_index_by_name (gchar *name, GPtrArray *GPA);

gint
pxmchem_atom_get_index_top_by_name (gchar *name, GPtrArray *GPA);

gint
pxmchem_atom_get_index_bottom_by_name (gchar *name, GPtrArray *GPA);

gint
pxmchem_atom_get_index_by_symbol (gchar *symbol, GPtrArray *GPA);

gint
pxmchem_atom_get_index_top_by_symbol (gchar *symbol, GPtrArray *GPA);

gint
pxmchem_atom_get_index_bottom_by_symbol (gchar *symbol, GPtrArray *GPA);






/* INTEGRITY CHECKING FUNCTIONS
 */
gboolean
pxmchem_atom_known_by_symbol (gchar *symbol, gint *idx,
			      GPtrArray *atom_refGPA);


gboolean
pxmchem_atom_check_symbol_syntax (gchar *symbol);


gboolean
pxmchem_atom_check_data_integrity (PxmAtom *atom);

gboolean
pxmchem_atom_array_validate_all (GPtrArray *atomGPA, gchar **valid);



/* COMPUTATION FUNCTIONS
 */
gboolean
pxmchem_atom_calc_avg_by_symbol (gchar *symbol, gdouble *avg,
				 GPtrArray *atom_refGPA);

gboolean
pxmchem_atom_set_mono_in_atom (PxmAtom *atom);

gboolean
pxmchem_atom_calc_avg_in_atom (PxmAtom *atom);


/* XML-format TRANSACTIONS
 */
gchar *
pxmchem_atomdef_format_xml_string_DTD (void);

gchar *
pxmchem_atom_format_xml_string_atom (PxmAtom *atom, 
				 gchar *indent, gint offset);
gchar *
pxmchem_atom_format_xml_string_atomdefdata (GPtrArray *atomGPA,
					    gchar *indent, gint offset);

PxmAtom *
pxmchem_atom_render_xml_node_atom (xmlDocPtr xml_doc,
				   xmlNodePtr xml_node,
				   gpointer user_data);

gboolean
pxmchem_atom_render_xml_node_isotope (xmlDocPtr xml_doc,
				      xmlNodePtr xml_node,
				      PxmAtom *atom,
				      gpointer user_data);

gint
pxmchem_atom_render_xml_file (gchar *file, GPtrArray *fillGPA);



/* FREE'ING FUNCTIONS
 */
gboolean
pxmchem_atom_free (PxmAtom *atom);


gboolean
pxmchem_atomcount_free (PxmAtomcount *atomcount);


/* GPtrArray-RELATED FUNCTIONS
 */
gint
pxmchem_atom_GPA_empty (GPtrArray *GPA);

gint
pxmchem_atom_GPA_free (GPtrArray *GPA);

gint
pxmchem_atomcount_GPA_empty (GPtrArray *GPA);

gint
pxmchem_atomcount_GPA_free (GPtrArray *GPA);





#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* PXMCHEM_ATOM_H */
