#!/usr/bin/perl
# $Id: Makefile.PL,v 1.3 2002/09/10 03:35:21 rcaputo Exp $

use ExtUtils::MakeMaker;

# Touch CHANGES so it exists.
open(CHANGES, ">>CHANGES") and close CHANGES;

WriteMakefile
  ( NAME         => 'POE::Component::Client::Ping',
    AUTHOR       => 'Rocco Caputo <rcaputo@cpan.org>',
    ABSTRACT     => 'POE component for non-blocking/concurrent ICMP ping.',
    VERSION_FROM => 'Ping.pm',

    PM           => { 'Ping.pm'   => '$(INST_LIBDIR)/Ping.pm' },
    PREREQ_PM    => { POE         => 0.11,
                      Time::HiRes => 1.20,
                    },
    dist         =>
    { COMPRESS   => 'gzip -9f',
      SUFFIX     => 'gz',
      PREOP      => ( 'cvs-log.perl | ' .
                      'tee ./$(DISTNAME)-$(VERSION)/CHANGES > ./CHANGES'
                    ),
    },
  );
