// -*- c++ -*-
/* $Id: init.cc 622 2004-03-29 17:59:17Z murrayc $ */

/* init.cc
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libnotifymm/init.h>
#include <glibmm/init.h>
#include <libnotifymmconfig.h> //For LIBGDAMM_VERSION
#include <libnotifymm/wrap_init.h>
#include <libnotify/notify.h>


namespace Notify
{
bool init(const Glib::ustring& app_name)
{
  Glib::init(); //Sets up the g type system and the Glib::wrap() table.
  wrap_init(); //Tells the Glib::wrap() table about the libgnomecanvasmm classes.
  return notify_init(app_name.c_str());
}

void uninit()
{
	notify_uninit();
}

bool is_initted()
{
	return notify_is_initted();
}
} //namespace Notify
