/*
 * Decompiled with CFR 0.152.
 */
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.JTextComponent;

public final class FontTest {
    private JTextComponent textArea;

    public static void main(String[] args) {
        FontTest instance = new FontTest();
        instance.buildInterface();
    }

    private void initComponents() {
        this.textArea = new JTextArea();
        this.textArea.setText(this.readConfiguration());
    }

    private void buildInterface() {
        this.initComponents();
        JFrame frame = new JFrame();
        frame.setContentPane(this.buildContentPane());
        frame.setSize(400, 600);
        this.locateOnScreen(frame);
        frame.setTitle("JGoodies Looks :: FontTest");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private JComponent buildContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.textArea), "Center");
        return panel;
    }

    private void locateOnScreen(Frame frame) {
        Dimension paneSize = frame.getSize();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    private String readConfiguration() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Please copy the information below to your clipboard");
        buffer.append("\nand send them to dev@looks.dev.java.net");
        this.addSystemProperties(buffer, "Java environment:", new String[]{"java.vendor", "java.version", "java.runtime.version", "java.vm.version", "sun.desktop"});
        this.addSystemProperties(buffer, "Operating System:", new String[]{"os.name", "os.version"});
        if (LookUtils.IS_OS_WINDOWS) {
            this.addWindowsSettings(buffer, "Windows Settings:");
        }
        this.addAWTProperties(buffer, "AWT Properties:");
        this.addSystemProperties(buffer, "User Settings:", new String[]{"user.language", "user.country", "user.timezone"});
        this.addDesktopProperties(buffer, "Desktop Properties:", new String[]{"win.defaultGUI.font", "win.icon.font", "win.menu.font", "win.messagebox.font", "win.ansiVar.font", "win.ansiFixed.font", "win.frame.captionFont", "win.tooltip.font"});
        this.addInternationalizationProperties(buffer);
        this.addFontSet(buffer, "JGoodies Windows L&f:", this.getWindowsFontSet());
        this.addFontSet(buffer, "JGoodies Plastic L&fs:", this.getPlasticFontSet());
        buffer.append("\n\n");
        return buffer.toString();
    }

    private void addSystemProperties(StringBuffer buffer, String description, String[] keys) {
        buffer.append("\n\n");
        buffer.append(description);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = LookUtils.getSystemProperty(key, "n/a");
            buffer.append("\n    ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
        }
    }

    private void addDesktopProperties(StringBuffer buffer, String description, String[] keys) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        buffer.append("\n\n");
        buffer.append(description);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = toolkit.getDesktopProperty(key);
            String printString = value == null ? "n/a" : (value instanceof Font ? this.encodeFont((Font)value) : value.toString());
            buffer.append("\n    ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(printString);
        }
    }

    private void addInternationalizationProperties(StringBuffer buffer) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        buffer.append("\n\n");
        buffer.append("Internationalization:");
        Font defaultGUIFont = (Font)toolkit.getDesktopProperty("win.defaultGUI.font");
        Font iconFont = (Font)toolkit.getDesktopProperty("win.icon.font");
        Locale locale = Locale.getDefault();
        buffer.append("\n    defaultLocale.getDisplayName(Locale.ENGLISH)=");
        buffer.append(locale.getDisplayName(Locale.ENGLISH));
        buffer.append("\n    defaultLocale.getDisplayLanguage(Locale.ENGLISH)=");
        buffer.append(locale.getDisplayLanguage(Locale.ENGLISH));
        buffer.append("\n    defaultLocale.getDisplayLanguage(defaultLocale)=");
        buffer.append(locale.getDisplayLanguage(locale));
        buffer.append("\n    locale has localized display language=" + FontTest.localeHasLocalizedDisplayLanguage(locale));
        buffer.append("\n    defaultGUI font can display localized text=");
        buffer.append(FontTest.yesNoDontKnow(Fonts.canDisplayLocalizedText(defaultGUIFont, locale)));
        buffer.append("\n    icon font can display localized text=");
        buffer.append(FontTest.yesNoDontKnow(Fonts.canDisplayLocalizedText(iconFont, locale)));
    }

    private static String yesNoDontKnow(Boolean b) {
        if (Boolean.TRUE.equals(b)) {
            return "yes";
        }
        if (Boolean.FALSE.equals(b)) {
            return "no";
        }
        return "don't know";
    }

    private void addFontSet(StringBuffer buffer, String description, FontSet fontSet) {
        buffer.append("\n\n");
        buffer.append(description);
        if (fontSet == null) {
            buffer.append("\n  n/a");
            return;
        }
        buffer.append("\n    controlFont=");
        buffer.append(this.encodeFont(fontSet.getControlFont()));
        buffer.append("\n    menuFont=");
        buffer.append(this.encodeFont(fontSet.getMenuFont()));
        buffer.append("\n    titleFont=");
        buffer.append(this.encodeFont(fontSet.getTitleFont()));
        buffer.append("\n    messageFont=");
        buffer.append(this.encodeFont(fontSet.getMessageFont()));
        buffer.append("\n    smallFont=");
        buffer.append(this.encodeFont(fontSet.getSmallFont()));
        buffer.append("\n    windowTitleFont=");
        buffer.append(this.encodeFont(fontSet.getWindowTitleFont()));
    }

    private void addWindowsSettings(StringBuffer buffer, String description) {
        buffer.append("\n\n");
        buffer.append(description);
        buffer.append("\n    Modern Windows=");
        buffer.append(LookUtils.IS_OS_WINDOWS_MODERN);
        buffer.append("\n    Windows XP=");
        buffer.append(LookUtils.IS_OS_WINDOWS_XP);
        buffer.append("\n    Windows 6 or later=");
        buffer.append(LookUtils.IS_OS_WINDOWS_6_OR_LATER);
        buffer.append("\n    Windows L&f XP Mode=");
        buffer.append(LookUtils.IS_LAF_WINDOWS_XP_ENABLED);
    }

    private void addAWTProperties(StringBuffer buffer, String description) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        buffer.append("\n\n");
        buffer.append(description);
        buffer.append("\n    awt.toolkit=");
        buffer.append(toolkit.getClass().getName());
        buffer.append("\n    screen.size=");
        buffer.append(toolkit.getScreenSize().width);
        buffer.append(" x ");
        buffer.append(toolkit.getScreenSize().height);
        buffer.append("\n    screen.resolution=");
        buffer.append(toolkit.getScreenResolution());
        buffer.append("  ");
        buffer.append(LookUtils.IS_LOW_RESOLUTION ? "(low)" : "(high)");
    }

    private String encodeFont(Font font) {
        StringBuffer buffer = new StringBuffer(font.getName());
        buffer.append('-');
        String style = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        buffer.append(style);
        buffer.append('-');
        buffer.append(font.getSize());
        if (!font.getName().equals(font.getFamily())) {
            buffer.append(" family=");
            buffer.append(font.getFamily());
        }
        return buffer.toString();
    }

    private FontSet getWindowsFontSet() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)((Object)new WindowsLookAndFeel()));
            return WindowsLookAndFeel.getFontPolicy().getFontSet("Windows", UIManager.getDefaults());
        }
        catch (UnsupportedLookAndFeelException e) {
            return null;
        }
    }

    private FontSet getPlasticFontSet() {
        try {
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
            return PlasticLookAndFeel.getFontPolicy().getFontSet("Plastic", UIManager.getDefaults());
        }
        catch (UnsupportedLookAndFeelException e) {
            return null;
        }
    }

    private static boolean localeHasLocalizedDisplayLanguage(Locale locale) {
        String localizedDisplayLanguage;
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return true;
        }
        String englishDisplayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
        return !englishDisplayLanguage.equals(localizedDisplayLanguage = locale.getDisplayLanguage(locale));
    }
}

