#ifndef ISO2MB_MB_H

#define ISO2MB_MB_H

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <mbconfig.h>
#include <mbbtri.h>

#define ISO2MB_ESC_LEN_MAX (4)

enum {
  mb_G0,
  mb_G1,
  mb_G2,
  mb_G3,
  mb_Gn,
  mb_UTF8,
#undef def_mb128
#define def_mb128(mac, fcb, fce, convg0sl, encoder, decoder, cwidth) mb_ ## mac,
#include <mb128.h>
  mb_FAKEUTF8,
};

enum {
  mb_SL,
  mb_SR,
  mb_SSL,
  mb_SSR,
};

enum {
  mb_G0SL,
  mb_G1SR,
  mb_G2SSR,
  mb_G3SSR,
  mb_G1SL,
  mb_G2SSL,
  mb_G3SSL,
  mb_G2SL,
  mb_G3SL,
  mb_G2SR,
  mb_G3SR,
  mb_G0SR,
};

enum {
  mb_94x94,
  mb_96_0,
  mb_96_1,
  mb_94_0,
  mb_94_1,
  mb_94_2,
  mb_94_3,
  mb_128,
};

#define MB_ESC_SET_LEN (3)
#define MB_ESC_SET_MASK ((1 << MB_ESC_SET_LEN) - 1)
#define MB_ESC_FC_LEN (5)
#define MB_ESC_FC_MASK ((1 << MB_ESC_FC_LEN) - 1)
#define MB_ESC_LEN (MB_ESC_FC_LEN + MB_ESC_SET_LEN)
#define MB_ESC_MASK ((1 << MB_ESC_LEN) - 1)
#define MB_ESC_Gn_LEN (2)
#define MB_ESC_Gn_MASK ((1 << MB_ESC_Gn_LEN) - 1)
#define MB_ESC_Sn_LEN (2)
#define MB_ESC_Sn_MASK ((1 << MB_ESC_Sn_LEN) - 1)
#define MB_ESC_GnSn_LEN (4)
#define MB_ESC_GnSn_MASK ((1 << MB_ESC_GnSn_LEN) - 1)

#define MB_ESC_ENC(set, fc) ((((fc) & MB_ESC_FC_MASK) << MB_ESC_SET_LEN) | ((set) & MB_ESC_SET_MASK))
#define MB_ESC_DEC_SET(esc) ((esc) & MB_ESC_SET_MASK)
#define MB_ESC_DEC_FC(esc) (((esc) >> MB_ESC_SET_LEN) & MB_ESC_FC_MASK)

#define MB_WORD_LEN (14)
#define MB_WORD_MASK ((1 << MB_WORD_LEN) - 1)
#define MB_WORD_ENC(c, esc) (((esc) << MB_WORD_LEN) | ((c) & MB_WORD_MASK))

#define MB_WORD_DEC_C(c) ((c) & MB_WORD_MASK)
#define MB_WORD_DEC_ESC(c) (((c) >> MB_WORD_LEN) & MB_ESC_MASK)
#define MB_WORD_DEC_SET(c) (MB_ESC_DEC_SET(MB_WORD_DEC_ESC((c))))
#define MB_WORD_DEC_FC(c) (MB_ESC_DEC_FC(MB_WORD_DEC_ESC((c))))

#define MB_WORD_ENC_3(c, set, fc) MB_WORD_ENC((c), MB_ESC_ENC((set), (fc)))

#define MB_UTF8_BADENC(set, fc, gnsn) ((MB_ESC_ENC((set), (fc)) >> MB_ESC_SET_LEN) | ((gnsn) << MB_ESC_FC_LEN))

#define MB_BADUTF8_FC(c) ((c) & MB_ESC_FC_MASK)
#define MB_BADUTF8_GnSn(c) (((c) >> MB_ESC_FC_LEN) & MB_ESC_GnSn_MASK)
#define MB_BADUTF8_Gn(c) (((c) >> MB_ESC_FC_LEN) & MB_ESC_Gn_MASK)
#define MB_BADUTF8_Sn(c) (((c) >> (MB_ESC_FC_LEN + MB_ESC_Gn_LEN)) & MB_ESC_Sn_MASK)

#define MB_ESC_ASCII (MB_ESC_ENC(mb_94_0, 0x42))
#define MB_ESC_UTF8 (MB_ESC_ENC(mb_128, 0x47))
#define MB_ESC_UTF8END (MB_ESC_ENC(mb_128, 0x40))
#define MB_UTF8_FC (0x47)
#define MB_UNKNOWN_FC (0x5F)

enum {
#undef def_mb128
#define def_mb128(mac, fcb, fce, convg0sl, encoder, decoder, cwidth) mb_ ## mac ## _FCs = (fcb) | ((fce) << 7),
#include <mb128.h>
};

#define MB_FLAG_UTF8_CHECK (1 << 0)
#define MB_FLAG_ASCIIATCTL (1 << 1)
#define MB_FLAG_28FOR94X94G0 (1 << 2)
#define MB_FLAG_UNKNOWNCS (1 << 3)
#define MB_FLAG_NOSSL (1 << 4)
#define MB_FLAG_JISX_PREFERENCE (3 << 5)
#define MB_FLAG_DONTPREFER_JISX0213 (1 << 5)
#define MB_FLAG_PREFER_JISX0213 (2 << 5)

#define MB_IN_JISC6226 (1 << 0)
#define MB_IN_JISX0208 (1 << 1)
#define MB_IN_JISX0212 (1 << 2)
#define MB_IN_JISX0213_1 (1 << 3)
#define MB_IN_JISX0213_2 (1 << 4)
#define MB_IN_JIS1COMMON (MB_IN_JISC6226 | MB_IN_JISX0208 | MB_IN_JISX0213_1)
#define MB_IN_JIS2COMMON (MB_IN_JISX0212 | MB_IN_JISX0213_2)

#undef MB_LEN_MAX
#define MB_LEN_MAX (6)

typedef enum {
  mb_flag_plus,
  mb_flag_minus,
  mb_flag_set,
  mb_flag_noop,
} mb_flag_op_t;

typedef struct mb_char_st {
  int c;
  unsigned char set;
  unsigned char fc;
  unsigned char gn;
  unsigned char sn;
} mb_char_t;

struct mb_info_st;
typedef void (*mb_conv_t)(mb_char_t *ch, struct mb_info_st *info);
typedef int (*mb_128encoder_t)(int c, struct mb_info_st *info);
typedef size_t (*mb_128decoder_t)(int c, int fc, char *buf);
typedef size_t (*mb_128cwidth_t)(mb_char_t *ch);

#undef def_mb128
#define def_mb128(mac, fcb, fce, convg0sl, encoder, decoder, cwidth) \
extern void convg0sl(mb_char_t *ch, struct mb_info_st *info); \
extern int encoder(int c, struct mb_info_st *info); \
extern size_t decoder(int c, int fc, char *buf); \
extern size_t cwidth(mb_char_t *ch);
#include <mb128.h>

typedef struct mb_setup_st {
  mb_flag_op_t flag_op;
  int flag;
  const char *cs;
  mb_conv_t *convv;
} mb_setup_t;

struct mb_cs2esc_st;

typedef struct mb_info_st {
  int flag;
  int GL;
  int GR;
  int G[mb_Gn];
  int GRB4UTF8;
  int GLsave;
  int GRsave;
  int Gsave[mb_Gn];
  char inbuf[MB_LEN_MAX];
  size_t in_i, in_n;
  char outbuf[MB_LEN_MAX];
  size_t out_i, out_n;
  struct mb_cs2esc_st *cs2esc;
  mb_conv_t *convv;
  union {
    int (*in)(void *io_arg);
    size_t (*out)(const char *s, size_t n, void *io_arg);
  } io_func;
  void *io_arg;
} mb_info_t;

typedef struct mb_mem_r_st {
  const char *s;
  size_t i, n;
} mb_mem_r_t;

#define MB_MEM_DELTA (32)

typedef struct mb_b64opt_st {
  size_t llen;
  const char *pre;
  size_t pree;
  const char *post;
  size_t poste;
  const char *eol;
  size_t eole;
} mb_b64opt_t;

typedef struct mb_b64_st {
  mb_b64opt_t *opt;
  size_t se;
  char d[3];
  size_t dn;
  size_t (*writer)(const char *, size_t, struct mb_b64_st *);
  size_t (*orig_writer)(const char *, size_t, void *);
  void *orig_arg;
} mb_b64_t;

#define MB_MEM_BIG_DELTA (BUFSIZ)

#define MB_CS_DETECT_FLAG_MKUNBOUND (1 << 0)

#define MB_CS_DETECT_CHOICEMAX (16)

struct mb_cs_detector_stat_st;
struct mb_cs_detector_st;

typedef void (*mb_cs_judge_encoding_t)(struct mb_cs_detector_stat_st *, const char *, size_t);
typedef size_t (*mb_cs_judge_t)(struct mb_cs_detector_st *);
typedef char *(*mb_cs_setup_t)(struct mb_cs_detector_st *, size_t, size_t);

typedef struct mb_cs_detector_stat_st {
  size_t processed;
  long by_encode, by_char;
} mb_cs_detector_stat_t;

typedef struct mb_cs_detector_st {
  mb_cs_judge_t judge;
  mb_cs_setup_t setup;
  void *private;
  int flag;
  size_t nstats;
  void *(*realloc_bag)(void *, size_t);
  void (*free_bag)(void *);
  void (*free_detector)(void *);
  mb_cs_detector_stat_t stat[MB_CS_DETECT_CHOICEMAX];
  size_t samev[MB_CS_DETECT_CHOICEMAX];
  mb_info_t *orig;
  int (*orig_reader)(void *);
  void *orig_arg;
  size_t beg, end, size, limit;
  char *bag;
} mb_cs_detector_t;

typedef struct mb_cs2esc_st {
  const char *cs;
  size_t cs_len;
  mb_flag_op_t flag_op;
  int flag;
  int GL, GR;
  struct {
    int set;
    int fc;
  } G[mb_Gn];
  mb_conv_t *convv;
} mb_cs2esc_t;

typedef struct mb_conv_tab_st {
  const char *name;
  size_t len;
  mb_conv_t value;
} mb_conv_tab_t;

#define MB_KEY_DEF(key) key, sizeof(key) -1

typedef struct mb_ucswidthtab_st {
  int beg, end, width;
} mb_ucswidthtab_t;

#define MB_CPROP_IS_SPACE (1 << 0)
#define MB_CPROP_NEVER_BOL (1 << 1)
#define MB_CPROP_NEVER_EOL (1 << 2)
#define MB_CPROP_MAY_BREAK (1 << 3)
#define MB_CPROP_EOL_TO_NULL (1 << 4)

/* iso2mb.c */
extern int mb_call_getc(mb_info_t *info);
extern void mb_fill_inbuf(mb_info_t *info, const char *s, size_t n);
extern int mb_utf8_escenc(mb_info_t *info);
extern size_t mb_utf8_enc(int c, char *buf);
extern int mb_get_jis1flag(int c);
extern int mb_get_jis2flag(int c);
extern int mb_conv_jisx0213(int fc, int c, mb_info_t *info);
extern void mb_conv_allg0sl(mb_char_t *ch, mb_info_t *info);
extern int *mb_set_localized_ascii_table(int *new);
extern int *mb_set_domestic_ascii_table(int *new);
extern void mb_conv_ascii(mb_char_t *ch, mb_info_t *info);
extern size_t mb_nonutf8_enc(mb_char_t *ch, char *buf);
extern void mb_conv_for_charset(mb_char_t *ch, mb_info_t *info);
extern void mb_apply_convv(mb_char_t *ch, mb_info_t *info);
extern int mb_utf8_badenc(mb_char_t *ch, mb_info_t *info);
extern int mb_fetch_char(mb_info_t *info);
extern int mb_unfetch_char(int c, mb_info_t *info);
extern int mb_getc(mb_info_t *info);
extern size_t mb_getmbc(char *d, mb_info_t *info);
extern size_t mb_getmem(char *d, size_t n, mb_info_t *info);
extern char *mb_getline(char *d, int n, mb_info_t *info);
extern char *mb_info2mb(mb_info_t *info, size_t n);
extern void mb_vmem2mb_setup(mb_info_t *info, mb_mem_r_t *mem, const char *s, size_t n,
			     mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_vmem2mb(const char *s, size_t n, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_mem2mb(const char *s, size_t n, mb_setup_t *setup, const char *op, ...);
extern char *mb_vstr2mb(const char *s, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_str2mb(const char *s, mb_setup_t *setup, const char *op, ...);
extern void mb_cs_judge_utf8(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern void mb_cs_judge_latin1(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern void mb_mkunbound_cs_detector(mb_cs_detector_t *p);
extern size_t mb_cs_detector_find_best(mb_cs_detector_t *p, size_t *p_same);
extern void mb_bind_cs_detector(mb_cs_detector_t *p, mb_info_t *info);
extern mb_cs_detector_t *mb_alloc_cs_detector(mb_info_t *info, size_t init, size_t limit);
extern char *mb_cs_detect_from_mem(mb_cs_detector_t *p, mb_info_t *info, const char *s, size_t n);
extern char *mb_cs_detect_from_str(mb_cs_detector_t *p, mb_info_t *info, const char *s);
extern char *mb_cs_detect_vmem2mb(mb_cs_detector_t *p, const char *s, size_t n, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_cs_detect_mem2mb(mb_cs_detector_t *p, const char *s, size_t n, mb_setup_t *setup, const char *op, ...);
extern char *mb_cs_detect_vstr2mb(mb_cs_detector_t *p, const char *s, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_cs_detect_str2mb(mb_cs_detector_t *p, const char *s, mb_setup_t *setup, const char *op, ...);

/* mb2iso.c */
extern int mb_char_dec(const char *s, size_t *p_b, size_t e);
extern void mb_store_esc(mb_char_t *ch, mb_info_t *info);
extern void mb_parse_badutf8(int c, mb_char_t *ch);
extern size_t mb_store_parsed_badutf8(mb_char_t *ch, char *buf);
extern void mb_conv_to_xctext(mb_char_t *ch, mb_info_t *info);
extern void mb_store_parsedchar_noconv(mb_char_t *ch, mb_info_t *info);
extern void mb_store_parsedchar(mb_char_t *ch, mb_info_t *info);
extern size_t mb_store_char_noconv(int c, mb_info_t *info);
extern size_t mb_store_char(const char *s, size_t e, mb_info_t *info);
extern int mb_putc(int c, mb_info_t *info);
extern size_t mb_putmem(const char *s, size_t n, mb_info_t *info);
extern size_t mb_putstr(const char *s, mb_info_t *info);
extern void mb_flush(mb_info_t *info);
extern char *mb_vmem2iso(const char *s, size_t *p_n, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_mem2iso(const char *s, size_t *p_n, mb_setup_t *setup, const char *op, ...);
extern char *mb_vstr2iso(const char *s, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_str2iso(const char *s, mb_setup_t *setup, const char *op, ...);
extern int mb_vprintf(mb_info_t *info, const char *format, va_list ap);
extern int mb_printf(mb_info_t *info, const char *format, ...);
extern size_t mb_putmem_b64encode(const char *s, size_t se, mb_b64opt_t *b64opt, mb_info_t *info);
extern char *mb_vmem2b64(const char *s, size_t *p_n, const char *title, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_mem2b64(const char *s, size_t *p_n, const char *title, mb_setup_t *setup, const char *op, ...);
extern char *mb_vstr2b64(const char *s, const char *title, mb_setup_t *setup, const char *op, va_list ap);
extern char *mb_str2b64(const char *s, const char *title, mb_setup_t *setup, const char *op, ...);

/* mbinit.c */
extern void *mb_nc_bsearch(const char *key, size_t keylen, void *tab,
			   size_t key_off, size_t keylen_off,
			   size_t elem_size, size_t tab_size);
extern void mb_nc_sort(void *tab, size_t key_off, size_t keylen_off, size_t elem_size, size_t tab_size);
extern size_t mb_charset_tab_merge(mb_cs2esc_t *tab, size_t tab_end, size_t tab_size);
extern size_t mb_charset_cname_merge(mb_cs2esc_t *tab, const char **cnamev, size_t cnamec);
extern void mb_charset_to_esc(const char *cs, mb_info_t *info);
extern void mb_vsetsetup(mb_setup_t *setup, const char *op, va_list ap);
extern void mb_setsetup(mb_setup_t *setup, const char *op, ...);
extern void mb_vsetup(mb_info_t *info, mb_setup_t *dflt, const char *op, va_list ap);
extern void mb_setup(mb_info_t *info, mb_setup_t *dflt, const char *op, ...);
extern void mb_vinit(mb_info_t *info, void *arg, mb_setup_t *dflt, const char *op, va_list ap);
extern void mb_init(mb_info_t *info, void *arg, mb_setup_t *dflt, const char *op, ...);
extern void mb_vinit_r(mb_info_t *info, void *arg, int (*func)(void *), mb_setup_t *dflt, const char *op, va_list ap);
extern void mb_init_r(mb_info_t *info, void *arg, int (*func)(void *), mb_setup_t *dflt, const char *op, ...);
extern void mb_vinit_w(mb_info_t *info, void *arg, size_t (*func)(const char *, size_t, void *),
		       mb_setup_t *dflt, const char *op, va_list ap);
extern void mb_init_w(mb_info_t *info, void *arg, size_t (*func)(const char *, size_t, void *),
		      mb_setup_t *dflt, const char *op, ...);
extern size_t mb_namev_to_converterv(const char *s, mb_conv_t *v, size_t max, void (*ehook)(const char *, size_t));
extern int mb_namev_to_flag(const char *s, int flag, void (*ehook)(const char *, size_t));
extern int mb_lang_to_detector(const char *s, mb_cs_judge_t *p_judge, mb_cs_setup_t *p_setup, size_t *p_nstats);

/* mbfind.c */
extern int mb_find_char(const char *s, size_t *p_b, size_t *p_e);
extern void mb_chartype(int c, size_t n, mb_char_t *ch);
extern void mb_set_widthtable(char *term);
extern size_t mb_parsedcharlength(mb_char_t *ch);
extern size_t mb_charlength(int c, size_t n);
extern size_t mb_memlength(const char *s, size_t n);
extern size_t mb_strlength(const char *s);
extern int mb_iso_preconv(int iso, int *p_set, int *p_fc);
extern int *mb_is_ucs_cjk(int ucs);
extern int *mb_is_iso_cjk(int iso);
extern int mb_charprop(mb_char_t *ch);
extern int mb_mbc_prop(const char *s, size_t e);

/* mbio.c */
extern void mb_set_reallocator(void *(*func)(void *, size_t));
extern void mb_vfsetup(FILE *fp, const char *op, va_list ap);
extern void mb_fsetup(FILE *fp, const char *op, ...);
extern void mb_vfsetup_default(const char *op, va_list ap);
extern void mb_fsetup_default(const char *op, ...);
extern FILE *mb_vfbind(FILE *fp, const char *mode, va_list ap);
extern FILE *mb_fbind(FILE *fp, const char *mode, ...);
extern FILE *mb_vfopen(const char *fn, const char *mode, va_list ap);
extern FILE *mb_fopen(const char *fn, const char *mode, ...);
extern FILE *mb_vfreopen(const char *fn, const char *mode, FILE *fp, va_list ap);
extern FILE *mb_freopen(const char *fn, const char *mode, FILE *fp, ...);
extern FILE *mb_vfdopen(int fd, const char *mode, va_list ap);
extern FILE *mb_fdopen(int fd, const char *mode, ...);
extern int mb_fclose(FILE *fp);
extern int mb_fgetpos(FILE *fp, fpos_t *p_pos);
extern int mb_fsetpos(FILE *fp, const fpos_t *p_pos);
extern long mb_ftell(FILE *fp);
extern int mb_fseek(FILE *fp, long off, int mode);
extern size_t mb_fread(char *d, size_t n, FILE *fp);
extern size_t mb_fwrite(const char *s, size_t n, FILE *fp);
#define mb_fputcstr(cstr, strm) (mb_fwrite(cstr, sizeof(cstr) - 1, (strm)))
extern size_t mb_fputs(const char *s, FILE *fp);
extern int mb_fgetc(FILE *fp);
extern int mb_ungetc(int c, FILE *fp);
extern char *mb_fgets(char *d, size_t n, FILE *fp);
extern int mb_fputc(int c, FILE *fp);
extern int mb_vfprintf(FILE *fp, const char *format, va_list ap);
extern int mb_fprintf(FILE *fp, const char *format, ...);
extern int mb_fflush(FILE *fp);
extern size_t mb_fgetmbc(char *d, FILE *fp);
extern size_t mb_fread_fromto(char *buf, size_t n, FILE *fp, long *p_from, long to);
extern mb_cs_detector_t *mb_fbind_cs_detector(mb_cs_detector_t *p, FILE *fp);
extern mb_cs_detector_t *mb_falloc_cs_detector(FILE *fp, size_t init, size_t limit);
extern int mb_finfo(FILE *fp, mb_info_t **p_info_r, mb_info_t **p_info_w);

#endif
