/** Copyright  2003 by Jean-Hugues de Raigniac <jhraigniac@workingfrog.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.workingfrog.i18n.util;

import java.util.EventObject;
import java.util.Locale;

/**
 * Event fired when default Locale is changed.
 *
 * @author Jean-Hugues de Raigniac
 */
public class LocaleEvent extends EventObject {

    /** current Locale */
    private Locale locale = Locale.getDefault();

    /**
     * Event containing the Object which fired it.
     *
     * @param source Object firing this LocaleEvent
     */
    public LocaleEvent (Object source) {
        super(source);
    }

    /**
     * Event containing the Object which fired it and a new Locale.
     *
     * @param source Object firing this LocaleEvent
     * @param locale A new one
     */
    public LocaleEvent (Object source, Locale locale) {
        super(source);
        this.locale = locale;
    }

    /**
     * Provides the Locale tied with this LocaleEvent.
     *
     * @return The new Locale
     */
    public Locale getLocale () {
        return locale;
    }
}
