/*
 * Created on July 16 2003
 */
package org.workingfrog.i18n.test;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Locale;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import org.workingfrog.i18n.swing.I18NJButton;
import org.workingfrog.i18n.swing.I18NJFrame;
import org.workingfrog.i18n.swing.I18NJLabel;
import org.workingfrog.i18n.swing.I18NJMenu;
import org.workingfrog.i18n.swing.I18NJMenuBar;
import org.workingfrog.i18n.swing.I18NJPanel;
import org.workingfrog.i18n.swing.I18NJRadioButtonMenuItem;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.Translator;

/**
 * @author Jean-Hugues de Raigniac
 */
public class Demo extends I18NJFrame implements ActionListener {

    private HashMap item2Locale;

    public Demo () {
        this("");
    }

    public Demo (String title) {
        super(title);
        init();
    }

    private void init () {
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                exitForm(evt);
            }
        });

        I18NJPanel content = new I18NJPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(new EmptyBorder(12,12,11,11));

        initI18NBehavior();
        content.add(addLabels(), BorderLayout.CENTER);
        content.add(addButtons(), BorderLayout.SOUTH);

        getContentPane().add(content, BorderLayout.CENTER);

        // dimensions
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setSize((screenSize.width / 3) * 2, (screenSize.height / 3) * 2);

        // Center the window
        Dimension frameSize = getSize();
        setLocation((screenSize.width - frameSize.width) / 2,
            (screenSize.height - frameSize.height) / 2);
    }

    private void initI18NBehavior () {
        I18NJMenu menuItem = new I18NJMenu("misc.languages");
        I18NJMenu tools = new I18NJMenu("misc.tools");
        tools.add(menuItem);
        ButtonGroup group = new ButtonGroup();

        Locale[] locales = Translator.getLocales();
        item2Locale = new HashMap(locales.length);

        for (int j = locales.length - 1; j >= 0; j--) {
            String key = "misc.languages-"
                + locales[j].toString().toLowerCase();
            I18NJRadioButtonMenuItem item = new I18NJRadioButtonMenuItem(key);
            group.add(item);
            item2Locale.put(item, locales[j]);
            item.addActionListener(this);
            menuItem.add(item);
        }

        I18NJMenuBar menuBar = new I18NJMenuBar();
        menuBar.add(tools);
        setJMenuBar(menuBar);
    }

    private JPanel addLabels () {
        I18NJPanel panel = new I18NJPanel();
        panel.add(new I18NJLabel("misc.test-one"));
        I18NJLabel label = new I18NJLabel();
        label.setText("misc.test-two");
        panel.add(label);

        return panel;
    }

    private JPanel addButtons () {
        I18NJPanel panel = new I18NJPanel();
        panel.add(new I18NJButton("misc.button-one"));
        I18NJButton button = new I18NJButton();
        button.setText("misc.button-two");
        panel.add(button);

        return panel;
    }

    /** Exit the Application.
     * @param evt not used
     */
    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    /**
     * Fired by an I18NJMenuItem.
     * @param event Usual event of JMenuItem
     */
    public void actionPerformed(ActionEvent event) {
        Locale locale = (Locale) item2Locale.get(event.getSource());

        Translator.setLocale(locale);

        LocaleEvent e = new LocaleEvent(this, locale);
        localeChanged(e);
            
    }

	public static void main(String[] args) {
        Translator.init();
//        Demo demo = new Demo("misc.title");
        Demo demo = new Demo();
        demo.setTitle("misc.title");
        demo.show();
	}
}
