/**
 * @file libgnurdf/types.h RDF element and data types
 *
 * $Id: types.h,v 1.4 2001/08/23 08:51:22 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_TYPES_H_
#define _LIBGNURDF_TYPES_H_

#include <parser.h>

#ifdef __cplusplus
extern "C" {
#endif

/** An RDF schema. */
typedef xmlDoc RdfSchema;

/** An RDF namespace. */
typedef xmlNs RdfNamespace;

/** An RDF element. */
typedef xmlNode RdfElement;

/**
 * An RDF container.
 *
 * <RDF:Bag>, <RDF:Seq>, <RDF:Alt>
 */
typedef RdfElement RdfContainer;

/**
 * An RDF description.
 *
 * <RDF:Description>
 */
typedef RdfElement RdfDescription;

/**
 * An RDF Bag container.
 * 
 * An element with multiple childs in no particular order
 */
typedef RdfContainer RdfBag;

/**
 * An RDF Sequential container.
 * 
 * An element with a list of children in an order 
 */
typedef RdfContainer RdfSeq;

/**
 * An RDF Alternative container.
 * 
 * An element with a list of children that are basically equivalent.
 */
typedef RdfContainer RdfAlt;


/*************************************************************************/
/** @name Element types                                                  */
/*************************************************************************/
/*@{*/
#define RDF_LEAF   1           /**< A piece of text (char *) */
#define RDF_BAG    2           /**< Bag                      */
#define RDF_SEQ    3           /**< Sequence                 */
#define RDF_ALT    4           /**< Alternative              */
#define RDF_DESC   5           /**< An RDF Description       */
/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LIBGNURDF_TYPES_H_ */

