#include "cobject.h"
#include "cxml.h"

class CSerializedString : public CSerialized
{
	public :
		CString String;
	public :
		CSerializedString (const CString &inString=CString()) : String (inString)
		{
			printf ("CSerializedString instanciated %lx\n", this); 
		}
		virtual ~CSerializedString ()
		{
			printf ("CSerializedString deleted %lx\n", this); 
		}
	public :
		virtual void Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode)
		{
			CSerialized::Serialize (ioXMLElementNode, inMode);
			switch (inMode)
			{
				case XML_READ :
				{
					CString xmlNodeName ("string-value");
					CXMLElementNode *xmlElementNode (::xml_node_get_child (ioXMLElementNode, xmlNodeName));
					if (xmlElementNode != NULL) String = ::xml_node_get_value (xmlElementNode);
					printf ("  CSerializedString : loaded value = %s\n", String.Get());
				}
				break;
				case XML_WRITE :
				{
					CString xmlNodeName ("string-value");
					new CXMLElement (ioXMLElementNode, xmlNodeName, String);
				}
				break;
			}
		}
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('szsr', CSerializedString, CSerialized);
RESOLVE_DYNAMIC_METACLASS (CSerializedString);

class CMyObjectListener : public CObjectListener 
{
	public :
		CMyObjectListener ()
		{
			printf ("  CMyObjectListener instanciated %lx\n", this); 
		}
		virtual ~CMyObjectListener ()
		{
			printf ("  CMyObjectListener deleted %lx\n", this);
		}
	public :
		virtual void OnConstruct (CObject *inSender) 
		{
			printf ("  Listener call : CMyObjectListener::OnConstruct %lx\n", inSender); 
		}
		virtual void OnDestruct (CObject *inSender) 
		{
			printf ("  Listener call : CMyObjectListener::OnDestruct %lx\n", inSender); 
		}
	public :
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_mbj', CMyObjectListener, CObjectListener);
RESOLVE_DYNAMIC_METACLASS (CMyObjectListener);

class CMyObject : public CObject
{
	public :
		CMyObject (const CMyObjectListener *inListener=NULL) : CObject (inListener)
		{ 
			printf ("CMyObject instanciated %lx\n", this); 
		}
		virtual ~CMyObject ()
		{
			printf ("CMyObject deleted %lx\n", this);
		}
	public :
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('mobj', CMyObject, CObject);
RESOLVE_DYNAMIC_METACLASS (CMyObject);

int main ()
{
	if (!CFile::Exists (CString("./demo-mixed.xml")))
        {
                CMyObject 	  obj1 (new CMyObjectListener());
		CSerializedString str1 (CString("GRemi"));
                CMyObject	  obj2;
                CMyObject	  obj3 (new CMyObjectListener());
		CSerializedString str2 (CString("Lili"));

                CXMLDocument XMLDocument (CString("./demo-mixed.xml"), XML_WRITE, CString("demo"));

                XMLDocument << obj1;
                XMLDocument << str1;
                XMLDocument << obj2;
                XMLDocument << obj3;
                XMLDocument << str2;
        }
        else
        {
                CXMLDocument XMLDocument (CString("./demo-mixed.xml"), XML_READ, CString("demo"));
                CXMLElementNode *inRoot = XMLDocument.GetRootElement ();

		printf ("=> xml doc read in, instanciation section :\n\n");

		NServices::TBuffer <CSerialized *> buf;

		for (size_t i=0; i<xml_node_get_children_number(inRoot); i++)
		{
	                CSerialized *szd = CSerialized::Instanciate (::xml_node_get_child (inRoot,i));

			if (szd != NULL) { buf += szd; printf ("\n"); }
		}

		printf ("=> free section :\n\n");

		for (size_t i=0; i<buf.GetLength(); i++) { delete *buf[i]; printf ("\n"); }

                delete inRoot;
        }

	return 0;
}
