/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 28 "./parse.y"

#include "sqliteInt.h"
#include "parse.h"

#line 13 "./parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    sqliteParserKRARGDECL     A version of sqliteParserARGDECL for K&R C.
**    sqliteParserANSIARGDECL   A version of sqliteParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 143
#define YYACTIONTYPE int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  IdList* yy126;
  Expr* yy130;
  int yy136;
  ExprList* yy168;
  Token yy182;
  Select* yy207;
  int yy285;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARGDECL ,pParse
#define sqliteParserXARGDECL Parse *pParse;
#define sqliteParserANSIARGDECL ,Parse *pParse
#define YYNSTATE 336
#define YYNRULE 195
#define YYERRORSYMBOL 101
#define YYERRSYMDT yy285
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  65,  27, 0                    }, /*               ROLLBACK shift  27 */
  {  97,  29, &yyActionTable[   0] }, /*           create_table shift  29 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  { 100, 335, 0                    }, /*                   ecmd shift  335 */
  {  81, 267, &yyActionTable[   7] }, /*                 UPDATE shift  267 */
  { 102,   4, &yyActionTable[   2] }, /*                explain shift  4 */
  {  17, 307, 0                    }, /*                   COPY shift  307 */
  {  25, 257, 0                    }, /*                   DROP shift  257 */
  {  26,  25, 0                    }, /*                    END shift  25 */
  {  63, 316, 0                    }, /*                 PRAGMA shift  316 */
  {  43, 279, 0                    }, /*                 INSERT shift  279 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  23, 0                    }, /*                 COMMIT shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 113, 532, &yyActionTable[   5] }, /*                  input accept */
  {  18, 243, 0                    }, /*                 CREATE shift  243 */
  {  83, 314, 0                    }, /*                 VACUUM shift  314 */
  {  20, 263, 0                    }, /*                 DELETE shift  263 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 121,  59, &yyActionTable[   8] }, /*              oneselect shift  59 */
  {  90, 333, &yyActionTable[   9] }, /*                    cmd shift  333 */
  {  91,   1, 0                    }, /*                cmdlist shift  1 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  30, 334, 0                    }, /*                EXPLAIN shift  334 */
  { 127, 262, &yyActionTable[  10] }, /*                 select shift  262 */
/* State 1 */
  {  68,   2, &yyActionTable[  33] }, /*                   SEMI shift  2 */
  {   0, 336, 0                    }, /*                      $ reduce 0 */
/* State 2 */
  {  65,  27, 0                    }, /*               ROLLBACK shift  27 */
  {  97,  29, &yyActionTable[  34] }, /*           create_table shift  29 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  { 100,   3, 0                    }, /*                   ecmd shift  3 */
  {  17, 307, 0                    }, /*                   COPY shift  307 */
  { 102,   4, &yyActionTable[  36] }, /*                explain shift  4 */
  {  25, 257, 0                    }, /*                   DROP shift  257 */
  {  26,  25, 0                    }, /*                    END shift  25 */
  {  63, 316, 0                    }, /*                 PRAGMA shift  316 */
  {YYNOCODE,0,0}, /* Unused */
  {  43, 279, 0                    }, /*                 INSERT shift  279 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  23, 0                    }, /*                 COMMIT shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81, 267, &yyActionTable[  39] }, /*                 UPDATE shift  267 */
  {  18, 243, 0                    }, /*                 CREATE shift  243 */
  {  83, 314, 0                    }, /*                 VACUUM shift  314 */
  {  20, 263, 0                    }, /*                 DELETE shift  263 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 121,  59, &yyActionTable[  41] }, /*              oneselect shift  59 */
  {  90, 333, &yyActionTable[  42] }, /*                    cmd shift  333 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  30, 334, 0                    }, /*                EXPLAIN shift  334 */
  { 127, 262, &yyActionTable[  43] }, /*                 select shift  262 */
/* State 3 */
  {YYNOCODE,0,0}, /* Unused */
/* State 4 */
  {  65,  27, 0                    }, /*               ROLLBACK shift  27 */
  {  97,  29, &yyActionTable[  67] }, /*           create_table shift  29 */
  {  17, 307, 0                    }, /*                   COPY shift  307 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  {  25, 257, 0                    }, /*                   DROP shift  257 */
  {  26,  25, 0                    }, /*                    END shift  25 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {  63, 316, 0                    }, /*                 PRAGMA shift  316 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  43, 279, 0                    }, /*                 INSERT shift  279 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  23, 0                    }, /*                 COMMIT shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81, 267, &yyActionTable[  69] }, /*                 UPDATE shift  267 */
  {  18, 243, 0                    }, /*                 CREATE shift  243 */
  {  83, 314, 0                    }, /*                 VACUUM shift  314 */
  {  20, 263, 0                    }, /*                 DELETE shift  263 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 121,  59, &yyActionTable[  71] }, /*              oneselect shift  59 */
  {  90,   5, &yyActionTable[  72] }, /*                    cmd shift  5 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 127, 262, &yyActionTable[  74] }, /*                 select shift  262 */
/* State 5 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {  76,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 137,   7, 0                    }, /*              trans_opt shift  7 */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[ 103] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[ 104] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[ 105] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110,   9, &yyActionTable[ 107] }, /*                    ids shift  9 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 9 */
  {YYNOCODE,0,0}, /* Unused */
/* State 10 */
  {YYNOCODE,0,0}, /* Unused */
/* State 11 */
  {YYNOCODE,0,0}, /* Unused */
/* State 12 */
  {YYNOCODE,0,0}, /* Unused */
/* State 13 */
  {YYNOCODE,0,0}, /* Unused */
/* State 14 */
  {YYNOCODE,0,0}, /* Unused */
/* State 15 */
  {YYNOCODE,0,0}, /* Unused */
/* State 16 */
  {YYNOCODE,0,0}, /* Unused */
/* State 17 */
  {YYNOCODE,0,0}, /* Unused */
/* State 18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 20 */
  {YYNOCODE,0,0}, /* Unused */
/* State 21 */
  {YYNOCODE,0,0}, /* Unused */
/* State 22 */
  {YYNOCODE,0,0}, /* Unused */
/* State 23 */
  {  76,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 137,  24, 0                    }, /*              trans_opt shift  24 */
/* State 24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 25 */
  {  76,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 137,  26, 0                    }, /*              trans_opt shift  26 */
/* State 26 */
  {YYNOCODE,0,0}, /* Unused */
/* State 27 */
  {  76,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 137,  28, 0                    }, /*              trans_opt shift  28 */
/* State 28 */
  {YYNOCODE,0,0}, /* Unused */
/* State 29 */
  {  98,  30, &yyActionTable[ 143] }, /*      create_table_args shift  30 */
  {  52,  31, 0                    }, /*                     LP shift  31 */
/* State 30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 31 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 219, 0                    }, /*                    ids shift  219 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  92, 242, 0                    }, /*                 column shift  242 */
  {  93,  37, 0                    }, /*               columnid shift  37 */
  {  94,  32, &yyActionTable[ 145] }, /*             columnlist shift  32 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 32 */
  {  96,  33, &yyActionTable[ 178] }, /*           conslist_opt shift  33 */
  {  12,  35, 0                    }, /*                  COMMA shift  35 */
  {  66, 398, 0                    }, /*                     RP reduce 62 */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  {  66,  34, 0                    }, /*                     RP shift  34 */
/* State 34 */
  {YYNOCODE,0,0}, /* Unused */
/* State 35 */
  {  64, 225, 0                    }, /*                PRIMARY shift  225 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {   9, 238, 0                    }, /*                  CHECK shift  238 */
  {  16, 223, 0                    }, /*             CONSTRAINT shift  223 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 135, 241, &yyActionTable[ 184] }, /*                  tcons shift  241 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, &yyActionTable[ 185] }, /*                 STRING shift  22 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 219, 0                    }, /*                    ids shift  219 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 234, &yyActionTable[ 186] }, /*                 UNIQUE shift  234 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  92,  36, 0                    }, /*                 column shift  36 */
  {  93,  37, 0                    }, /*               columnid shift  37 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  95, 220, &yyActionTable[ 187] }, /*               conslist shift  220 */
/* State 36 */
  {YYNOCODE,0,0}, /* Unused */
/* State 37 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  26,  16, &yyActionTable[ 220] }, /*                    END shift  16 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[ 216] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[ 217] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  { 138,  38, &yyActionTable[ 218] }, /*                   type shift  38 */
  { 139, 205, &yyActionTable[ 224] }, /*               typename shift  205 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 218, &yyActionTable[ 228] }, /*                    ids shift  218 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 38 */
  {  88,  39, 0                    }, /*               carglist shift  39 */
/* State 39 */
  {  80,  51, &yyActionTable[ 235] }, /*                 UNIQUE shift  51 */
  {  89, 192, &yyActionTable[ 237] }, /*                  ccons shift  192 */
  {  64,  46, &yyActionTable[ 238] }, /*                PRIMARY shift  46 */
  {  19, 193, 0                    }, /*                DEFAULT shift  193 */
  {   9,  52, 0                    }, /*                  CHECK shift  52 */
  {  56,  44, &yyActionTable[ 239] }, /*                    NOT shift  44 */
  {  16,  41, 0                    }, /*             CONSTRAINT shift  41 */
  {  87,  40, 0                    }, /*                   carg shift  40 */
/* State 40 */
  {YYNOCODE,0,0}, /* Unused */
/* State 41 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[ 242] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[ 243] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[ 244] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110,  42, &yyActionTable[ 246] }, /*                    ids shift  42 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 42 */
  {  80,  51, &yyActionTable[ 260] }, /*                 UNIQUE shift  51 */
  {  89,  43, &yyActionTable[ 261] }, /*                  ccons shift  43 */
  {  64,  46, &yyActionTable[ 262] }, /*                PRIMARY shift  46 */
  {   9,  52, 0                    }, /*                  CHECK shift  52 */
  {  56,  44, 0                    }, /*                    NOT shift  44 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 43 */
  {YYNOCODE,0,0}, /* Unused */
/* State 44 */
  {  58,  45, 0                    }, /*                   NULL shift  45 */
/* State 45 */
  {YYNOCODE,0,0}, /* Unused */
/* State 46 */
  {  49,  47, 0                    }, /*                    KEY shift  47 */
/* State 47 */
  {   5,  49, 0                    }, /*                    ASC shift  49 */
  { 133,  48, &yyActionTable[ 270] }, /*              sortorder shift  48 */
  {  22,  50, 0                    }, /*                   DESC shift  50 */
  {YYNOCODE,0,0}, /* Unused */
/* State 48 */
  {YYNOCODE,0,0}, /* Unused */
/* State 49 */
  {YYNOCODE,0,0}, /* Unused */
/* State 50 */
  {YYNOCODE,0,0}, /* Unused */
/* State 51 */
  {YYNOCODE,0,0}, /* Unused */
/* State 52 */
  {  52,  53, 0                    }, /*                     LP shift  53 */
/* State 53 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 190, &yyActionTable[ 279] }, /*                   expr shift  190 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 280] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 281] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 282] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 283] }, /*                 PRAGMA shift  17 */
/* State 54 */
  {  52,  55, 0                    }, /*                     LP shift  55 */
/* State 55 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  72, 188, 0                    }, /*                   STAR shift  188 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 133, &yyActionTable[ 312] }, /*                   expr shift  133 */
  { 104, 144, &yyActionTable[ 313] }, /*               expritem shift  144 */
  { 105, 186, &yyActionTable[ 314] }, /*               exprlist shift  186 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 315] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 316] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 327] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 328] }, /*                 PRAGMA shift  17 */
/* State 56 */
  {  64, 467, &yyActionTable[ 345] }, /*                PRIMARY reduce 131 */
  {   0, 467, 0                    }, /*                      $ reduce 131 */
  {  66, 467, 0                    }, /*                     RP reduce 131 */
  {   3, 467, 0                    }, /*                    AND reduce 131 */
  {  68, 467, &yyActionTable[ 357] }, /*                   SEMI reduce 131 */
  {   5, 467, 0                    }, /*                    ASC reduce 131 */
  {  70, 467, &yyActionTable[ 358] }, /*                  SLASH reduce 131 */
  {   7, 467, 0                    }, /*                BETWEEN reduce 131 */
  {  72, 467, 0                    }, /*                   STAR reduce 131 */
  {  73, 467, &yyActionTable[ 361] }, /*                 STRING reduce 131 */
  {  10, 467, 0                    }, /*                CLUSTER reduce 131 */
  {  75, 467, 0                    }, /*                   TEMP reduce 131 */
  {  12, 467, 0                    }, /*                  COMMA reduce 131 */
  {   4, 467, 0                    }, /*                     AS reduce 131 */
  {   6, 467, 0                    }, /*                  BEGIN reduce 131 */
  {  79, 467, &yyActionTable[ 362] }, /*                  UNION reduce 131 */
  {  80, 467, &yyActionTable[ 364] }, /*                 UNIQUE reduce 131 */
  {   9, 467, 0                    }, /*                  CHECK reduce 131 */
  {  15, 467, 0                    }, /*                 CONCAT reduce 131 */
  {  83, 467, 0                    }, /*                 VACUUM reduce 131 */
  {  16, 467, 0                    }, /*             CONSTRAINT reduce 131 */
  {  85, 467, &yyActionTable[ 367] }, /*                  WHERE reduce 131 */
  {  22, 467, 0                    }, /*                   DESC reduce 131 */
  {  21, 467, 0                    }, /*             DELIMITERS reduce 131 */
  {  24, 370, 0                    }, /*                    DOT reduce 34 */
  {YYNOCODE,0,0}, /* Unused */
  {  26, 467, 0                    }, /*                    END reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  28, 467, 0                    }, /*                     EQ reduce 131 */
  {  29, 467, 0                    }, /*                 EXCEPT reduce 131 */
  {  30, 467, 0                    }, /*                EXPLAIN reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  32, 467, 0                    }, /*                   FROM reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  34, 467, 0                    }, /*                     GE reduce 131 */
  {  35, 467, 0                    }, /*                   GLOB reduce 131 */
  {  36, 467, 0                    }, /*                  GROUP reduce 131 */
  {  37, 467, 0                    }, /*                     GT reduce 131 */
  {  38, 467, 0                    }, /*                 HAVING reduce 131 */
  {  39, 467, 0                    }, /*                     ID reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  41, 467, 0                    }, /*                     IN reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 467, 0                    }, /*              INTERSECT reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 467, 0                    }, /*                     IS reduce 131 */
  {  48, 467, 0                    }, /*                 ISNULL reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 467, 0                    }, /*                     LE reduce 131 */
  {  51, 467, 0                    }, /*                   LIKE reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 467, 0                    }, /*                     LT reduce 131 */
  {  54, 467, 0                    }, /*                  MINUS reduce 131 */
  {  55, 467, 0                    }, /*                     NE reduce 131 */
  {  56, 467, 0                    }, /*                    NOT reduce 131 */
  {  57, 467, 0                    }, /*                NOTNULL reduce 131 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60, 467, 0                    }, /*                     OR reduce 131 */
  {  61, 467, 0                    }, /*                  ORDER reduce 131 */
  {  62, 467, 0                    }, /*                   PLUS reduce 131 */
  {  63, 467, 0                    }, /*                 PRAGMA reduce 131 */
/* State 57 */
  {  64, 471, &yyActionTable[ 409] }, /*                PRIMARY reduce 135 */
  {   0, 471, 0                    }, /*                      $ reduce 135 */
  {  66, 471, 0                    }, /*                     RP reduce 135 */
  {   3, 471, 0                    }, /*                    AND reduce 135 */
  {  68, 471, &yyActionTable[ 421] }, /*                   SEMI reduce 135 */
  {   5, 471, 0                    }, /*                    ASC reduce 135 */
  {  70, 471, &yyActionTable[ 422] }, /*                  SLASH reduce 135 */
  {   7, 471, 0                    }, /*                BETWEEN reduce 135 */
  {  72, 471, 0                    }, /*                   STAR reduce 135 */
  {  73, 471, &yyActionTable[ 425] }, /*                 STRING reduce 135 */
  {  10, 471, 0                    }, /*                CLUSTER reduce 135 */
  {  75, 471, 0                    }, /*                   TEMP reduce 135 */
  {  12, 471, 0                    }, /*                  COMMA reduce 135 */
  {   4, 471, 0                    }, /*                     AS reduce 135 */
  {   6, 471, 0                    }, /*                  BEGIN reduce 135 */
  {  79, 471, &yyActionTable[ 426] }, /*                  UNION reduce 135 */
  {  80, 471, &yyActionTable[ 428] }, /*                 UNIQUE reduce 135 */
  {   9, 471, 0                    }, /*                  CHECK reduce 135 */
  {  15, 471, 0                    }, /*                 CONCAT reduce 135 */
  {  83, 471, 0                    }, /*                 VACUUM reduce 135 */
  {  16, 471, 0                    }, /*             CONSTRAINT reduce 135 */
  {  85, 471, &yyActionTable[ 431] }, /*                  WHERE reduce 135 */
  {  22, 471, 0                    }, /*                   DESC reduce 135 */
  {  21, 471, 0                    }, /*             DELIMITERS reduce 135 */
  {  24, 371, 0                    }, /*                    DOT reduce 35 */
  {YYNOCODE,0,0}, /* Unused */
  {  26, 471, 0                    }, /*                    END reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  28, 471, 0                    }, /*                     EQ reduce 135 */
  {  29, 471, 0                    }, /*                 EXCEPT reduce 135 */
  {  30, 471, 0                    }, /*                EXPLAIN reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  32, 471, 0                    }, /*                   FROM reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  34, 471, 0                    }, /*                     GE reduce 135 */
  {  35, 471, 0                    }, /*                   GLOB reduce 135 */
  {  36, 471, 0                    }, /*                  GROUP reduce 135 */
  {  37, 471, 0                    }, /*                     GT reduce 135 */
  {  38, 471, 0                    }, /*                 HAVING reduce 135 */
  {  39, 471, 0                    }, /*                     ID reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  41, 471, 0                    }, /*                     IN reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 471, 0                    }, /*              INTERSECT reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 471, 0                    }, /*                     IS reduce 135 */
  {  48, 471, 0                    }, /*                 ISNULL reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 471, 0                    }, /*                     LE reduce 135 */
  {  51, 471, 0                    }, /*                   LIKE reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 471, 0                    }, /*                     LT reduce 135 */
  {  54, 471, 0                    }, /*                  MINUS reduce 135 */
  {  55, 471, 0                    }, /*                     NE reduce 135 */
  {  56, 471, 0                    }, /*                    NOT reduce 135 */
  {  57, 471, 0                    }, /*                NOTNULL reduce 135 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60, 471, 0                    }, /*                     OR reduce 135 */
  {  61, 471, 0                    }, /*                  ORDER reduce 135 */
  {  62, 471, 0                    }, /*                   PLUS reduce 135 */
  {  63, 471, 0                    }, /*                 PRAGMA reduce 135 */
/* State 58 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 184, &yyActionTable[ 472] }, /*                   expr shift  184 */
  {  63,  17, &yyActionTable[ 487] }, /*                 PRAGMA shift  17 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 473] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  { 121,  59, 0                    }, /*              oneselect shift  59 */
  {  58,  79, &yyActionTable[ 474] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 476] }, /*                   PLUS shift  138 */
  { 127,  60, &yyActionTable[ 480] }, /*                 select shift  60 */
/* State 59 */
  {YYNOCODE,0,0}, /* Unused */
/* State 60 */
  {  29, 131, 0                    }, /*                 EXCEPT shift  131 */
  {YYNOCODE,0,0}, /* Unused */
  {  66, 183, 0                    }, /*                     RP shift  183 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 130, &yyActionTable[ 505] }, /*              INTERSECT shift  130 */
  { 118,  61, 0                    }, /*                 joinop shift  61 */
  {  79, 128, 0                    }, /*                  UNION shift  128 */
/* State 61 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  { 121,  62, &yyActionTable[ 513] }, /*              oneselect shift  62 */
/* State 62 */
  {YYNOCODE,0,0}, /* Unused */
/* State 63 */
  {  23, 181, 0                    }, /*               DISTINCT shift  181 */
  {YYNOCODE,0,0}, /* Unused */
  {   2, 182, 0                    }, /*                    ALL shift  182 */
  {  99,  64, &yyActionTable[ 516] }, /*               distinct shift  64 */
/* State 64 */
  {  72, 176, 0                    }, /*                   STAR shift  176 */
  { 125, 177, 0                    }, /*                   sclp shift  177 */
  { 126,  65, 0                    }, /*             selcollist shift  65 */
  {YYNOCODE,0,0}, /* Unused */
/* State 65 */
  {  32, 168, &yyActionTable[ 525] }, /*                   FROM shift  168 */
  {  12, 167, 0                    }, /*                  COMMA shift  167 */
  { 106,  66, 0                    }, /*                   from shift  66 */
  {YYNOCODE,0,0}, /* Unused */
/* State 66 */
  {  85, 165, 0                    }, /*                  WHERE shift  165 */
  { 141,  67, &yyActionTable[ 528] }, /*              where_opt shift  67 */
/* State 67 */
  {  36, 162, 0                    }, /*                  GROUP shift  162 */
  { 107,  68, 0                    }, /*            groupby_opt shift  68 */
/* State 68 */
  { 108,  69, &yyActionTable[ 533] }, /*             having_opt shift  69 */
  {  38, 160, 0                    }, /*                 HAVING shift  160 */
/* State 69 */
  { 122,  70, 0                    }, /*            orderby_opt shift  70 */
  {  61,  71, 0                    }, /*                  ORDER shift  71 */
/* State 70 */
  {YYNOCODE,0,0}, /* Unused */
/* State 71 */
  {   8,  72, 0                    }, /*                     BY shift  72 */
/* State 72 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  { 131, 158, 0                    }, /*               sortitem shift  158 */
  { 132,  73, 0                    }, /*               sortlist shift  73 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  77, &yyActionTable[ 538] }, /*                   expr shift  77 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 539] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 540] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 546] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 553] }, /*                 PRAGMA shift  17 */
/* State 73 */
  {  12,  74, 0                    }, /*                  COMMA shift  74 */
/* State 74 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  { 131,  75, 0                    }, /*               sortitem shift  75 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  77, &yyActionTable[ 571] }, /*                   expr shift  77 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 572] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 573] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 575] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 579] }, /*                 PRAGMA shift  17 */
/* State 75 */
  {   5,  49, 0                    }, /*                    ASC shift  49 */
  { 133,  76, &yyActionTable[ 603] }, /*              sortorder shift  76 */
  {  22,  50, 0                    }, /*                   DESC shift  50 */
  {YYNOCODE,0,0}, /* Unused */
/* State 76 */
  {YYNOCODE,0,0}, /* Unused */
/* State 77 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[ 608] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[ 609] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[ 612] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 78 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  85, &yyActionTable[ 640] }, /*                   expr shift  85 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 641] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 642] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 643] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 644] }, /*                 PRAGMA shift  17 */
/* State 79 */
  {YYNOCODE,0,0}, /* Unused */
/* State 80 */
  {  24,  81, 0                    }, /*                    DOT shift  81 */
/* State 81 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[ 674] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[ 675] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[ 676] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110,  82, &yyActionTable[ 678] }, /*                    ids shift  82 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 82 */
  {YYNOCODE,0,0}, /* Unused */
/* State 83 */
  {YYNOCODE,0,0}, /* Unused */
/* State 84 */
  {YYNOCODE,0,0}, /* Unused */
/* State 85 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[ 693] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 86 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  87, &yyActionTable[ 725] }, /*                   expr shift  87 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 726] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 727] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 728] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 729] }, /*                 PRAGMA shift  17 */
/* State 87 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[ 757] }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[ 758] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 88 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  89, &yyActionTable[ 789] }, /*                   expr shift  89 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 790] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 791] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 792] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 793] }, /*                 PRAGMA shift  17 */
/* State 89 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  62, 107, &yyActionTable[ 823] }, /*                   PLUS shift  107 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, &yyActionTable[ 822] }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 90 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  91, &yyActionTable[ 829] }, /*                   expr shift  91 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 830] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 831] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 832] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 833] }, /*                 PRAGMA shift  17 */
/* State 91 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  62, 107, &yyActionTable[ 863] }, /*                   PLUS shift  107 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, &yyActionTable[ 862] }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 92 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  93, &yyActionTable[ 869] }, /*                   expr shift  93 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 870] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 871] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 872] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 873] }, /*                 PRAGMA shift  17 */
/* State 93 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  62, 107, &yyActionTable[ 903] }, /*                   PLUS shift  107 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, &yyActionTable[ 902] }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 94 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  95, &yyActionTable[ 909] }, /*                   expr shift  95 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 910] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 911] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 912] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 913] }, /*                 PRAGMA shift  17 */
/* State 95 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  62, 107, &yyActionTable[ 943] }, /*                   PLUS shift  107 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, &yyActionTable[ 942] }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 96 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  97, &yyActionTable[ 949] }, /*                   expr shift  97 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 950] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 951] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[ 952] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[ 953] }, /*                 PRAGMA shift  17 */
/* State 97 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  50,  92, &yyActionTable[ 981] }, /*                     LE shift  92 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, &yyActionTable[ 982] }, /*                     LT shift  88 */
  {  70, 113, &yyActionTable[ 984] }, /*                  SLASH shift  113 */
  {YYNOCODE,0,0}, /* Unused */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 98 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103,  99, &yyActionTable[ 997] }, /*                   expr shift  99 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[ 998] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[ 999] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1000] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1001] }, /*                 PRAGMA shift  17 */
/* State 99 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  50,  92, &yyActionTable[1029] }, /*                     LE shift  92 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, &yyActionTable[1030] }, /*                     LT shift  88 */
  {  70, 113, &yyActionTable[1032] }, /*                  SLASH shift  113 */
  {YYNOCODE,0,0}, /* Unused */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 100 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 101, &yyActionTable[1045] }, /*                   expr shift  101 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1046] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1047] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1048] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1049] }, /*                 PRAGMA shift  17 */
/* State 101 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  50,  92, &yyActionTable[1077] }, /*                     LE shift  92 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, &yyActionTable[1078] }, /*                     LT shift  88 */
  {  70, 113, &yyActionTable[1080] }, /*                  SLASH shift  113 */
  {YYNOCODE,0,0}, /* Unused */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 102 */
  {  35, 145, 0                    }, /*                   GLOB shift  145 */
  {  41, 152, 0                    }, /*                     IN shift  152 */
  {  58, 147, 0                    }, /*                   NULL shift  147 */
  {  51, 103, &yyActionTable[1093] }, /*                   LIKE shift  103 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   7, 148, 0                    }, /*                BETWEEN shift  148 */
/* State 103 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 104, &yyActionTable[1101] }, /*                   expr shift  104 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1102] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1103] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1104] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1105] }, /*                 PRAGMA shift  17 */
/* State 104 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1133] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 105 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 106, &yyActionTable[1165] }, /*                   expr shift  106 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1166] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1167] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1168] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1169] }, /*                 PRAGMA shift  17 */
/* State 106 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  50,  92, &yyActionTable[1197] }, /*                     LE shift  92 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, &yyActionTable[1198] }, /*                     LT shift  88 */
  {  70, 113, &yyActionTable[1200] }, /*                  SLASH shift  113 */
  {YYNOCODE,0,0}, /* Unused */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 107 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 108, &yyActionTable[1213] }, /*                   expr shift  108 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1214] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1215] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1216] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1217] }, /*                 PRAGMA shift  17 */
/* State 108 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 109 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 110, &yyActionTable[1249] }, /*                   expr shift  110 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1250] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1251] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1252] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1253] }, /*                 PRAGMA shift  17 */
/* State 110 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 111 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 112, &yyActionTable[1285] }, /*                   expr shift  112 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1286] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1287] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1288] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1289] }, /*                 PRAGMA shift  17 */
/* State 112 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 113 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 114, &yyActionTable[1318] }, /*                   expr shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1319] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1320] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1321] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1322] }, /*                 PRAGMA shift  17 */
/* State 114 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
/* State 115 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 116, &yyActionTable[1351] }, /*                   expr shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1352] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1353] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1354] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1355] }, /*                 PRAGMA shift  17 */
/* State 116 */
  {YYNOCODE,0,0}, /* Unused */
/* State 117 */
  {YYNOCODE,0,0}, /* Unused */
/* State 118 */
  {  58, 119, 0                    }, /*                   NULL shift  119 */
/* State 119 */
  {YYNOCODE,0,0}, /* Unused */
/* State 120 */
  {YYNOCODE,0,0}, /* Unused */
/* State 121 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 122, &yyActionTable[1388] }, /*                   expr shift  122 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1389] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1390] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1391] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1392] }, /*                 PRAGMA shift  17 */
/* State 122 */
  {   3, 123, 0                    }, /*                    AND shift  123 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[1420] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1421] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[1424] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 123 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 124, &yyActionTable[1452] }, /*                   expr shift  124 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1453] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1454] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1455] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1456] }, /*                 PRAGMA shift  17 */
/* State 124 */
  {  64, 499, &yyActionTable[1485] }, /*                PRIMARY reduce 163 */
  {   0, 499, 0                    }, /*                      $ reduce 163 */
  {  66, 499, 0                    }, /*                     RP reduce 163 */
  {   3, 499, &yyActionTable[1497] }, /*                    AND reduce 163 */
  {  68, 499, &yyActionTable[1498] }, /*                   SEMI reduce 163 */
  {   5, 499, 0                    }, /*                    ASC reduce 163 */
  {  70, 113, &yyActionTable[1501] }, /*                  SLASH shift  113 */
  {   7, 499, 0                    }, /*                BETWEEN reduce 163 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  73, 499, &yyActionTable[1502] }, /*                 STRING reduce 163 */
  {  10, 499, 0                    }, /*                CLUSTER reduce 163 */
  {  75, 499, 0                    }, /*                   TEMP reduce 163 */
  {  12, 499, 0                    }, /*                  COMMA reduce 163 */
  {   3, 474, 0                    }, /*                    AND reduce 138 */
  {   4, 499, 0                    }, /*                     AS reduce 163 */
  {  79, 499, &yyActionTable[1504] }, /*                  UNION reduce 163 */
  {  80, 499, &yyActionTable[1507] }, /*                 UNIQUE reduce 163 */
  {   6, 499, 0                    }, /*                  BEGIN reduce 163 */
  {   9, 499, 0                    }, /*                  CHECK reduce 163 */
  {  83, 499, 0                    }, /*                 VACUUM reduce 163 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  85, 499, &yyActionTable[1508] }, /*                  WHERE reduce 163 */
  {  22, 499, 0                    }, /*                   DESC reduce 163 */
  {  16, 499, 0                    }, /*             CONSTRAINT reduce 163 */
  {  21, 499, 0                    }, /*             DELIMITERS reduce 163 */
  {  60, 474, 0                    }, /*                     OR reduce 138 */
  {  26, 499, 0                    }, /*                    END reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  28, 499, 0                    }, /*                     EQ reduce 163 */
  {  29, 499, 0                    }, /*                 EXCEPT reduce 163 */
  {  30, 499, 0                    }, /*                EXPLAIN reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  32, 499, 0                    }, /*                   FROM reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 499, 0                    }, /*                   GLOB reduce 163 */
  {  36, 499, 0                    }, /*                  GROUP reduce 163 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  38, 499, 0                    }, /*                 HAVING reduce 163 */
  {  39, 499, 0                    }, /*                     ID reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  41, 499, 0                    }, /*                     IN reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 499, 0                    }, /*              INTERSECT reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 499, 0                    }, /*                     IS reduce 163 */
  {  48, 499, 0                    }, /*                 ISNULL reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 499, 0                    }, /*                   LIKE reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55, 499, 0                    }, /*                     NE reduce 163 */
  {  56, 499, 0                    }, /*                    NOT reduce 163 */
  {  57, 499, 0                    }, /*                NOTNULL reduce 163 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60, 499, &yyActionTable[1509] }, /*                     OR reduce 163 */
  {  61, 499, 0                    }, /*                  ORDER reduce 163 */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  63, 499, 0                    }, /*                 PRAGMA reduce 163 */
/* State 125 */
  {  52, 126, 0                    }, /*                     LP shift  126 */
/* State 126 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 133, &yyActionTable[1549] }, /*                   expr shift  133 */
  { 104, 144, 0                    }, /*               expritem shift  144 */
  { 105, 140, &yyActionTable[1550] }, /*               exprlist shift  140 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  63,  17, &yyActionTable[1566] }, /*                 PRAGMA shift  17 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1551] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  { 121,  59, 0                    }, /*              oneselect shift  59 */
  {  58,  79, &yyActionTable[1553] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1564] }, /*                   PLUS shift  138 */
  { 127, 127, &yyActionTable[1565] }, /*                 select shift  127 */
/* State 127 */
  {  29, 131, 0                    }, /*                 EXCEPT shift  131 */
  {YYNOCODE,0,0}, /* Unused */
  {  66, 132, 0                    }, /*                     RP shift  132 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 130, &yyActionTable[1581] }, /*              INTERSECT shift  130 */
  { 118,  61, 0                    }, /*                 joinop shift  61 */
  {  79, 128, 0                    }, /*                  UNION shift  128 */
/* State 128 */
  {   2, 129, 0                    }, /*                    ALL shift  129 */
  {  67, 411, 0                    }, /*                 SELECT reduce 75 */
/* State 129 */
  {  67, 412, 0                    }, /*                 SELECT reduce 76 */
/* State 130 */
  {  67, 413, 0                    }, /*                 SELECT reduce 77 */
/* State 131 */
  {  67, 414, 0                    }, /*                 SELECT reduce 78 */
/* State 132 */
  {YYNOCODE,0,0}, /* Unused */
/* State 133 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[1595] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1596] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[1599] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 134 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 135, &yyActionTable[1627] }, /*                   expr shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1628] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1629] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1630] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1631] }, /*                 PRAGMA shift  17 */
/* State 135 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1659] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 136 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 137, &yyActionTable[1691] }, /*                   expr shift  137 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1692] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1693] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1694] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1695] }, /*                 PRAGMA shift  17 */
/* State 137 */
  {YYNOCODE,0,0}, /* Unused */
/* State 138 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 139, &yyActionTable[1724] }, /*                   expr shift  139 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1725] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1726] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1727] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1728] }, /*                 PRAGMA shift  17 */
/* State 139 */
  {YYNOCODE,0,0}, /* Unused */
/* State 140 */
  {  66, 141, &yyActionTable[1758] }, /*                     RP shift  141 */
  {  12, 142, 0                    }, /*                  COMMA shift  142 */
/* State 141 */
  {YYNOCODE,0,0}, /* Unused */
/* State 142 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 133, &yyActionTable[1760] }, /*                   expr shift  133 */
  { 104, 143, 0                    }, /*               expritem shift  143 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1761] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1762] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1763] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1764] }, /*                 PRAGMA shift  17 */
/* State 143 */
  {YYNOCODE,0,0}, /* Unused */
/* State 144 */
  {YYNOCODE,0,0}, /* Unused */
/* State 145 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 146, &yyActionTable[1794] }, /*                   expr shift  146 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1795] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1796] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1797] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1798] }, /*                 PRAGMA shift  17 */
/* State 146 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1826] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 147 */
  {YYNOCODE,0,0}, /* Unused */
/* State 148 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 149, &yyActionTable[1859] }, /*                   expr shift  149 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1860] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1861] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1862] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1863] }, /*                 PRAGMA shift  17 */
/* State 149 */
  {   3, 150, 0                    }, /*                    AND shift  150 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[1891] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[1892] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[1895] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 150 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 151, &yyActionTable[1923] }, /*                   expr shift  151 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[1924] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[1925] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[1926] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[1927] }, /*                 PRAGMA shift  17 */
/* State 151 */
  {  64, 500, &yyActionTable[1956] }, /*                PRIMARY reduce 164 */
  {   0, 500, 0                    }, /*                      $ reduce 164 */
  {  66, 500, 0                    }, /*                     RP reduce 164 */
  {   3, 500, &yyActionTable[1968] }, /*                    AND reduce 164 */
  {  68, 500, &yyActionTable[1969] }, /*                   SEMI reduce 164 */
  {   5, 500, 0                    }, /*                    ASC reduce 164 */
  {  70, 113, &yyActionTable[1972] }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  73, 500, &yyActionTable[1973] }, /*                 STRING reduce 164 */
  {  10, 500, 0                    }, /*                CLUSTER reduce 164 */
  {  75, 500, 0                    }, /*                   TEMP reduce 164 */
  {  12, 500, 0                    }, /*                  COMMA reduce 164 */
  {   3, 474, 0                    }, /*                    AND reduce 138 */
  {   4, 500, 0                    }, /*                     AS reduce 164 */
  {  79, 500, &yyActionTable[1975] }, /*                  UNION reduce 164 */
  {  80, 500, &yyActionTable[1978] }, /*                 UNIQUE reduce 164 */
  {   6, 500, 0                    }, /*                  BEGIN reduce 164 */
  {   9, 500, 0                    }, /*                  CHECK reduce 164 */
  {  83, 500, 0                    }, /*                 VACUUM reduce 164 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  85, 500, &yyActionTable[1979] }, /*                  WHERE reduce 164 */
  {  22, 500, 0                    }, /*                   DESC reduce 164 */
  {  16, 500, 0                    }, /*             CONSTRAINT reduce 164 */
  {  21, 500, 0                    }, /*             DELIMITERS reduce 164 */
  {  60, 474, 0                    }, /*                     OR reduce 138 */
  {  26, 500, 0                    }, /*                    END reduce 164 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  29, 500, 0                    }, /*                 EXCEPT reduce 164 */
  {  30, 500, 0                    }, /*                EXPLAIN reduce 164 */
  {YYNOCODE,0,0}, /* Unused */
  {  32, 500, 0                    }, /*                   FROM reduce 164 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {  36, 500, 0                    }, /*                  GROUP reduce 164 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  38, 500, 0                    }, /*                 HAVING reduce 164 */
  {  39, 500, 0                    }, /*                     ID reduce 164 */
  {YYNOCODE,0,0}, /* Unused */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 500, 0                    }, /*              INTERSECT reduce 164 */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, 0                    }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60, 500, &yyActionTable[1980] }, /*                     OR reduce 164 */
  {  61, 500, 0                    }, /*                  ORDER reduce 164 */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  63, 500, 0                    }, /*                 PRAGMA reduce 164 */
/* State 152 */
  {  52, 153, 0                    }, /*                     LP shift  153 */
/* State 153 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 133, &yyActionTable[2020] }, /*                   expr shift  133 */
  { 104, 144, 0                    }, /*               expritem shift  144 */
  { 105, 156, &yyActionTable[2021] }, /*               exprlist shift  156 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  63,  17, &yyActionTable[2037] }, /*                 PRAGMA shift  17 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2022] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  { 121,  59, 0                    }, /*              oneselect shift  59 */
  {  58,  79, &yyActionTable[2024] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2035] }, /*                   PLUS shift  138 */
  { 127, 154, &yyActionTable[2036] }, /*                 select shift  154 */
/* State 154 */
  {  29, 131, 0                    }, /*                 EXCEPT shift  131 */
  {YYNOCODE,0,0}, /* Unused */
  {  66, 155, 0                    }, /*                     RP shift  155 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 130, &yyActionTable[2052] }, /*              INTERSECT shift  130 */
  { 118,  61, 0                    }, /*                 joinop shift  61 */
  {  79, 128, 0                    }, /*                  UNION shift  128 */
/* State 155 */
  {YYNOCODE,0,0}, /* Unused */
/* State 156 */
  {  66, 157, &yyActionTable[2062] }, /*                     RP shift  157 */
  {  12, 142, 0                    }, /*                  COMMA shift  142 */
/* State 157 */
  {YYNOCODE,0,0}, /* Unused */
/* State 158 */
  {   5,  49, 0                    }, /*                    ASC shift  49 */
  { 133, 159, &yyActionTable[2064] }, /*              sortorder shift  159 */
  {  22,  50, 0                    }, /*                   DESC shift  50 */
  {YYNOCODE,0,0}, /* Unused */
/* State 159 */
  {YYNOCODE,0,0}, /* Unused */
/* State 160 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 161, &yyActionTable[2069] }, /*                   expr shift  161 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2070] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2071] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2072] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2073] }, /*                 PRAGMA shift  17 */
/* State 161 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[2101] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2102] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2105] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 162 */
  {   8, 163, 0                    }, /*                     BY shift  163 */
/* State 163 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 133, &yyActionTable[2134] }, /*                   expr shift  133 */
  { 104, 144, 0                    }, /*               expritem shift  144 */
  { 105, 164, &yyActionTable[2135] }, /*               exprlist shift  164 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2136] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2137] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2138] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2149] }, /*                 PRAGMA shift  17 */
/* State 164 */
  {  12, 142, 0                    }, /*                  COMMA shift  142 */
/* State 165 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 166, &yyActionTable[2167] }, /*                   expr shift  166 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2168] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2169] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2170] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2171] }, /*                 PRAGMA shift  17 */
/* State 166 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[2199] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2200] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2203] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 167 */
  {YYNOCODE,0,0}, /* Unused */
/* State 168 */
  { 134, 171, &yyActionTable[2233] }, /*             stl_prefix shift  171 */
  { 128, 169, 0                    }, /*             seltablist shift  169 */
/* State 169 */
  {  12, 170, 0                    }, /*                  COMMA shift  170 */
/* State 170 */
  {YYNOCODE,0,0}, /* Unused */
/* State 171 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2236] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2237] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2238] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 172, &yyActionTable[2240] }, /*                    ids shift  172 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 172 */
  {   0, 429, 0                    }, /*                      $ reduce 93 */
  {  36, 429, &yyActionTable[2255] }, /*                  GROUP reduce 93 */
  {  66, 429, 0                    }, /*                     RP reduce 93 */
  {   4, 173, 0                    }, /*                     AS shift  173 */
  {  68, 429, &yyActionTable[2253] }, /*                   SEMI reduce 93 */
  {   5, 424, 0                    }, /*                    ASC reduce 88 */
  {  38, 429, &yyActionTable[2260] }, /*                 HAVING reduce 93 */
  {  39, 424, 0                    }, /*                     ID reduce 88 */
  {   6, 424, 0                    }, /*                  BEGIN reduce 88 */
  {  73, 424, 0                    }, /*                 STRING reduce 88 */
  {  10, 424, 0                    }, /*                CLUSTER reduce 88 */
  {  75, 424, 0                    }, /*                   TEMP reduce 88 */
  {  12, 429, 0                    }, /*                  COMMA reduce 93 */
  {  45, 429, 0                    }, /*              INTERSECT reduce 93 */
  {  21, 424, 0                    }, /*             DELIMITERS reduce 88 */
  {  79, 429, 0                    }, /*                  UNION reduce 93 */
  {  22, 424, 0                    }, /*                   DESC reduce 88 */
  {  29, 429, 0                    }, /*                 EXCEPT reduce 93 */
  {YYNOCODE,0,0}, /* Unused */
  {  83, 424, 0                    }, /*                 VACUUM reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {  85, 429, &yyActionTable[2266] }, /*                  WHERE reduce 93 */
  {  86, 174, &yyActionTable[2268] }, /*                     as shift  174 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26, 424, 0                    }, /*                    END reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 429, &yyActionTable[2269] }, /*                  ORDER reduce 93 */
  {  30, 424, 0                    }, /*                EXPLAIN reduce 88 */
  {  63, 424, 0                    }, /*                 PRAGMA reduce 88 */
/* State 173 */
  {YYNOCODE,0,0}, /* Unused */
/* State 174 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2285] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2286] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2287] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 175, &yyActionTable[2289] }, /*                    ids shift  175 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 175 */
  {YYNOCODE,0,0}, /* Unused */
/* State 176 */
  {YYNOCODE,0,0}, /* Unused */
/* State 177 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 178, &yyActionTable[2303] }, /*                   expr shift  178 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2304] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2305] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2306] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2307] }, /*                 PRAGMA shift  17 */
/* State 178 */
  {   6, 424, 0                    }, /*                  BEGIN reduce 88 */
  {  22, 424, 0                    }, /*                   DESC reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {   4, 173, 0                    }, /*                     AS shift  173 */
  {   5, 424, 0                    }, /*                    ASC reduce 88 */
  {  70, 113, &yyActionTable[2335] }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  73, 424, 0                    }, /*                 STRING reduce 88 */
  {  10, 424, 0                    }, /*                CLUSTER reduce 88 */
  {  75, 424, 0                    }, /*                   TEMP reduce 88 */
  {  12, 422, 0                    }, /*                  COMMA reduce 86 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83, 424, 0                    }, /*                 VACUUM reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {  21, 424, 0                    }, /*             DELIMITERS reduce 88 */
  {  86, 179, &yyActionTable[2336] }, /*                     as shift  179 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26, 424, 0                    }, /*                    END reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  30, 424, 0                    }, /*                EXPLAIN reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {  32, 422, 0                    }, /*                   FROM reduce 86 */
  {YYNOCODE,0,0}, /* Unused */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, 0                    }, /*                   GLOB shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {YYNOCODE,0,0}, /* Unused */
  {  39, 424, 0                    }, /*                     ID reduce 88 */
  {YYNOCODE,0,0}, /* Unused */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, 0                    }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, 0                    }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {  63, 424, 0                    }, /*                 PRAGMA reduce 88 */
/* State 179 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2399] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2400] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2401] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 180, &yyActionTable[2403] }, /*                    ids shift  180 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 180 */
  {YYNOCODE,0,0}, /* Unused */
/* State 181 */
  {YYNOCODE,0,0}, /* Unused */
/* State 182 */
  {YYNOCODE,0,0}, /* Unused */
/* State 183 */
  {YYNOCODE,0,0}, /* Unused */
/* State 184 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  66, 185, &yyActionTable[2419] }, /*                     RP shift  185 */
  {  35, 105, &yyActionTable[2420] }, /*                   GLOB shift  105 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2423] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2429] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 185 */
  {YYNOCODE,0,0}, /* Unused */
/* State 186 */
  {  66, 187, &yyActionTable[2453] }, /*                     RP shift  187 */
  {  12, 142, 0                    }, /*                  COMMA shift  142 */
/* State 187 */
  {YYNOCODE,0,0}, /* Unused */
/* State 188 */
  {  66, 189, 0                    }, /*                     RP shift  189 */
/* State 189 */
  {YYNOCODE,0,0}, /* Unused */
/* State 190 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  66, 191, &yyActionTable[2457] }, /*                     RP shift  191 */
  {  35, 105, &yyActionTable[2458] }, /*                   GLOB shift  105 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2461] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2467] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 191 */
  {YYNOCODE,0,0}, /* Unused */
/* State 192 */
  {YYNOCODE,0,0}, /* Unused */
/* State 193 */
  {  54, 200, 0                    }, /*                  MINUS shift  200 */
  {  73, 194, 0                    }, /*                 STRING shift  194 */
  {  58, 204, 0                    }, /*                   NULL shift  204 */
  {  31, 203, 0                    }, /*                  FLOAT shift  203 */
  {  44, 196, 0                    }, /*                INTEGER shift  196 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 197, &yyActionTable[2491] }, /*                   PLUS shift  197 */
  {  39, 195, &yyActionTable[2494] }, /*                     ID shift  195 */
/* State 194 */
  {YYNOCODE,0,0}, /* Unused */
/* State 195 */
  {YYNOCODE,0,0}, /* Unused */
/* State 196 */
  {YYNOCODE,0,0}, /* Unused */
/* State 197 */
  {  44, 198, 0                    }, /*                INTEGER shift  198 */
  {  31, 199, 0                    }, /*                  FLOAT shift  199 */
/* State 198 */
  {YYNOCODE,0,0}, /* Unused */
/* State 199 */
  {YYNOCODE,0,0}, /* Unused */
/* State 200 */
  {  44, 201, 0                    }, /*                INTEGER shift  201 */
  {  31, 202, 0                    }, /*                  FLOAT shift  202 */
/* State 201 */
  {YYNOCODE,0,0}, /* Unused */
/* State 202 */
  {YYNOCODE,0,0}, /* Unused */
/* State 203 */
  {YYNOCODE,0,0}, /* Unused */
/* State 204 */
  {YYNOCODE,0,0}, /* Unused */
/* State 205 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52, 206, 0                    }, /*                     LP shift  206 */
  {  21,  12, &yyActionTable[2512] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2513] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2514] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 217, &yyActionTable[2520] }, /*                    ids shift  217 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 206 */
  {  44, 212, 0                    }, /*                INTEGER shift  212 */
  {  62, 213, &yyActionTable[2531] }, /*                   PLUS shift  213 */
  { 130, 207, &yyActionTable[2529] }, /*                 signed shift  207 */
  {  54, 215, 0                    }, /*                  MINUS shift  215 */
/* State 207 */
  {  66, 208, &yyActionTable[2533] }, /*                     RP shift  208 */
  {  12, 209, 0                    }, /*                  COMMA shift  209 */
/* State 208 */
  {YYNOCODE,0,0}, /* Unused */
/* State 209 */
  {  44, 212, 0                    }, /*                INTEGER shift  212 */
  {  62, 213, &yyActionTable[2538] }, /*                   PLUS shift  213 */
  { 130, 210, &yyActionTable[2536] }, /*                 signed shift  210 */
  {  54, 215, 0                    }, /*                  MINUS shift  215 */
/* State 210 */
  {  66, 211, 0                    }, /*                     RP shift  211 */
/* State 211 */
  {YYNOCODE,0,0}, /* Unused */
/* State 212 */
  {YYNOCODE,0,0}, /* Unused */
/* State 213 */
  {  44, 214, 0                    }, /*                INTEGER shift  214 */
/* State 214 */
  {YYNOCODE,0,0}, /* Unused */
/* State 215 */
  {  44, 216, 0                    }, /*                INTEGER shift  216 */
/* State 216 */
  {YYNOCODE,0,0}, /* Unused */
/* State 217 */
  {YYNOCODE,0,0}, /* Unused */
/* State 218 */
  {YYNOCODE,0,0}, /* Unused */
/* State 219 */
  {YYNOCODE,0,0}, /* Unused */
/* State 220 */
  {  80, 234, &yyActionTable[2552] }, /*                 UNIQUE shift  234 */
  {   9, 238, 0                    }, /*                  CHECK shift  238 */
  {  66, 399, 0                    }, /*                     RP reduce 63 */
  {  64, 225, &yyActionTable[2554] }, /*                PRIMARY shift  225 */
  {  12, 221, 0                    }, /*                  COMMA shift  221 */
  {  16, 223, 0                    }, /*             CONSTRAINT shift  223 */
  {YYNOCODE,0,0}, /* Unused */
  { 135, 240, 0                    }, /*                  tcons shift  240 */
/* State 221 */
  {  80, 234, &yyActionTable[2559] }, /*                 UNIQUE shift  234 */
  {   9, 238, 0                    }, /*                  CHECK shift  238 */
  {  64, 225, &yyActionTable[2560] }, /*                PRIMARY shift  225 */
  {  16, 223, 0                    }, /*             CONSTRAINT shift  223 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 135, 222, 0                    }, /*                  tcons shift  222 */
/* State 222 */
  {YYNOCODE,0,0}, /* Unused */
/* State 223 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2566] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2567] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2568] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 224, &yyActionTable[2570] }, /*                    ids shift  224 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 224 */
  {YYNOCODE,0,0}, /* Unused */
/* State 225 */
  {  49, 226, 0                    }, /*                    KEY shift  226 */
/* State 226 */
  {  52, 227, 0                    }, /*                     LP shift  227 */
/* State 227 */
  { 112, 228, 0                    }, /*                idxlist shift  228 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[2586] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2587] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2589] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 232, &yyActionTable[2593] }, /*                    ids shift  232 */
  { 111, 233, &yyActionTable[2597] }, /*                idxitem shift  233 */
/* State 228 */
  {  66, 229, &yyActionTable[2602] }, /*                     RP shift  229 */
  {  12, 230, 0                    }, /*                  COMMA shift  230 */
/* State 229 */
  {YYNOCODE,0,0}, /* Unused */
/* State 230 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2604] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2605] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2606] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 232, &yyActionTable[2608] }, /*                    ids shift  232 */
  { 111, 231, &yyActionTable[2612] }, /*                idxitem shift  231 */
/* State 231 */
  {YYNOCODE,0,0}, /* Unused */
/* State 232 */
  {YYNOCODE,0,0}, /* Unused */
/* State 233 */
  {YYNOCODE,0,0}, /* Unused */
/* State 234 */
  {  52, 235, 0                    }, /*                     LP shift  235 */
/* State 235 */
  { 112, 236, 0                    }, /*                idxlist shift  236 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[2625] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2626] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2628] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 232, &yyActionTable[2632] }, /*                    ids shift  232 */
  { 111, 233, &yyActionTable[2636] }, /*                idxitem shift  233 */
/* State 236 */
  {  66, 237, &yyActionTable[2641] }, /*                     RP shift  237 */
  {  12, 230, 0                    }, /*                  COMMA shift  230 */
/* State 237 */
  {YYNOCODE,0,0}, /* Unused */
/* State 238 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 239, &yyActionTable[2643] }, /*                   expr shift  239 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2644] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2645] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2646] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2647] }, /*                 PRAGMA shift  17 */
/* State 239 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[2675] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2676] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2679] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 240 */
  {YYNOCODE,0,0}, /* Unused */
/* State 241 */
  {YYNOCODE,0,0}, /* Unused */
/* State 242 */
  {YYNOCODE,0,0}, /* Unused */
/* State 243 */
  { 136, 244, &yyActionTable[2711] }, /*                   temp shift  244 */
  {  80, 256, 0                    }, /*                 UNIQUE shift  256 */
  {  74, 353, &yyActionTable[2715] }, /*                  TABLE reduce 17 */
  {  75, 247, 0                    }, /*                   TEMP shift  247 */
  { 140, 248, 0                    }, /*             uniqueflag shift  248 */
  {  42, 511, 0                    }, /*                  INDEX reduce 175 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 244 */
  {  74, 245, 0                    }, /*                  TABLE shift  245 */
/* State 245 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2719] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2720] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2721] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 246, &yyActionTable[2723] }, /*                    ids shift  246 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 246 */
  {  52, 351, 0                    }, /*                     LP reduce 15 */
/* State 247 */
  {  74, 352, 0                    }, /*                  TABLE reduce 16 */
/* State 248 */
  {  42, 249, 0                    }, /*                  INDEX shift  249 */
/* State 249 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2738] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2739] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2740] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 250, &yyActionTable[2742] }, /*                    ids shift  250 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 250 */
  {  59, 251, 0                    }, /*                     ON shift  251 */
/* State 251 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2755] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2756] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2757] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 252, &yyActionTable[2759] }, /*                    ids shift  252 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 252 */
  {  52, 253, 0                    }, /*                     LP shift  253 */
/* State 253 */
  { 112, 254, 0                    }, /*                idxlist shift  254 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[2773] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2774] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2776] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 232, &yyActionTable[2780] }, /*                    ids shift  232 */
  { 111, 233, &yyActionTable[2784] }, /*                idxitem shift  233 */
/* State 254 */
  {  66, 255, &yyActionTable[2789] }, /*                     RP shift  255 */
  {  12, 230, 0                    }, /*                  COMMA shift  230 */
/* State 255 */
  {YYNOCODE,0,0}, /* Unused */
/* State 256 */
  {  42, 510, 0                    }, /*                  INDEX reduce 174 */
/* State 257 */
  {  74, 258, &yyActionTable[2793] }, /*                  TABLE shift  258 */
  {  42, 260, 0                    }, /*                  INDEX shift  260 */
/* State 258 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2794] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2795] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2796] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 259, &yyActionTable[2798] }, /*                    ids shift  259 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 259 */
  {YYNOCODE,0,0}, /* Unused */
/* State 260 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2811] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2812] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2813] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 261, &yyActionTable[2815] }, /*                    ids shift  261 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 261 */
  {YYNOCODE,0,0}, /* Unused */
/* State 262 */
  {  29, 131, 0                    }, /*                 EXCEPT shift  131 */
  {  45, 130, &yyActionTable[2828] }, /*              INTERSECT shift  130 */
  { 118,  61, 0                    }, /*                 joinop shift  61 */
  {  79, 128, 0                    }, /*                  UNION shift  128 */
/* State 263 */
  {  32, 264, 0                    }, /*                   FROM shift  264 */
/* State 264 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2833] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2834] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2835] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 265, &yyActionTable[2837] }, /*                    ids shift  265 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 265 */
  {  85, 165, 0                    }, /*                  WHERE shift  165 */
  { 141, 266, &yyActionTable[2849] }, /*              where_opt shift  266 */
/* State 266 */
  {YYNOCODE,0,0}, /* Unused */
/* State 267 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2852] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2853] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2854] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 268, &yyActionTable[2856] }, /*                    ids shift  268 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 268 */
  {  69, 269, 0                    }, /*                    SET shift  269 */
/* State 269 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  { 129, 270, 0                    }, /*                setlist shift  270 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[2869] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2871] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2873] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 276, &yyActionTable[2877] }, /*                    ids shift  276 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 270 */
  {  12, 272, 0                    }, /*                  COMMA shift  272 */
  { 141, 271, &yyActionTable[2887] }, /*              where_opt shift  271 */
  {  85, 165, 0                    }, /*                  WHERE shift  165 */
  {YYNOCODE,0,0}, /* Unused */
/* State 271 */
  {YYNOCODE,0,0}, /* Unused */
/* State 272 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[2890] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[2891] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[2892] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 273, &yyActionTable[2894] }, /*                    ids shift  273 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 273 */
  {  28, 274, 0                    }, /*                     EQ shift  274 */
/* State 274 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 275, &yyActionTable[2907] }, /*                   expr shift  275 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2908] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2909] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2910] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2911] }, /*                 PRAGMA shift  17 */
/* State 275 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[2939] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[2940] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[2943] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 276 */
  {  28, 277, 0                    }, /*                     EQ shift  277 */
/* State 277 */
  {  39,  54, 0                    }, /*                     ID shift  54 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  26,  16, 0                    }, /*                    END shift  16 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  31,  84, 0                    }, /*                  FLOAT shift  84 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 103, 278, &yyActionTable[2972] }, /*                   expr shift  278 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  57, 0                    }, /*                 STRING shift  57 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {  44,  83, 0                    }, /*                INTEGER shift  83 */
  { 109,  56, 0                    }, /*                     id shift  56 */
  { 110,  80, 0                    }, /*                    ids shift  80 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  52,  58, 0                    }, /*                     LP shift  58 */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 136, &yyActionTable[2973] }, /*                  MINUS shift  136 */
  {YYNOCODE,0,0}, /* Unused */
  {  56, 134, 0                    }, /*                    NOT shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  58,  79, &yyActionTable[2974] }, /*                   NULL shift  79 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 138, &yyActionTable[2975] }, /*                   PLUS shift  138 */
  {  63,  17, &yyActionTable[2976] }, /*                 PRAGMA shift  17 */
/* State 278 */
  {   3,  78, 0                    }, /*                    AND shift  78 */
  {  15, 115, 0                    }, /*                 CONCAT shift  115 */
  {  34,  94, 0                    }, /*                     GE shift  94 */
  {  35, 105, &yyActionTable[3004] }, /*                   GLOB shift  105 */
  {  28,  98, 0                    }, /*                     EQ shift  98 */
  {  37,  90, 0                    }, /*                     GT shift  90 */
  {  70, 113, 0                    }, /*                  SLASH shift  113 */
  {   7, 121, 0                    }, /*                BETWEEN shift  121 */
  {  72, 111, 0                    }, /*                   STAR shift  111 */
  {  41, 125, 0                    }, /*                     IN shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47, 118, &yyActionTable[3005] }, /*                     IS shift  118 */
  {  48, 117, 0                    }, /*                 ISNULL shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  50,  92, 0                    }, /*                     LE shift  92 */
  {  51, 100, 0                    }, /*                   LIKE shift  100 */
  {YYNOCODE,0,0}, /* Unused */
  {  53,  88, 0                    }, /*                     LT shift  88 */
  {  54, 109, 0                    }, /*                  MINUS shift  109 */
  {  55,  96, 0                    }, /*                     NE shift  96 */
  {  56, 102, 0                    }, /*                    NOT shift  102 */
  {  57, 120, 0                    }, /*                NOTNULL shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  60,  86, &yyActionTable[3008] }, /*                     OR shift  86 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 107, 0                    }, /*                   PLUS shift  107 */
  {YYNOCODE,0,0}, /* Unused */
/* State 279 */
  {  46, 280, 0                    }, /*                   INTO shift  280 */
/* State 280 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3037] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3038] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3039] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 281, &yyActionTable[3041] }, /*                    ids shift  281 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 281 */
  {  52, 301, 0                    }, /*                     LP shift  301 */
  { 115, 282, 0                    }, /*         inscollist_opt shift  282 */
/* State 282 */
  {  84, 284, 0                    }, /*                 VALUES shift  284 */
  { 121,  59, 0                    }, /*              oneselect shift  59 */
  {  67,  63, 0                    }, /*                 SELECT shift  63 */
  { 127, 283, &yyActionTable[3057] }, /*                 select shift  283 */
/* State 283 */
  {  29, 131, 0                    }, /*                 EXCEPT shift  131 */
  {  45, 130, &yyActionTable[3059] }, /*              INTERSECT shift  130 */
  { 118,  61, 0                    }, /*                 joinop shift  61 */
  {  79, 128, 0                    }, /*                  UNION shift  128 */
/* State 284 */
  {  52, 285, 0                    }, /*                     LP shift  285 */
/* State 285 */
  {  44, 290, 0                    }, /*                INTEGER shift  290 */
  {  73, 298, 0                    }, /*                 STRING shift  298 */
  {  58, 299, 0                    }, /*                   NULL shift  299 */
  {  54, 294, 0                    }, /*                  MINUS shift  294 */
  { 116, 300, &yyActionTable[3064] }, /*                   item shift  300 */
  { 117, 286, 0                    }, /*               itemlist shift  286 */
  {  62, 291, &yyActionTable[3067] }, /*                   PLUS shift  291 */
  {  31, 297, 0                    }, /*                  FLOAT shift  297 */
/* State 286 */
  {  66, 287, &yyActionTable[3073] }, /*                     RP shift  287 */
  {  12, 288, 0                    }, /*                  COMMA shift  288 */
/* State 287 */
  {YYNOCODE,0,0}, /* Unused */
/* State 288 */
  {  44, 290, 0                    }, /*                INTEGER shift  290 */
  {  73, 298, 0                    }, /*                 STRING shift  298 */
  {  58, 299, 0                    }, /*                   NULL shift  299 */
  {  54, 294, 0                    }, /*                  MINUS shift  294 */
  { 116, 289, &yyActionTable[3075] }, /*                   item shift  289 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 291, &yyActionTable[3078] }, /*                   PLUS shift  291 */
  {  31, 297, 0                    }, /*                  FLOAT shift  297 */
/* State 289 */
  {YYNOCODE,0,0}, /* Unused */
/* State 290 */
  {YYNOCODE,0,0}, /* Unused */
/* State 291 */
  {  44, 292, 0                    }, /*                INTEGER shift  292 */
  {  31, 293, 0                    }, /*                  FLOAT shift  293 */
/* State 292 */
  {YYNOCODE,0,0}, /* Unused */
/* State 293 */
  {YYNOCODE,0,0}, /* Unused */
/* State 294 */
  {  44, 295, 0                    }, /*                INTEGER shift  295 */
  {  31, 296, 0                    }, /*                  FLOAT shift  296 */
/* State 295 */
  {YYNOCODE,0,0}, /* Unused */
/* State 296 */
  {YYNOCODE,0,0}, /* Unused */
/* State 297 */
  {YYNOCODE,0,0}, /* Unused */
/* State 298 */
  {YYNOCODE,0,0}, /* Unused */
/* State 299 */
  {YYNOCODE,0,0}, /* Unused */
/* State 300 */
  {YYNOCODE,0,0}, /* Unused */
/* State 301 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  { 114, 302, 0                    }, /*             inscollist shift  302 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  21,  12, &yyActionTable[3097] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3098] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3101] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 306, &yyActionTable[3105] }, /*                    ids shift  306 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 302 */
  {  66, 303, &yyActionTable[3114] }, /*                     RP shift  303 */
  {  12, 304, 0                    }, /*                  COMMA shift  304 */
/* State 303 */
  {YYNOCODE,0,0}, /* Unused */
/* State 304 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3116] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3117] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3118] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 305, &yyActionTable[3120] }, /*                    ids shift  305 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 305 */
  {YYNOCODE,0,0}, /* Unused */
/* State 306 */
  {YYNOCODE,0,0}, /* Unused */
/* State 307 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3134] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3135] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3136] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 308, &yyActionTable[3138] }, /*                    ids shift  308 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 308 */
  {  32, 309, 0                    }, /*                   FROM shift  309 */
/* State 309 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3151] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3152] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3153] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 310, &yyActionTable[3155] }, /*                    ids shift  310 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 310 */
  {  82, 311, 0                    }, /*                  USING shift  311 */
/* State 311 */
  {  21, 312, 0                    }, /*             DELIMITERS shift  312 */
/* State 312 */
  {  73, 313, 0                    }, /*                 STRING shift  313 */
/* State 313 */
  {YYNOCODE,0,0}, /* Unused */
/* State 314 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3171] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3172] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3173] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 315, &yyActionTable[3175] }, /*                    ids shift  315 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 315 */
  {YYNOCODE,0,0}, /* Unused */
/* State 316 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3188] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3189] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3190] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 317, &yyActionTable[3192] }, /*                    ids shift  317 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 317 */
  {  52, 330, &yyActionTable[3205] }, /*                     LP shift  330 */
  {  28, 318, 0                    }, /*                     EQ shift  318 */
/* State 318 */
  {  22,  10, 0                    }, /*                   DESC shift  10 */
  {  59, 320, 0                    }, /*                     ON shift  320 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 319, 0                    }, /*                    ids shift  319 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  54, 327, &yyActionTable[3206] }, /*                  MINUS shift  327 */
  { 119, 322, 0                    }, /*              minus_num shift  322 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  16, 0                    }, /*                    END shift  16 */
  { 123, 321, &yyActionTable[3207] }, /*               plus_num shift  321 */
  { 124, 323, 0                    }, /*               plus_opt shift  323 */
  {YYNOCODE,0,0}, /* Unused */
  {  62, 329, &yyActionTable[3208] }, /*                   PLUS shift  329 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 319 */
  {YYNOCODE,0,0}, /* Unused */
/* State 320 */
  {YYNOCODE,0,0}, /* Unused */
/* State 321 */
  {YYNOCODE,0,0}, /* Unused */
/* State 322 */
  {YYNOCODE,0,0}, /* Unused */
/* State 323 */
  { 120, 324, &yyActionTable[3243] }, /*                 number shift  324 */
  {  44, 325, 0                    }, /*                INTEGER shift  325 */
  {YYNOCODE,0,0}, /* Unused */
  {  31, 326, 0                    }, /*                  FLOAT shift  326 */
/* State 324 */
  {YYNOCODE,0,0}, /* Unused */
/* State 325 */
  {YYNOCODE,0,0}, /* Unused */
/* State 326 */
  {YYNOCODE,0,0}, /* Unused */
/* State 327 */
  { 120, 328, &yyActionTable[3250] }, /*                 number shift  328 */
  {  44, 325, 0                    }, /*                INTEGER shift  325 */
  {YYNOCODE,0,0}, /* Unused */
  {  31, 326, 0                    }, /*                  FLOAT shift  326 */
/* State 328 */
  {YYNOCODE,0,0}, /* Unused */
/* State 329 */
  {YYNOCODE,0,0}, /* Unused */
/* State 330 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  10,  18, 0                    }, /*                CLUSTER shift  18 */
  {  83,  14, 0                    }, /*                 VACUUM shift  14 */
  {  30,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  21,  12, &yyActionTable[3255] }, /*             DELIMITERS shift  12 */
  {  22,  10, &yyActionTable[3256] }, /*                   DESC shift  10 */
  {  39,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  73,  22, 0                    }, /*                 STRING shift  22 */
  {  26,  16, &yyActionTable[3257] }, /*                    END shift  16 */
  {  75,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 109,  21, 0                    }, /*                     id shift  21 */
  { 110, 331, &yyActionTable[3259] }, /*                    ids shift  331 */
  {  63,  17, 0                    }, /*                 PRAGMA shift  17 */
/* State 331 */
  {  66, 332, 0                    }, /*                     RP shift  332 */
/* State 332 */
  {YYNOCODE,0,0}, /* Unused */
/* State 333 */
  {YYNOCODE,0,0}, /* Unused */
/* State 334 */
  {YYNOCODE,0,0}, /* Unused */
/* State 335 */
  {YYNOCODE,0,0}, /* Unused */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 31, 341},
  { &yyActionTable[32], 1, 531},
  { &yyActionTable[34], 31, 341},
  { &yyActionTable[66], 0, 338},
  { &yyActionTable[67], 31, 531},
  { &yyActionTable[99], 0, 339},
  { &yyActionTable[100], 1, 344},
  { &yyActionTable[102], 0, 343},
  { &yyActionTable[103], 15, 345},
  { &yyActionTable[119], 0, 346},
  { &yyActionTable[120], 0, 359},
  { &yyActionTable[121], 0, 360},
  { &yyActionTable[122], 0, 361},
  { &yyActionTable[123], 0, 362},
  { &yyActionTable[124], 0, 363},
  { &yyActionTable[125], 0, 364},
  { &yyActionTable[126], 0, 365},
  { &yyActionTable[127], 0, 366},
  { &yyActionTable[128], 0, 367},
  { &yyActionTable[129], 0, 368},
  { &yyActionTable[130], 0, 369},
  { &yyActionTable[131], 0, 370},
  { &yyActionTable[132], 0, 371},
  { &yyActionTable[133], 1, 344},
  { &yyActionTable[135], 0, 347},
  { &yyActionTable[136], 1, 344},
  { &yyActionTable[138], 0, 348},
  { &yyActionTable[139], 1, 344},
  { &yyActionTable[141], 0, 349},
  { &yyActionTable[142], 1, 531},
  { &yyActionTable[144], 0, 350},
  { &yyActionTable[145], 31, 531},
  { &yyActionTable[177], 3, 531},
  { &yyActionTable[181], 0, 531},
  { &yyActionTable[182], 0, 354},
  { &yyActionTable[183], 31, 531},
  { &yyActionTable[215], 0, 355},
  { &yyActionTable[216], 15, 372},
  { &yyActionTable[232], 0, 382},
  { &yyActionTable[233], 7, 357},
  { &yyActionTable[241], 0, 381},
  { &yyActionTable[242], 15, 531},
  { &yyActionTable[258], 7, 531},
  { &yyActionTable[266], 0, 383},
  { &yyActionTable[267], 0, 531},
  { &yyActionTable[268], 0, 394},
  { &yyActionTable[269], 0, 531},
  { &yyActionTable[270], 3, 438},
  { &yyActionTable[274], 0, 395},
  { &yyActionTable[275], 0, 436},
  { &yyActionTable[276], 0, 437},
  { &yyActionTable[277], 0, 396},
  { &yyActionTable[278], 0, 531},
  { &yyActionTable[279], 31, 531},
  { &yyActionTable[311], 0, 368},
  { &yyActionTable[312], 31, 508},
  { &yyActionTable[344], 63, 531},
  { &yyActionTable[408], 63, 531},
  { &yyActionTable[472], 31, 531},
  { &yyActionTable[504], 0, 409},
  { &yyActionTable[505], 7, 531},
  { &yyActionTable[513], 1, 531},
  { &yyActionTable[515], 0, 410},
  { &yyActionTable[516], 3, 418},
  { &yyActionTable[520], 3, 420},
  { &yyActionTable[524], 3, 531},
  { &yyActionTable[528], 1, 444},
  { &yyActionTable[530], 1, 439},
  { &yyActionTable[532], 1, 441},
  { &yyActionTable[534], 1, 431},
  { &yyActionTable[536], 0, 415},
  { &yyActionTable[537], 0, 531},
  { &yyActionTable[538], 31, 531},
  { &yyActionTable[570], 0, 432},
  { &yyActionTable[571], 31, 531},
  { &yyActionTable[603], 3, 438},
  { &yyActionTable[607], 0, 433},
  { &yyActionTable[608], 31, 435},
  { &yyActionTable[640], 31, 531},
  { &yyActionTable[672], 0, 466},
  { &yyActionTable[673], 0, 531},
  { &yyActionTable[674], 15, 531},
  { &yyActionTable[690], 0, 468},
  { &yyActionTable[691], 0, 469},
  { &yyActionTable[692], 0, 470},
  { &yyActionTable[693], 31, 474},
  { &yyActionTable[725], 31, 531},
  { &yyActionTable[757], 31, 475},
  { &yyActionTable[789], 31, 531},
  { &yyActionTable[821], 7, 476},
  { &yyActionTable[829], 31, 531},
  { &yyActionTable[861], 7, 477},
  { &yyActionTable[869], 31, 531},
  { &yyActionTable[901], 7, 478},
  { &yyActionTable[909], 31, 531},
  { &yyActionTable[941], 7, 479},
  { &yyActionTable[949], 31, 531},
  { &yyActionTable[981], 15, 480},
  { &yyActionTable[997], 31, 531},
  { &yyActionTable[1029], 15, 481},
  { &yyActionTable[1045], 31, 531},
  { &yyActionTable[1077], 15, 482},
  { &yyActionTable[1093], 7, 531},
  { &yyActionTable[1101], 31, 531},
  { &yyActionTable[1133], 31, 483},
  { &yyActionTable[1165], 31, 531},
  { &yyActionTable[1197], 15, 484},
  { &yyActionTable[1213], 31, 531},
  { &yyActionTable[1245], 3, 486},
  { &yyActionTable[1249], 31, 531},
  { &yyActionTable[1281], 3, 487},
  { &yyActionTable[1285], 31, 531},
  { &yyActionTable[1317], 0, 488},
  { &yyActionTable[1318], 31, 531},
  { &yyActionTable[1350], 0, 489},
  { &yyActionTable[1351], 31, 531},
  { &yyActionTable[1383], 0, 490},
  { &yyActionTable[1384], 0, 491},
  { &yyActionTable[1385], 0, 531},
  { &yyActionTable[1386], 0, 492},
  { &yyActionTable[1387], 0, 493},
  { &yyActionTable[1388], 31, 531},
  { &yyActionTable[1420], 31, 531},
  { &yyActionTable[1452], 31, 531},
  { &yyActionTable[1484], 63, 531},
  { &yyActionTable[1548], 0, 531},
  { &yyActionTable[1549], 31, 508},
  { &yyActionTable[1581], 7, 531},
  { &yyActionTable[1589], 1, 531},
  { &yyActionTable[1591], 0, 531},
  { &yyActionTable[1592], 0, 531},
  { &yyActionTable[1593], 0, 531},
  { &yyActionTable[1594], 0, 502},
  { &yyActionTable[1595], 31, 507},
  { &yyActionTable[1627], 31, 531},
  { &yyActionTable[1659], 31, 495},
  { &yyActionTable[1691], 31, 531},
  { &yyActionTable[1723], 0, 496},
  { &yyActionTable[1724], 31, 531},
  { &yyActionTable[1756], 0, 497},
  { &yyActionTable[1757], 1, 531},
  { &yyActionTable[1759], 0, 501},
  { &yyActionTable[1760], 31, 508},
  { &yyActionTable[1792], 0, 505},
  { &yyActionTable[1793], 0, 506},
  { &yyActionTable[1794], 31, 531},
  { &yyActionTable[1826], 31, 485},
  { &yyActionTable[1858], 0, 494},
  { &yyActionTable[1859], 31, 531},
  { &yyActionTable[1891], 31, 531},
  { &yyActionTable[1923], 31, 531},
  { &yyActionTable[1955], 63, 531},
  { &yyActionTable[2019], 0, 531},
  { &yyActionTable[2020], 31, 508},
  { &yyActionTable[2052], 7, 531},
  { &yyActionTable[2060], 0, 504},
  { &yyActionTable[2061], 1, 531},
  { &yyActionTable[2063], 0, 503},
  { &yyActionTable[2064], 3, 438},
  { &yyActionTable[2068], 0, 434},
  { &yyActionTable[2069], 31, 531},
  { &yyActionTable[2101], 31, 442},
  { &yyActionTable[2133], 0, 531},
  { &yyActionTable[2134], 31, 508},
  { &yyActionTable[2166], 0, 440},
  { &yyActionTable[2167], 31, 531},
  { &yyActionTable[2199], 31, 445},
  { &yyActionTable[2231], 0, 419},
  { &yyActionTable[2232], 1, 428},
  { &yyActionTable[2234], 0, 426},
  { &yyActionTable[2235], 0, 427},
  { &yyActionTable[2236], 15, 531},
  { &yyActionTable[2252], 31, 531},
  { &yyActionTable[2284], 0, 425},
  { &yyActionTable[2285], 15, 531},
  { &yyActionTable[2301], 0, 430},
  { &yyActionTable[2302], 0, 421},
  { &yyActionTable[2303], 31, 531},
  { &yyActionTable[2335], 63, 531},
  { &yyActionTable[2399], 15, 531},
  { &yyActionTable[2415], 0, 423},
  { &yyActionTable[2416], 0, 416},
  { &yyActionTable[2417], 0, 417},
  { &yyActionTable[2418], 0, 498},
  { &yyActionTable[2419], 31, 531},
  { &yyActionTable[2451], 0, 465},
  { &yyActionTable[2452], 1, 531},
  { &yyActionTable[2454], 0, 472},
  { &yyActionTable[2455], 0, 531},
  { &yyActionTable[2456], 0, 473},
  { &yyActionTable[2457], 31, 531},
  { &yyActionTable[2489], 0, 397},
  { &yyActionTable[2490], 0, 384},
  { &yyActionTable[2491], 7, 531},
  { &yyActionTable[2499], 0, 385},
  { &yyActionTable[2500], 0, 386},
  { &yyActionTable[2501], 0, 387},
  { &yyActionTable[2502], 1, 531},
  { &yyActionTable[2504], 0, 388},
  { &yyActionTable[2505], 0, 391},
  { &yyActionTable[2506], 1, 531},
  { &yyActionTable[2508], 0, 389},
  { &yyActionTable[2509], 0, 392},
  { &yyActionTable[2510], 0, 390},
  { &yyActionTable[2511], 0, 393},
  { &yyActionTable[2512], 15, 373},
  { &yyActionTable[2528], 3, 531},
  { &yyActionTable[2532], 1, 531},
  { &yyActionTable[2534], 0, 374},
  { &yyActionTable[2535], 3, 531},
  { &yyActionTable[2539], 0, 531},
  { &yyActionTable[2540], 0, 375},
  { &yyActionTable[2541], 0, 378},
  { &yyActionTable[2542], 0, 531},
  { &yyActionTable[2543], 0, 379},
  { &yyActionTable[2544], 0, 531},
  { &yyActionTable[2545], 0, 380},
  { &yyActionTable[2546], 0, 377},
  { &yyActionTable[2547], 0, 376},
  { &yyActionTable[2548], 0, 358},
  { &yyActionTable[2549], 7, 531},
  { &yyActionTable[2557], 7, 531},
  { &yyActionTable[2565], 0, 400},
  { &yyActionTable[2566], 15, 531},
  { &yyActionTable[2582], 0, 403},
  { &yyActionTable[2583], 0, 531},
  { &yyActionTable[2584], 0, 531},
  { &yyActionTable[2585], 15, 531},
  { &yyActionTable[2601], 1, 531},
  { &yyActionTable[2603], 0, 404},
  { &yyActionTable[2604], 15, 531},
  { &yyActionTable[2620], 0, 512},
  { &yyActionTable[2621], 0, 514},
  { &yyActionTable[2622], 0, 513},
  { &yyActionTable[2623], 0, 531},
  { &yyActionTable[2624], 15, 531},
  { &yyActionTable[2640], 1, 531},
  { &yyActionTable[2642], 0, 405},
  { &yyActionTable[2643], 31, 531},
  { &yyActionTable[2675], 31, 406},
  { &yyActionTable[2707], 0, 401},
  { &yyActionTable[2708], 0, 402},
  { &yyActionTable[2709], 0, 356},
  { &yyActionTable[2710], 7, 531},
  { &yyActionTable[2718], 0, 531},
  { &yyActionTable[2719], 15, 531},
  { &yyActionTable[2735], 0, 531},
  { &yyActionTable[2736], 0, 531},
  { &yyActionTable[2737], 0, 531},
  { &yyActionTable[2738], 15, 531},
  { &yyActionTable[2754], 0, 531},
  { &yyActionTable[2755], 15, 531},
  { &yyActionTable[2771], 0, 531},
  { &yyActionTable[2772], 15, 531},
  { &yyActionTable[2788], 1, 531},
  { &yyActionTable[2790], 0, 509},
  { &yyActionTable[2791], 0, 531},
  { &yyActionTable[2792], 1, 531},
  { &yyActionTable[2794], 15, 531},
  { &yyActionTable[2810], 0, 407},
  { &yyActionTable[2811], 15, 531},
  { &yyActionTable[2827], 0, 515},
  { &yyActionTable[2828], 3, 408},
  { &yyActionTable[2832], 0, 531},
  { &yyActionTable[2833], 15, 531},
  { &yyActionTable[2849], 1, 444},
  { &yyActionTable[2851], 0, 443},
  { &yyActionTable[2852], 15, 531},
  { &yyActionTable[2868], 0, 531},
  { &yyActionTable[2869], 15, 531},
  { &yyActionTable[2885], 3, 444},
  { &yyActionTable[2889], 0, 446},
  { &yyActionTable[2890], 15, 531},
  { &yyActionTable[2906], 0, 531},
  { &yyActionTable[2907], 31, 531},
  { &yyActionTable[2939], 31, 447},
  { &yyActionTable[2971], 0, 531},
  { &yyActionTable[2972], 31, 531},
  { &yyActionTable[3004], 31, 448},
  { &yyActionTable[3036], 0, 531},
  { &yyActionTable[3037], 15, 531},
  { &yyActionTable[3053], 1, 461},
  { &yyActionTable[3055], 3, 531},
  { &yyActionTable[3059], 3, 450},
  { &yyActionTable[3063], 0, 531},
  { &yyActionTable[3064], 7, 531},
  { &yyActionTable[3072], 1, 531},
  { &yyActionTable[3074], 0, 449},
  { &yyActionTable[3075], 7, 531},
  { &yyActionTable[3083], 0, 451},
  { &yyActionTable[3084], 0, 453},
  { &yyActionTable[3085], 1, 531},
  { &yyActionTable[3087], 0, 454},
  { &yyActionTable[3088], 0, 457},
  { &yyActionTable[3089], 1, 531},
  { &yyActionTable[3091], 0, 455},
  { &yyActionTable[3092], 0, 458},
  { &yyActionTable[3093], 0, 456},
  { &yyActionTable[3094], 0, 459},
  { &yyActionTable[3095], 0, 460},
  { &yyActionTable[3096], 0, 452},
  { &yyActionTable[3097], 15, 531},
  { &yyActionTable[3113], 1, 531},
  { &yyActionTable[3115], 0, 462},
  { &yyActionTable[3116], 15, 531},
  { &yyActionTable[3132], 0, 463},
  { &yyActionTable[3133], 0, 464},
  { &yyActionTable[3134], 15, 531},
  { &yyActionTable[3150], 0, 531},
  { &yyActionTable[3151], 15, 531},
  { &yyActionTable[3167], 0, 517},
  { &yyActionTable[3168], 0, 531},
  { &yyActionTable[3169], 0, 531},
  { &yyActionTable[3170], 0, 516},
  { &yyActionTable[3171], 15, 518},
  { &yyActionTable[3187], 0, 519},
  { &yyActionTable[3188], 15, 531},
  { &yyActionTable[3204], 1, 531},
  { &yyActionTable[3206], 31, 530},
  { &yyActionTable[3238], 0, 520},
  { &yyActionTable[3239], 0, 521},
  { &yyActionTable[3240], 0, 522},
  { &yyActionTable[3241], 0, 523},
  { &yyActionTable[3242], 3, 531},
  { &yyActionTable[3246], 0, 525},
  { &yyActionTable[3247], 0, 527},
  { &yyActionTable[3248], 0, 528},
  { &yyActionTable[3249], 3, 531},
  { &yyActionTable[3253], 0, 526},
  { &yyActionTable[3254], 0, 529},
  { &yyActionTable[3255], 15, 531},
  { &yyActionTable[3271], 0, 531},
  { &yyActionTable[3272], 0, 524},
  { &yyActionTable[3273], 0, 340},
  { &yyActionTable[3274], 0, 342},
  { &yyActionTable[3275], 0, 337},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "AGG_FUNCTION",  "ALL",           "AND",         
  "AS",            "ASC",           "BEGIN",         "BETWEEN",     
  "BY",            "CHECK",         "CLUSTER",       "COLUMN",      
  "COMMA",         "COMMENT",       "COMMIT",        "CONCAT",      
  "CONSTRAINT",    "COPY",          "CREATE",        "DEFAULT",     
  "DELETE",        "DELIMITERS",    "DESC",          "DISTINCT",    
  "DOT",           "DROP",          "END",           "END_OF_FILE", 
  "EQ",            "EXCEPT",        "EXPLAIN",       "FLOAT",       
  "FROM",          "FUNCTION",      "GE",            "GLOB",        
  "GROUP",         "GT",            "HAVING",        "ID",          
  "ILLEGAL",       "IN",            "INDEX",         "INSERT",      
  "INTEGER",       "INTERSECT",     "INTO",          "IS",          
  "ISNULL",        "KEY",           "LE",            "LIKE",        
  "LP",            "LT",            "MINUS",         "NE",          
  "NOT",           "NOTNULL",       "NULL",          "ON",          
  "OR",            "ORDER",         "PLUS",          "PRAGMA",      
  "PRIMARY",       "ROLLBACK",      "RP",            "SELECT",      
  "SEMI",          "SET",           "SLASH",         "SPACE",       
  "STAR",          "STRING",        "TABLE",         "TEMP",        
  "TRANSACTION",   "UMINUS",        "UNCLOSED_STRING",  "UNION",       
  "UNIQUE",        "UPDATE",        "USING",         "VACUUM",      
  "VALUES",        "WHERE",         "as",            "carg",        
  "carglist",      "ccons",         "cmd",           "cmdlist",     
  "column",        "columnid",      "columnlist",    "conslist",    
  "conslist_opt",  "create_table",  "create_table_args",  "distinct",    
  "ecmd",          "error",         "explain",       "expr",        
  "expritem",      "exprlist",      "from",          "groupby_opt", 
  "having_opt",    "id",            "ids",           "idxitem",     
  "idxlist",       "input",         "inscollist",    "inscollist_opt",
  "item",          "itemlist",      "joinop",        "minus_num",   
  "number",        "oneselect",     "orderby_opt",   "plus_num",    
  "plus_opt",      "sclp",          "selcollist",    "select",      
  "seltablist",    "setlist",       "signed",        "sortitem",    
  "sortlist",      "sortorder",     "stl_prefix",    "tcons",       
  "temp",          "trans_opt",     "type",          "typename",    
  "uniqueflag",    "where_opt",   
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif


/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(int)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (int)sizeof(yyParser) );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 103:
#line 338 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4241 "./parse.c"
      break;
    case 104:
#line 460 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4246 "./parse.c"
      break;
    case 105:
#line 458 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4251 "./parse.c"
      break;
    case 106:
#line 216 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4256 "./parse.c"
      break;
    case 107:
#line 253 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4261 "./parse.c"
      break;
    case 108:
#line 258 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4266 "./parse.c"
      break;
    case 112:
#line 478 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4271 "./parse.c"
      break;
    case 114:
#line 318 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4276 "./parse.c"
      break;
    case 115:
#line 316 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4281 "./parse.c"
      break;
    case 116:
#line 296 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4286 "./parse.c"
      break;
    case 117:
#line 294 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4291 "./parse.c"
      break;
    case 121:
#line 166 "./parse.y"
{sqliteSelectDelete((yypminor->yy207));}
#line 4296 "./parse.c"
      break;
    case 122:
#line 228 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4301 "./parse.c"
      break;
    case 125:
#line 201 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4306 "./parse.c"
      break;
    case 126:
#line 199 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4311 "./parse.c"
      break;
    case 127:
#line 164 "./parse.y"
{sqliteSelectDelete((yypminor->yy207));}
#line 4316 "./parse.c"
      break;
    case 128:
#line 212 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4321 "./parse.c"
      break;
    case 129:
#line 274 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4326 "./parse.c"
      break;
    case 131:
#line 232 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4331 "./parse.c"
      break;
    case 132:
#line 230 "./parse.y"
{sqliteExprListDelete((yypminor->yy168));}
#line 4336 "./parse.c"
      break;
    case 134:
#line 214 "./parse.y"
{sqliteIdListDelete((yypminor->yy126));}
#line 4341 "./parse.c"
      break;
    case 141:
#line 268 "./parse.y"
{sqliteExprDelete((yypminor->yy130));}
#line 4346 "./parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 113, 1 },
  { 91, 1 },
  { 91, 3 },
  { 100, 2 },
  { 100, 1 },
  { 100, 0 },
  { 102, 1 },
  { 90, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 2 },
  { 90, 2 },
  { 90, 2 },
  { 90, 2 },
  { 90, 2 },
  { 97, 4 },
  { 136, 1 },
  { 136, 0 },
  { 98, 4 },
  { 94, 3 },
  { 94, 1 },
  { 92, 3 },
  { 93, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 109, 1 },
  { 110, 1 },
  { 110, 1 },
  { 138, 0 },
  { 138, 1 },
  { 138, 4 },
  { 138, 6 },
  { 139, 1 },
  { 139, 2 },
  { 130, 1 },
  { 130, 2 },
  { 130, 2 },
  { 88, 2 },
  { 88, 0 },
  { 87, 3 },
  { 87, 1 },
  { 87, 2 },
  { 87, 2 },
  { 87, 2 },
  { 87, 3 },
  { 87, 3 },
  { 87, 2 },
  { 87, 3 },
  { 87, 3 },
  { 87, 2 },
  { 89, 2 },
  { 89, 3 },
  { 89, 1 },
  { 89, 4 },
  { 96, 0 },
  { 96, 2 },
  { 95, 3 },
  { 95, 2 },
  { 95, 1 },
  { 135, 2 },
  { 135, 5 },
  { 135, 4 },
  { 135, 2 },
  { 90, 3 },
  { 90, 1 },
  { 127, 1 },
  { 127, 3 },
  { 118, 1 },
  { 118, 2 },
  { 118, 1 },
  { 118, 1 },
  { 121, 8 },
  { 99, 1 },
  { 99, 1 },
  { 99, 0 },
  { 125, 2 },
  { 125, 0 },
  { 126, 1 },
  { 126, 2 },
  { 126, 4 },
  { 86, 0 },
  { 86, 1 },
  { 106, 2 },
  { 134, 2 },
  { 134, 0 },
  { 128, 2 },
  { 128, 4 },
  { 122, 0 },
  { 122, 3 },
  { 132, 4 },
  { 132, 2 },
  { 131, 1 },
  { 133, 1 },
  { 133, 1 },
  { 133, 0 },
  { 107, 0 },
  { 107, 3 },
  { 108, 0 },
  { 108, 2 },
  { 90, 4 },
  { 141, 0 },
  { 141, 2 },
  { 90, 5 },
  { 129, 5 },
  { 129, 3 },
  { 90, 8 },
  { 90, 5 },
  { 117, 3 },
  { 117, 1 },
  { 116, 1 },
  { 116, 2 },
  { 116, 2 },
  { 116, 1 },
  { 116, 2 },
  { 116, 2 },
  { 116, 1 },
  { 116, 1 },
  { 115, 0 },
  { 115, 3 },
  { 114, 3 },
  { 114, 1 },
  { 103, 3 },
  { 103, 1 },
  { 103, 1 },
  { 103, 3 },
  { 103, 1 },
  { 103, 1 },
  { 103, 1 },
  { 103, 4 },
  { 103, 4 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 4 },
  { 103, 3 },
  { 103, 4 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 3 },
  { 103, 2 },
  { 103, 3 },
  { 103, 2 },
  { 103, 3 },
  { 103, 2 },
  { 103, 2 },
  { 103, 2 },
  { 103, 3 },
  { 103, 5 },
  { 103, 6 },
  { 103, 5 },
  { 103, 5 },
  { 103, 6 },
  { 103, 6 },
  { 105, 3 },
  { 105, 1 },
  { 104, 1 },
  { 104, 0 },
  { 90, 9 },
  { 140, 1 },
  { 140, 0 },
  { 112, 3 },
  { 112, 1 },
  { 111, 1 },
  { 90, 3 },
  { 90, 7 },
  { 90, 4 },
  { 90, 1 },
  { 90, 2 },
  { 90, 4 },
  { 90, 4 },
  { 90, 4 },
  { 90, 4 },
  { 90, 5 },
  { 123, 2 },
  { 119, 2 },
  { 120, 1 },
  { 120, 1 },
  { 124, 1 },
  { 124, 0 },
};

static void yy_accept(yyParser *  sqliteParserANSIARGDECL);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  sqliteParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("input ::= cmdlist")
        /* No destructor defined for cmdlist */
        break;
      case 1:
        YYTRACE("cmdlist ::= ecmd")
        /* No destructor defined for ecmd */
        break;
      case 2:
        YYTRACE("cmdlist ::= cmdlist SEMI ecmd")
        /* No destructor defined for cmdlist */
        /* No destructor defined for SEMI */
        /* No destructor defined for ecmd */
        break;
      case 3:
        YYTRACE("ecmd ::= explain cmd")
#line 47 "./parse.y"
{sqliteExec(pParse);}
#line 4716 "./parse.c"
        /* No destructor defined for explain */
        /* No destructor defined for cmd */
        break;
      case 4:
        YYTRACE("ecmd ::= cmd")
#line 48 "./parse.y"
{sqliteExec(pParse);}
#line 4724 "./parse.c"
        /* No destructor defined for cmd */
        break;
      case 5:
        YYTRACE("ecmd ::=")
        break;
      case 6:
        YYTRACE("explain ::= EXPLAIN")
#line 50 "./parse.y"
{pParse->explain = 1;}
#line 4734 "./parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
        YYTRACE("cmd ::= BEGIN trans_opt")
#line 54 "./parse.y"
{sqliteBeginTransaction(pParse);}
#line 4741 "./parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 8:
        YYTRACE("trans_opt ::=")
        break;
      case 9:
        YYTRACE("trans_opt ::= TRANSACTION")
        /* No destructor defined for TRANSACTION */
        break;
      case 10:
        YYTRACE("trans_opt ::= TRANSACTION ids")
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for ids */
        break;
      case 11:
        YYTRACE("cmd ::= COMMIT trans_opt")
#line 58 "./parse.y"
{sqliteCommitTransaction(pParse);}
#line 4761 "./parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 12:
        YYTRACE("cmd ::= END trans_opt")
#line 59 "./parse.y"
{sqliteCommitTransaction(pParse);}
#line 4769 "./parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 13:
        YYTRACE("cmd ::= ROLLBACK trans_opt")
#line 60 "./parse.y"
{sqliteRollbackTransaction(pParse);}
#line 4777 "./parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 14:
        YYTRACE("cmd ::= create_table create_table_args")
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 15:
        YYTRACE("create_table ::= CREATE temp TABLE ids")
#line 66 "./parse.y"
{sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy182,yymsp[-2].minor.yy136);}
#line 4790 "./parse.c"
        /* No destructor defined for TABLE */
        break;
      case 16:
        YYTRACE("temp ::= TEMP")
#line 68 "./parse.y"
{yygotominor.yy136 = 1;}
#line 4797 "./parse.c"
        /* No destructor defined for TEMP */
        break;
      case 17:
        YYTRACE("temp ::=")
#line 69 "./parse.y"
{yygotominor.yy136 = 0;}
#line 4804 "./parse.c"
        break;
      case 18:
        YYTRACE("create_table_args ::= LP columnlist conslist_opt RP")
#line 71 "./parse.y"
{sqliteEndTable(pParse,&yymsp[0].minor.yy0);}
#line 4810 "./parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 19:
        YYTRACE("columnlist ::= columnlist COMMA column")
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 20:
        YYTRACE("columnlist ::= column")
        /* No destructor defined for column */
        break;
      case 21:
        YYTRACE("column ::= columnid type carglist")
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 22:
        YYTRACE("columnid ::= ids")
#line 80 "./parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy182);}
#line 4835 "./parse.c"
        break;
      case 23:
        YYTRACE("id ::= DESC")
#line 88 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4841 "./parse.c"
        break;
      case 24:
        YYTRACE("id ::= ASC")
#line 89 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4847 "./parse.c"
        break;
      case 25:
        YYTRACE("id ::= DELIMITERS")
#line 90 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4853 "./parse.c"
        break;
      case 26:
        YYTRACE("id ::= EXPLAIN")
#line 91 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4859 "./parse.c"
        break;
      case 27:
        YYTRACE("id ::= VACUUM")
#line 92 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4865 "./parse.c"
        break;
      case 28:
        YYTRACE("id ::= BEGIN")
#line 93 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4871 "./parse.c"
        break;
      case 29:
        YYTRACE("id ::= END")
#line 94 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4877 "./parse.c"
        break;
      case 30:
        YYTRACE("id ::= PRAGMA")
#line 95 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4883 "./parse.c"
        break;
      case 31:
        YYTRACE("id ::= CLUSTER")
#line 96 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4889 "./parse.c"
        break;
      case 32:
        YYTRACE("id ::= ID")
#line 97 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4895 "./parse.c"
        break;
      case 33:
        YYTRACE("id ::= TEMP")
#line 98 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4901 "./parse.c"
        break;
      case 34:
        YYTRACE("ids ::= id")
#line 103 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy182;}
#line 4907 "./parse.c"
        break;
      case 35:
        YYTRACE("ids ::= STRING")
#line 104 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 4913 "./parse.c"
        break;
      case 36:
        YYTRACE("type ::=")
        break;
      case 37:
        YYTRACE("type ::= typename")
#line 107 "./parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy182,&yymsp[0].minor.yy182);}
#line 4922 "./parse.c"
        break;
      case 38:
        YYTRACE("type ::= typename LP signed RP")
#line 108 "./parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy182,&yymsp[0].minor.yy0);}
#line 4928 "./parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 39:
        YYTRACE("type ::= typename LP signed COMMA signed RP")
#line 110 "./parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy182,&yymsp[0].minor.yy0);}
#line 4936 "./parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 40:
        YYTRACE("typename ::= ids")
#line 112 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy182;}
#line 4946 "./parse.c"
        break;
      case 41:
        YYTRACE("typename ::= typename ids")
#line 113 "./parse.y"
{yygotominor.yy182 = yymsp[-1].minor.yy182;}
#line 4952 "./parse.c"
        /* No destructor defined for ids */
        break;
      case 42:
        YYTRACE("signed ::= INTEGER")
        /* No destructor defined for INTEGER */
        break;
      case 43:
        YYTRACE("signed ::= PLUS INTEGER")
        /* No destructor defined for PLUS */
        /* No destructor defined for INTEGER */
        break;
      case 44:
        YYTRACE("signed ::= MINUS INTEGER")
        /* No destructor defined for MINUS */
        /* No destructor defined for INTEGER */
        break;
      case 45:
        YYTRACE("carglist ::= carglist carg")
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 46:
        YYTRACE("carglist ::=")
        break;
      case 47:
        YYTRACE("carg ::= CONSTRAINT ids ccons")
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for ids */
        /* No destructor defined for ccons */
        break;
      case 48:
        YYTRACE("carg ::= ccons")
        /* No destructor defined for ccons */
        break;
      case 49:
        YYTRACE("carg ::= DEFAULT STRING")
#line 121 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 4991 "./parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
        YYTRACE("carg ::= DEFAULT ID")
#line 122 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 4998 "./parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 51:
        YYTRACE("carg ::= DEFAULT INTEGER")
#line 123 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5005 "./parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 52:
        YYTRACE("carg ::= DEFAULT PLUS INTEGER")
#line 124 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5012 "./parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 53:
        YYTRACE("carg ::= DEFAULT MINUS INTEGER")
#line 125 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 5020 "./parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 54:
        YYTRACE("carg ::= DEFAULT FLOAT")
#line 126 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5028 "./parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 55:
        YYTRACE("carg ::= DEFAULT PLUS FLOAT")
#line 127 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5035 "./parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 56:
        YYTRACE("carg ::= DEFAULT MINUS FLOAT")
#line 128 "./parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 5043 "./parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 57:
        YYTRACE("carg ::= DEFAULT NULL")
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 58:
        YYTRACE("ccons ::= NOT NULL")
#line 134 "./parse.y"
{sqliteAddNotNull(pParse);}
#line 5056 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 59:
        YYTRACE("ccons ::= PRIMARY KEY sortorder")
#line 135 "./parse.y"
{sqliteCreateIndex(pParse,0,0,0,1,0,0);}
#line 5064 "./parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 60:
        YYTRACE("ccons ::= UNIQUE")
#line 136 "./parse.y"
{sqliteCreateIndex(pParse,0,0,0,1,0,0);}
#line 5073 "./parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 61:
        YYTRACE("ccons ::= CHECK LP expr RP")
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(103,&yymsp[-1].minor);
        /* No destructor defined for RP */
        break;
      case 62:
        YYTRACE("conslist_opt ::=")
        break;
      case 63:
        YYTRACE("conslist_opt ::= COMMA conslist")
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 64:
        YYTRACE("conslist ::= conslist COMMA tcons")
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 65:
        YYTRACE("conslist ::= conslist tcons")
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 66:
        YYTRACE("conslist ::= tcons")
        /* No destructor defined for tcons */
        break;
      case 67:
        YYTRACE("tcons ::= CONSTRAINT ids")
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for ids */
        break;
      case 68:
        YYTRACE("tcons ::= PRIMARY KEY LP idxlist RP")
#line 148 "./parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-1].minor.yy126,1,0,0);}
#line 5115 "./parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 69:
        YYTRACE("tcons ::= UNIQUE LP idxlist RP")
#line 149 "./parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-1].minor.yy126,1,0,0);}
#line 5125 "./parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 70:
        YYTRACE("tcons ::= CHECK expr")
        /* No destructor defined for CHECK */
  yy_destructor(103,&yymsp[0].minor);
        break;
      case 71:
        YYTRACE("cmd ::= DROP TABLE ids")
#line 154 "./parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy182);}
#line 5139 "./parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 72:
        YYTRACE("cmd ::= select")
#line 158 "./parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy207, SRT_Callback, 0);
  sqliteSelectDelete(yymsp[0].minor.yy207);
}
#line 5150 "./parse.c"
        break;
      case 73:
        YYTRACE("select ::= oneselect")
#line 168 "./parse.y"
{yygotominor.yy207 = yymsp[0].minor.yy207;}
#line 5156 "./parse.c"
        break;
      case 74:
        YYTRACE("select ::= select joinop oneselect")
#line 169 "./parse.y"
{
  if( yymsp[0].minor.yy207 ){
    yymsp[0].minor.yy207->op = yymsp[-1].minor.yy136;
    yymsp[0].minor.yy207->pPrior = yymsp[-2].minor.yy207;
  }
  yygotominor.yy207 = yymsp[0].minor.yy207;
}
#line 5168 "./parse.c"
        break;
      case 75:
        YYTRACE("joinop ::= UNION")
#line 177 "./parse.y"
{yygotominor.yy136 = TK_UNION;}
#line 5174 "./parse.c"
        /* No destructor defined for UNION */
        break;
      case 76:
        YYTRACE("joinop ::= UNION ALL")
#line 178 "./parse.y"
{yygotominor.yy136 = TK_ALL;}
#line 5181 "./parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 77:
        YYTRACE("joinop ::= INTERSECT")
#line 179 "./parse.y"
{yygotominor.yy136 = TK_INTERSECT;}
#line 5189 "./parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 78:
        YYTRACE("joinop ::= EXCEPT")
#line 180 "./parse.y"
{yygotominor.yy136 = TK_EXCEPT;}
#line 5196 "./parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 79:
        YYTRACE("oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt")
#line 182 "./parse.y"
{
  yygotominor.yy207 = sqliteSelectNew(yymsp[-5].minor.yy168,yymsp[-4].minor.yy126,yymsp[-3].minor.yy130,yymsp[-2].minor.yy168,yymsp[-1].minor.yy130,yymsp[0].minor.yy168,yymsp[-6].minor.yy136);
}
#line 5205 "./parse.c"
        /* No destructor defined for SELECT */
        break;
      case 80:
        YYTRACE("distinct ::= DISTINCT")
#line 190 "./parse.y"
{yygotominor.yy136 = 1;}
#line 5212 "./parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 81:
        YYTRACE("distinct ::= ALL")
#line 191 "./parse.y"
{yygotominor.yy136 = 0;}
#line 5219 "./parse.c"
        /* No destructor defined for ALL */
        break;
      case 82:
        YYTRACE("distinct ::=")
#line 192 "./parse.y"
{yygotominor.yy136 = 0;}
#line 5226 "./parse.c"
        break;
      case 83:
        YYTRACE("sclp ::= selcollist COMMA")
#line 202 "./parse.y"
{yygotominor.yy168 = yymsp[-1].minor.yy168;}
#line 5232 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 84:
        YYTRACE("sclp ::=")
#line 203 "./parse.y"
{yygotominor.yy168 = 0;}
#line 5239 "./parse.c"
        break;
      case 85:
        YYTRACE("selcollist ::= STAR")
#line 204 "./parse.y"
{yygotominor.yy168 = 0;}
#line 5245 "./parse.c"
        /* No destructor defined for STAR */
        break;
      case 86:
        YYTRACE("selcollist ::= sclp expr")
#line 205 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(yymsp[-1].minor.yy168,yymsp[0].minor.yy130,0);}
#line 5252 "./parse.c"
        break;
      case 87:
        YYTRACE("selcollist ::= sclp expr as ids")
#line 206 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(yymsp[-3].minor.yy168,yymsp[-2].minor.yy130,&yymsp[0].minor.yy182);}
#line 5258 "./parse.c"
        /* No destructor defined for as */
        break;
      case 88:
        YYTRACE("as ::=")
        break;
      case 89:
        YYTRACE("as ::= AS")
        /* No destructor defined for AS */
        break;
      case 90:
        YYTRACE("from ::= FROM seltablist")
#line 218 "./parse.y"
{yygotominor.yy126 = yymsp[0].minor.yy126;}
#line 5272 "./parse.c"
        /* No destructor defined for FROM */
        break;
      case 91:
        YYTRACE("stl_prefix ::= seltablist COMMA")
#line 219 "./parse.y"
{yygotominor.yy126 = yymsp[-1].minor.yy126;}
#line 5279 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 92:
        YYTRACE("stl_prefix ::=")
#line 220 "./parse.y"
{yygotominor.yy126 = 0;}
#line 5286 "./parse.c"
        break;
      case 93:
        YYTRACE("seltablist ::= stl_prefix ids")
#line 221 "./parse.y"
{yygotominor.yy126 = sqliteIdListAppend(yymsp[-1].minor.yy126,&yymsp[0].minor.yy182);}
#line 5292 "./parse.c"
        break;
      case 94:
        YYTRACE("seltablist ::= stl_prefix ids as ids")
#line 222 "./parse.y"
{
  yygotominor.yy126 = sqliteIdListAppend(yymsp[-3].minor.yy126,&yymsp[-2].minor.yy182);
  sqliteIdListAddAlias(yygotominor.yy126,&yymsp[0].minor.yy182);
}
#line 5301 "./parse.c"
        /* No destructor defined for as */
        break;
      case 95:
        YYTRACE("orderby_opt ::=")
#line 234 "./parse.y"
{yygotominor.yy168 = 0;}
#line 5308 "./parse.c"
        break;
      case 96:
        YYTRACE("orderby_opt ::= ORDER BY sortlist")
#line 235 "./parse.y"
{yygotominor.yy168 = yymsp[0].minor.yy168;}
#line 5314 "./parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 97:
        YYTRACE("sortlist ::= sortlist COMMA sortitem sortorder")
#line 236 "./parse.y"
{
  yygotominor.yy168 = sqliteExprListAppend(yymsp[-3].minor.yy168,yymsp[-1].minor.yy130,0);
  if( yygotominor.yy168 ) yygotominor.yy168->a[yygotominor.yy168->nExpr-1].sortOrder = yymsp[0].minor.yy136;  /* 0=ascending, 1=decending */
}
#line 5325 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 98:
        YYTRACE("sortlist ::= sortitem sortorder")
#line 240 "./parse.y"
{
  yygotominor.yy168 = sqliteExprListAppend(0,yymsp[-1].minor.yy130,0);
  if( yygotominor.yy168 ) yygotominor.yy168->a[0].sortOrder = yymsp[0].minor.yy136;
}
#line 5335 "./parse.c"
        break;
      case 99:
        YYTRACE("sortitem ::= expr")
#line 244 "./parse.y"
{yygotominor.yy130 = yymsp[0].minor.yy130;}
#line 5341 "./parse.c"
        break;
      case 100:
        YYTRACE("sortorder ::= ASC")
#line 248 "./parse.y"
{yygotominor.yy136 = 0;}
#line 5347 "./parse.c"
        /* No destructor defined for ASC */
        break;
      case 101:
        YYTRACE("sortorder ::= DESC")
#line 249 "./parse.y"
{yygotominor.yy136 = 1;}
#line 5354 "./parse.c"
        /* No destructor defined for DESC */
        break;
      case 102:
        YYTRACE("sortorder ::=")
#line 250 "./parse.y"
{yygotominor.yy136 = 0;}
#line 5361 "./parse.c"
        break;
      case 103:
        YYTRACE("groupby_opt ::=")
#line 254 "./parse.y"
{yygotominor.yy168 = 0;}
#line 5367 "./parse.c"
        break;
      case 104:
        YYTRACE("groupby_opt ::= GROUP BY exprlist")
#line 255 "./parse.y"
{yygotominor.yy168 = yymsp[0].minor.yy168;}
#line 5373 "./parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 105:
        YYTRACE("having_opt ::=")
#line 259 "./parse.y"
{yygotominor.yy130 = 0;}
#line 5381 "./parse.c"
        break;
      case 106:
        YYTRACE("having_opt ::= HAVING expr")
#line 260 "./parse.y"
{yygotominor.yy130 = yymsp[0].minor.yy130;}
#line 5387 "./parse.c"
        /* No destructor defined for HAVING */
        break;
      case 107:
        YYTRACE("cmd ::= DELETE FROM ids where_opt")
#line 265 "./parse.y"
{sqliteDeleteFrom(pParse, &yymsp[-1].minor.yy182, yymsp[0].minor.yy130);}
#line 5394 "./parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 108:
        YYTRACE("where_opt ::=")
#line 270 "./parse.y"
{yygotominor.yy130 = 0;}
#line 5402 "./parse.c"
        break;
      case 109:
        YYTRACE("where_opt ::= WHERE expr")
#line 271 "./parse.y"
{yygotominor.yy130 = yymsp[0].minor.yy130;}
#line 5408 "./parse.c"
        /* No destructor defined for WHERE */
        break;
      case 110:
        YYTRACE("cmd ::= UPDATE ids SET setlist where_opt")
#line 279 "./parse.y"
{sqliteUpdate(pParse,&yymsp[-3].minor.yy182,yymsp[-1].minor.yy168,yymsp[0].minor.yy130);}
#line 5415 "./parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 111:
        YYTRACE("setlist ::= setlist COMMA ids EQ expr")
#line 282 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(yymsp[-4].minor.yy168,yymsp[0].minor.yy130,&yymsp[-2].minor.yy182);}
#line 5423 "./parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 112:
        YYTRACE("setlist ::= ids EQ expr")
#line 283 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(0,yymsp[0].minor.yy130,&yymsp[-2].minor.yy182);}
#line 5431 "./parse.c"
        /* No destructor defined for EQ */
        break;
      case 113:
        YYTRACE("cmd ::= INSERT INTO ids inscollist_opt VALUES LP itemlist RP")
#line 288 "./parse.y"
{sqliteInsert(pParse, &yymsp[-5].minor.yy182, yymsp[-1].minor.yy168, 0, yymsp[-4].minor.yy126);}
#line 5438 "./parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 114:
        YYTRACE("cmd ::= INSERT INTO ids inscollist_opt select")
#line 290 "./parse.y"
{sqliteInsert(pParse, &yymsp[-2].minor.yy182, 0, yymsp[0].minor.yy207, yymsp[-1].minor.yy126);}
#line 5449 "./parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        break;
      case 115:
        YYTRACE("itemlist ::= itemlist COMMA item")
#line 298 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(yymsp[-2].minor.yy168,yymsp[0].minor.yy130,0);}
#line 5457 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 116:
        YYTRACE("itemlist ::= item")
#line 299 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(0,yymsp[0].minor.yy130,0);}
#line 5464 "./parse.c"
        break;
      case 117:
        YYTRACE("item ::= INTEGER")
#line 300 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 5470 "./parse.c"
        break;
      case 118:
        YYTRACE("item ::= PLUS INTEGER")
#line 301 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 5476 "./parse.c"
        /* No destructor defined for PLUS */
        break;
      case 119:
        YYTRACE("item ::= MINUS INTEGER")
#line 302 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_UMINUS, 0, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pLeft = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);
}
#line 5486 "./parse.c"
        /* No destructor defined for MINUS */
        break;
      case 120:
        YYTRACE("item ::= FLOAT")
#line 306 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 5493 "./parse.c"
        break;
      case 121:
        YYTRACE("item ::= PLUS FLOAT")
#line 307 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 5499 "./parse.c"
        /* No destructor defined for PLUS */
        break;
      case 122:
        YYTRACE("item ::= MINUS FLOAT")
#line 308 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_UMINUS, 0, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pLeft = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);
}
#line 5509 "./parse.c"
        /* No destructor defined for MINUS */
        break;
      case 123:
        YYTRACE("item ::= STRING")
#line 312 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 5516 "./parse.c"
        break;
      case 124:
        YYTRACE("item ::= NULL")
#line 313 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_NULL, 0, 0, 0);}
#line 5522 "./parse.c"
        /* No destructor defined for NULL */
        break;
      case 125:
        YYTRACE("inscollist_opt ::=")
#line 320 "./parse.y"
{yygotominor.yy126 = 0;}
#line 5529 "./parse.c"
        break;
      case 126:
        YYTRACE("inscollist_opt ::= LP inscollist RP")
#line 321 "./parse.y"
{yygotominor.yy126 = yymsp[-1].minor.yy126;}
#line 5535 "./parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 127:
        YYTRACE("inscollist ::= inscollist COMMA ids")
#line 322 "./parse.y"
{yygotominor.yy126 = sqliteIdListAppend(yymsp[-2].minor.yy126,&yymsp[0].minor.yy182);}
#line 5543 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 128:
        YYTRACE("inscollist ::= ids")
#line 323 "./parse.y"
{yygotominor.yy126 = sqliteIdListAppend(0,&yymsp[0].minor.yy182);}
#line 5550 "./parse.c"
        break;
      case 129:
        YYTRACE("expr ::= LP expr RP")
#line 340 "./parse.y"
{yygotominor.yy130 = yymsp[-1].minor.yy130; sqliteExprSpan(yygotominor.yy130,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);}
#line 5556 "./parse.c"
        break;
      case 130:
        YYTRACE("expr ::= NULL")
#line 341 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 5562 "./parse.c"
        break;
      case 131:
        YYTRACE("expr ::= id")
#line 342 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy182);}
#line 5568 "./parse.c"
        break;
      case 132:
        YYTRACE("expr ::= ids DOT ids")
#line 343 "./parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy182);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy182);
  yygotominor.yy130 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 5578 "./parse.c"
        /* No destructor defined for DOT */
        break;
      case 133:
        YYTRACE("expr ::= INTEGER")
#line 348 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 5585 "./parse.c"
        break;
      case 134:
        YYTRACE("expr ::= FLOAT")
#line 349 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 5591 "./parse.c"
        break;
      case 135:
        YYTRACE("expr ::= STRING")
#line 350 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 5597 "./parse.c"
        break;
      case 136:
        YYTRACE("expr ::= ID LP exprlist RP")
#line 351 "./parse.y"
{
  yygotominor.yy130 = sqliteExprFunction(yymsp[-1].minor.yy168, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 5606 "./parse.c"
        /* No destructor defined for LP */
        break;
      case 137:
        YYTRACE("expr ::= ID LP STAR RP")
#line 355 "./parse.y"
{
  yygotominor.yy130 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 5616 "./parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 138:
        YYTRACE("expr ::= expr AND expr")
#line 359 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_AND, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5624 "./parse.c"
        /* No destructor defined for AND */
        break;
      case 139:
        YYTRACE("expr ::= expr OR expr")
#line 360 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_OR, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5631 "./parse.c"
        /* No destructor defined for OR */
        break;
      case 140:
        YYTRACE("expr ::= expr LT expr")
#line 361 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_LT, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5638 "./parse.c"
        /* No destructor defined for LT */
        break;
      case 141:
        YYTRACE("expr ::= expr GT expr")
#line 362 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_GT, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5645 "./parse.c"
        /* No destructor defined for GT */
        break;
      case 142:
        YYTRACE("expr ::= expr LE expr")
#line 363 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_LE, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5652 "./parse.c"
        /* No destructor defined for LE */
        break;
      case 143:
        YYTRACE("expr ::= expr GE expr")
#line 364 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_GE, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5659 "./parse.c"
        /* No destructor defined for GE */
        break;
      case 144:
        YYTRACE("expr ::= expr NE expr")
#line 365 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_NE, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5666 "./parse.c"
        /* No destructor defined for NE */
        break;
      case 145:
        YYTRACE("expr ::= expr EQ expr")
#line 366 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5673 "./parse.c"
        /* No destructor defined for EQ */
        break;
      case 146:
        YYTRACE("expr ::= expr LIKE expr")
#line 367 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_LIKE, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5680 "./parse.c"
        /* No destructor defined for LIKE */
        break;
      case 147:
        YYTRACE("expr ::= expr NOT LIKE expr")
#line 368 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_LIKE, yymsp[-3].minor.yy130, yymsp[0].minor.yy130, 0);
  yygotominor.yy130 = sqliteExpr(TK_NOT, yygotominor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-3].minor.yy130->span,&yymsp[0].minor.yy130->span);
}
#line 5691 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for LIKE */
        break;
      case 148:
        YYTRACE("expr ::= expr GLOB expr")
#line 373 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_GLOB,yymsp[-2].minor.yy130,yymsp[0].minor.yy130,0);}
#line 5699 "./parse.c"
        /* No destructor defined for GLOB */
        break;
      case 149:
        YYTRACE("expr ::= expr NOT GLOB expr")
#line 374 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_GLOB, yymsp[-3].minor.yy130, yymsp[0].minor.yy130, 0);
  yygotominor.yy130 = sqliteExpr(TK_NOT, yygotominor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-3].minor.yy130->span,&yymsp[0].minor.yy130->span);
}
#line 5710 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for GLOB */
        break;
      case 150:
        YYTRACE("expr ::= expr PLUS expr")
#line 379 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5718 "./parse.c"
        /* No destructor defined for PLUS */
        break;
      case 151:
        YYTRACE("expr ::= expr MINUS expr")
#line 380 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5725 "./parse.c"
        /* No destructor defined for MINUS */
        break;
      case 152:
        YYTRACE("expr ::= expr STAR expr")
#line 381 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5732 "./parse.c"
        /* No destructor defined for STAR */
        break;
      case 153:
        YYTRACE("expr ::= expr SLASH expr")
#line 382 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5739 "./parse.c"
        /* No destructor defined for SLASH */
        break;
      case 154:
        YYTRACE("expr ::= expr CONCAT expr")
#line 383 "./parse.y"
{yygotominor.yy130 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy130, yymsp[0].minor.yy130, 0);}
#line 5746 "./parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 155:
        YYTRACE("expr ::= expr ISNULL")
#line 384 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-1].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5756 "./parse.c"
        break;
      case 156:
        YYTRACE("expr ::= expr IS NULL")
#line 388 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-2].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5765 "./parse.c"
        /* No destructor defined for IS */
        break;
      case 157:
        YYTRACE("expr ::= expr NOTNULL")
#line 392 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-1].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5775 "./parse.c"
        break;
      case 158:
        YYTRACE("expr ::= expr NOT NULL")
#line 396 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-2].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5784 "./parse.c"
        /* No destructor defined for NOT */
        break;
      case 159:
        YYTRACE("expr ::= NOT expr")
#line 400 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_NOT, yymsp[0].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy130->span);
}
#line 5794 "./parse.c"
        break;
      case 160:
        YYTRACE("expr ::= MINUS expr")
#line 404 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy130->span);
}
#line 5803 "./parse.c"
        break;
      case 161:
        YYTRACE("expr ::= PLUS expr")
#line 408 "./parse.y"
{
  yygotominor.yy130 = yymsp[0].minor.yy130;
  sqliteExprSpan(yygotominor.yy130,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy130->span);
}
#line 5812 "./parse.c"
        break;
      case 162:
        YYTRACE("expr ::= LP select RP")
#line 412 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pSelect = yymsp[-1].minor.yy207;
  sqliteExprSpan(yygotominor.yy130,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 5822 "./parse.c"
        break;
      case 163:
        YYTRACE("expr ::= expr BETWEEN expr AND expr")
#line 417 "./parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy130, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy130, 0);
  yygotominor.yy130 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pList = pList;
  sqliteExprSpan(yygotominor.yy130,&yymsp[-4].minor.yy130->span,&yymsp[0].minor.yy130->span);
}
#line 5834 "./parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 164:
        YYTRACE("expr ::= expr NOT BETWEEN expr AND expr")
#line 424 "./parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy130, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy130, 0);
  yygotominor.yy130 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pList = pList;
  yygotominor.yy130 = sqliteExpr(TK_NOT, yygotominor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-5].minor.yy130->span,&yymsp[0].minor.yy130->span);
}
#line 5849 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 165:
        YYTRACE("expr ::= expr IN LP exprlist RP")
#line 432 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_IN, yymsp[-4].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pList = yymsp[-1].minor.yy168;
  sqliteExprSpan(yygotominor.yy130,&yymsp[-4].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5862 "./parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 166:
        YYTRACE("expr ::= expr IN LP select RP")
#line 437 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_IN, yymsp[-4].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pSelect = yymsp[-1].minor.yy207;
  sqliteExprSpan(yygotominor.yy130,&yymsp[-4].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5874 "./parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 167:
        YYTRACE("expr ::= expr NOT IN LP exprlist RP")
#line 442 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_IN, yymsp[-5].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pList = yymsp[-1].minor.yy168;
  yygotominor.yy130 = sqliteExpr(TK_NOT, yygotominor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-5].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5887 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 168:
        YYTRACE("expr ::= expr NOT IN LP select RP")
#line 448 "./parse.y"
{
  yygotominor.yy130 = sqliteExpr(TK_IN, yymsp[-5].minor.yy130, 0, 0);
  if( yygotominor.yy130 ) yygotominor.yy130->pSelect = yymsp[-1].minor.yy207;
  yygotominor.yy130 = sqliteExpr(TK_NOT, yygotominor.yy130, 0, 0);
  sqliteExprSpan(yygotominor.yy130,&yymsp[-5].minor.yy130->span,&yymsp[0].minor.yy0);
}
#line 5901 "./parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 169:
        YYTRACE("exprlist ::= exprlist COMMA expritem")
#line 463 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(yymsp[-2].minor.yy168,yymsp[0].minor.yy130,0);}
#line 5910 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 170:
        YYTRACE("exprlist ::= expritem")
#line 464 "./parse.y"
{yygotominor.yy168 = sqliteExprListAppend(0,yymsp[0].minor.yy130,0);}
#line 5917 "./parse.c"
        break;
      case 171:
        YYTRACE("expritem ::= expr")
#line 465 "./parse.y"
{yygotominor.yy130 = yymsp[0].minor.yy130;}
#line 5923 "./parse.c"
        break;
      case 172:
        YYTRACE("expritem ::=")
#line 466 "./parse.y"
{yygotominor.yy130 = 0;}
#line 5929 "./parse.c"
        break;
      case 173:
        YYTRACE("cmd ::= CREATE uniqueflag INDEX ids ON ids LP idxlist RP")
#line 471 "./parse.y"
{sqliteCreateIndex(pParse, &yymsp[-5].minor.yy182, &yymsp[-3].minor.yy182, yymsp[-1].minor.yy126, yymsp[-7].minor.yy136, &yymsp[-8].minor.yy0, &yymsp[0].minor.yy0);}
#line 5935 "./parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 174:
        YYTRACE("uniqueflag ::= UNIQUE")
#line 474 "./parse.y"
{ yygotominor.yy136 = 1; }
#line 5944 "./parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 175:
        YYTRACE("uniqueflag ::=")
#line 475 "./parse.y"
{ yygotominor.yy136 = 0; }
#line 5951 "./parse.c"
        break;
      case 176:
        YYTRACE("idxlist ::= idxlist COMMA idxitem")
#line 482 "./parse.y"
{yygotominor.yy126 = sqliteIdListAppend(yymsp[-2].minor.yy126,&yymsp[0].minor.yy182);}
#line 5957 "./parse.c"
        /* No destructor defined for COMMA */
        break;
      case 177:
        YYTRACE("idxlist ::= idxitem")
#line 484 "./parse.y"
{yygotominor.yy126 = sqliteIdListAppend(0,&yymsp[0].minor.yy182);}
#line 5964 "./parse.c"
        break;
      case 178:
        YYTRACE("idxitem ::= ids")
#line 485 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy182;}
#line 5970 "./parse.c"
        break;
      case 179:
        YYTRACE("cmd ::= DROP INDEX ids")
#line 490 "./parse.y"
{sqliteDropIndex(pParse, &yymsp[0].minor.yy182);}
#line 5976 "./parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 180:
        YYTRACE("cmd ::= COPY ids FROM ids USING DELIMITERS STRING")
#line 496 "./parse.y"
{sqliteCopy(pParse,&yymsp[-5].minor.yy182,&yymsp[-3].minor.yy182,&yymsp[0].minor.yy0);}
#line 5984 "./parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 181:
        YYTRACE("cmd ::= COPY ids FROM ids")
#line 498 "./parse.y"
{sqliteCopy(pParse,&yymsp[-2].minor.yy182,&yymsp[0].minor.yy182,0);}
#line 5994 "./parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 182:
        YYTRACE("cmd ::= VACUUM")
#line 502 "./parse.y"
{sqliteVacuum(pParse,0);}
#line 6002 "./parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 183:
        YYTRACE("cmd ::= VACUUM ids")
#line 503 "./parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy182);}
#line 6009 "./parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 184:
        YYTRACE("cmd ::= PRAGMA ids EQ ids")
#line 507 "./parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy182,&yymsp[0].minor.yy182,0);}
#line 6016 "./parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 185:
        YYTRACE("cmd ::= PRAGMA ids EQ ON")
#line 508 "./parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy182,&yymsp[0].minor.yy0,0);}
#line 6024 "./parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 186:
        YYTRACE("cmd ::= PRAGMA ids EQ plus_num")
#line 509 "./parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy182,&yymsp[0].minor.yy182,0);}
#line 6032 "./parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 187:
        YYTRACE("cmd ::= PRAGMA ids EQ minus_num")
#line 510 "./parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy182,&yymsp[0].minor.yy182,1);}
#line 6040 "./parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 188:
        YYTRACE("cmd ::= PRAGMA ids LP ids RP")
#line 511 "./parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy182,&yymsp[-1].minor.yy182,0);}
#line 6048 "./parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 189:
        YYTRACE("plus_num ::= plus_opt number")
#line 512 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy182;}
#line 6057 "./parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 190:
        YYTRACE("minus_num ::= MINUS number")
#line 513 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy182;}
#line 6064 "./parse.c"
        /* No destructor defined for MINUS */
        break;
      case 191:
        YYTRACE("number ::= INTEGER")
#line 514 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 6071 "./parse.c"
        break;
      case 192:
        YYTRACE("number ::= FLOAT")
#line 515 "./parse.y"
{yygotominor.yy182 = yymsp[0].minor.yy0;}
#line 6077 "./parse.c"
        break;
      case 193:
        YYTRACE("plus_opt ::= PLUS")
        /* No destructor defined for PLUS */
        break;
      case 194:
        YYTRACE("plus_opt ::=")
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser sqliteParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  sqliteParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  sqliteParserANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 23 "./parse.y"

  sqliteSetString(&pParse->zErrMsg,"syntax error",0);
  pParse->sErrToken = TOKEN;

#line 6131 "./parse.c"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  sqliteParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    if( yymajor==0 ) return;
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE sqliteParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion sqliteParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser sqliteParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion sqliteParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser sqliteParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser sqliteParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
