/* inotifier.c generated by valac 0.14.2, the Vala compiler
 * generated from inotifier.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sys/inotify.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

typedef struct _INotifyDelegateHolder INotifyDelegateHolder;

#define FSO_FRAMEWORK_TYPE_INOTIFIER (fso_framework_inotifier_get_type ())
#define FSO_FRAMEWORK_INOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_INOTIFIER, FsoFrameworkINotifier))
#define FSO_FRAMEWORK_INOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_INOTIFIER, FsoFrameworkINotifierClass))
#define FSO_FRAMEWORK_IS_INOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_INOTIFIER))
#define FSO_FRAMEWORK_IS_INOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_INOTIFIER))
#define FSO_FRAMEWORK_INOTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_INOTIFIER, FsoFrameworkINotifierClass))

typedef struct _FsoFrameworkINotifier FsoFrameworkINotifier;
typedef struct _FsoFrameworkINotifierClass FsoFrameworkINotifierClass;
typedef struct _FsoFrameworkINotifierPrivate FsoFrameworkINotifierPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define FSO_FRAMEWORK_TYPE_LOGGER (fso_framework_logger_get_type ())
#define FSO_FRAMEWORK_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLogger))
#define FSO_FRAMEWORK_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_LOGGER))
#define FSO_FRAMEWORK_LOGGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLoggerIface))

typedef struct _FsoFrameworkLogger FsoFrameworkLogger;
typedef struct _FsoFrameworkLoggerIface FsoFrameworkLoggerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef void (*FsoFrameworkINotifyNotifierFunc) (int flags, guint32 cookie, const gchar* name, void* user_data);
struct _INotifyDelegateHolder {
	FsoFrameworkINotifyNotifierFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _FsoFrameworkINotifier {
	GObject parent_instance;
	FsoFrameworkINotifierPrivate * priv;
};

struct _FsoFrameworkINotifierClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkINotifierPrivate {
	GHashTable* delegates;
	gint fd;
	guint watch;
	GIOChannel* channel;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
};

typedef gchar* (*ReprDelegate) (void* user_data);
struct _FsoFrameworkLoggerIface {
	GTypeInterface parent_iface;
	void (*setLevel) (FsoFrameworkLogger* self, GLogLevelFlags level);
	void (*setDestination) (FsoFrameworkLogger* self, const gchar* destination);
	void (*setReprDelegate) (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target);
	GLogLevelFlags (*getLevel) (FsoFrameworkLogger* self);
	gchar* (*getDestination) (FsoFrameworkLogger* self);
	gboolean (*debug) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*info) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*warning) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*error) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*critical) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*data) (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
};


static gpointer fso_framework_inotifier_parent_class = NULL;
extern FsoFrameworkINotifier* fso_framework_inotifier_instance;
FsoFrameworkINotifier* fso_framework_inotifier_instance = NULL;
extern FsoFrameworkLogger* fso_framework_theLogger;

void inotify_delegate_holder_free (INotifyDelegateHolder* self);
static void inotify_delegate_holder_instance_init (INotifyDelegateHolder * self);
INotifyDelegateHolder* inotify_delegate_holder_new (FsoFrameworkINotifyNotifierFunc func, void* func_target);
INotifyDelegateHolder* inotify_delegate_holder_new (FsoFrameworkINotifyNotifierFunc func, void* func_target);
GType fso_framework_inotifier_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_INOTIFIER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_INOTIFIER, FsoFrameworkINotifierPrivate))
enum  {
	FSO_FRAMEWORK_INOTIFIER_DUMMY_PROPERTY
};
#define FSO_FRAMEWORK_INOTIFIER_BUFFER_LENGTH ((gssize) 4096)
FsoFrameworkINotifier* fso_framework_inotifier_new (void);
FsoFrameworkINotifier* fso_framework_inotifier_construct (GType object_type);
static void _inotify_delegate_holder_free0_ (gpointer var);
GType fso_framework_logger_get_type (void) G_GNUC_CONST;
gboolean fso_framework_logger_error (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_inotifier_onActionFromInotify (FsoFrameworkINotifier* self, GIOChannel* source, GIOCondition condition);
static gboolean _fso_framework_inotifier_onActionFromInotify_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void fso_framework_inotifier_handleEvent (FsoFrameworkINotifier* self, struct inotify_event* event);
guint _fso_framework_inotifier_add (FsoFrameworkINotifier* self, const gchar* path, int mask, FsoFrameworkINotifyNotifierFunc cb, void* cb_target);
void _fso_framework_inotifier_remove (FsoFrameworkINotifier* self, guint source);
guint fso_framework_inotifier_add (const gchar* path, int mask, FsoFrameworkINotifyNotifierFunc cb, void* cb_target);
void fso_framework_inotifier_remove (guint source);
static void fso_framework_inotifier_finalize (GObject* obj);


INotifyDelegateHolder* inotify_delegate_holder_new (FsoFrameworkINotifyNotifierFunc func, void* func_target) {
	INotifyDelegateHolder* self;
	FsoFrameworkINotifyNotifierFunc _tmp0_;
	void* _tmp0__target;
	self = g_slice_new0 (INotifyDelegateHolder);
	inotify_delegate_holder_instance_init (self);
	_tmp0_ = func;
	_tmp0__target = func_target;
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	self->func = _tmp0_;
	self->func_target = _tmp0__target;
	self->func_target_destroy_notify = NULL;
	return self;
}


static void inotify_delegate_holder_instance_init (INotifyDelegateHolder * self) {
}


void inotify_delegate_holder_free (INotifyDelegateHolder* self) {
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	g_slice_free (INotifyDelegateHolder, self);
}


static void _inotify_delegate_holder_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (inotify_delegate_holder_free (var), NULL));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean _fso_framework_inotifier_onActionFromInotify_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = fso_framework_inotifier_onActionFromInotify (self, source, condition);
	return result;
}


FsoFrameworkINotifier* fso_framework_inotifier_construct (GType object_type) {
	FsoFrameworkINotifier * self = NULL;
	gchar* _tmp0_ = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint _tmp12_;
	GIOChannel* _tmp13_;
	GIOChannel* _tmp14_;
	guint _tmp15_ = 0U;
	self = (FsoFrameworkINotifier*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (gchar, FSO_FRAMEWORK_INOTIFIER_BUFFER_LENGTH);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp0_;
	self->priv->buffer_length1 = FSO_FRAMEWORK_INOTIFIER_BUFFER_LENGTH;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _inotify_delegate_holder_free0_);
	_g_hash_table_unref0 (self->priv->delegates);
	self->priv->delegates = _tmp3_;
	_tmp4_ = inotify_init1 (0);
	self->priv->fd = _tmp4_;
	_tmp5_ = self->priv->fd;
	if (_tmp5_ == (-1)) {
		FsoFrameworkLogger* _tmp6_;
		gint _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp6_ = fso_framework_theLogger;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Can not init the inotify subsystem: ", _tmp9_, "; some features will not work", NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_error (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		return self;
	}
	_tmp12_ = self->priv->fd;
	_tmp13_ = g_io_channel_unix_new (_tmp12_);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->channel = _tmp13_;
	_tmp14_ = self->priv->channel;
	_tmp15_ = g_io_add_watch (_tmp14_, G_IO_IN | G_IO_HUP, _fso_framework_inotifier_onActionFromInotify_gio_func, self);
	self->priv->watch = _tmp15_;
	return self;
}


FsoFrameworkINotifier* fso_framework_inotifier_new (void) {
	return fso_framework_inotifier_construct (FSO_FRAMEWORK_TYPE_INOTIFIER);
}


gboolean fso_framework_inotifier_onActionFromInotify (FsoFrameworkINotifier* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GIOCondition _tmp0_;
	GIOCondition _tmp2_;
	GIOCondition _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = condition;
	if ((_tmp0_ & G_IO_HUP) == G_IO_HUP) {
		FsoFrameworkLogger* _tmp1_;
		_tmp1_ = fso_framework_theLogger;
		fso_framework_logger_error (_tmp1_, "HUP on inotify, will no longer get any notifications");
		result = FALSE;
		return result;
	}
	_tmp2_ = condition;
	if ((_tmp2_ & G_IO_IN) == G_IO_IN) {
		gint _tmp3_;
		gchar* _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		gchar* _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gint _tmp7__length1;
		struct inotify_event* pevent;
		struct inotify_event* _tmp8_;
		struct inotify_event _tmp9_;
		_tmp3_ = self->priv->fd;
		g_assert (_tmp3_ != (-1));
		_tmp4_ = self->priv->buffer;
		_tmp4__length1 = self->priv->buffer_length1;
		g_assert (_tmp4_ != NULL);
		_tmp5_ = self->priv->fd;
		_tmp6_ = self->priv->buffer;
		_tmp6__length1 = self->priv->buffer_length1;
		read (_tmp5_, _tmp6_, (gsize) FSO_FRAMEWORK_INOTIFIER_BUFFER_LENGTH);
		_tmp7_ = self->priv->buffer;
		_tmp7__length1 = self->priv->buffer_length1;
		pevent = (struct inotify_event*) _tmp7_;
		_tmp8_ = pevent;
		_tmp9_ = *_tmp8_;
		fso_framework_inotifier_handleEvent (self, &_tmp9_);
		result = TRUE;
		return result;
	}
	_tmp10_ = condition;
	g_critical ("inotifier.vala:98: Unsupported IOCondition %u", (guint) ((gint) _tmp10_));
	result = TRUE;
	return result;
}


void fso_framework_inotifier_handleEvent (FsoFrameworkINotifier* self, struct inotify_event* event) {
	GHashTable* _tmp0_;
	struct inotify_event _tmp1_;
	gint _tmp2_;
	gconstpointer _tmp3_ = NULL;
	INotifyDelegateHolder* holder;
	INotifyDelegateHolder* _tmp4_;
	const gchar* _tmp5_ = NULL;
	struct inotify_event _tmp6_;
	guint32 _tmp7_;
	INotifyDelegateHolder* _tmp10_;
	FsoFrameworkINotifyNotifierFunc _tmp11_;
	void* _tmp11__target;
	struct inotify_event _tmp12_;
	guint32 _tmp13_;
	struct inotify_event _tmp14_;
	guint32 _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.wd;
	_tmp3_ = g_hash_table_lookup (_tmp0_, GINT_TO_POINTER (_tmp2_));
	holder = (INotifyDelegateHolder*) _tmp3_;
	_tmp4_ = holder;
	g_assert (_tmp4_ != NULL);
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.len;
	if (_tmp7_ > ((guint32) 0)) {
		struct inotify_event _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.name;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = NULL;
	}
	_tmp10_ = holder;
	_tmp11_ = _tmp10_->func;
	_tmp11__target = _tmp10_->func_target;
	_tmp12_ = *event;
	_tmp13_ = _tmp12_.mask;
	_tmp14_ = *event;
	_tmp15_ = _tmp14_.cookie;
	_tmp16_ = _tmp5_;
	_tmp11_ ((int) _tmp13_, _tmp15_, _tmp16_, _tmp11__target);
}


guint _fso_framework_inotifier_add (FsoFrameworkINotifier* self, const gchar* path, int mask, FsoFrameworkINotifyNotifierFunc cb, void* cb_target) {
	guint result = 0U;
	gint _tmp0_;
	const gchar* _tmp1_;
	int _tmp2_;
	gint _tmp3_ = 0;
	gint wd;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (path != NULL, 0U);
	_tmp0_ = self->priv->fd;
	_tmp1_ = path;
	_tmp2_ = mask;
	_tmp3_ = inotify_add_watch (_tmp0_, _tmp1_, _tmp2_);
	wd = _tmp3_;
	_tmp4_ = wd;
	if (_tmp4_ == (-1)) {
		FsoFrameworkLogger* _tmp5_;
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp5_ = fso_framework_theLogger;
		_tmp6_ = errno;
		_tmp7_ = g_strerror (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("inotify_add_watch: ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		fso_framework_logger_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		result = (guint) 0;
		return result;
	} else {
		GHashTable* _tmp11_;
		gint _tmp12_;
		FsoFrameworkINotifyNotifierFunc _tmp13_;
		void* _tmp13__target;
		INotifyDelegateHolder* _tmp14_;
		_tmp11_ = self->priv->delegates;
		_tmp12_ = wd;
		_tmp13_ = cb;
		_tmp13__target = cb_target;
		_tmp14_ = inotify_delegate_holder_new (_tmp13_, _tmp13__target);
		g_hash_table_insert (_tmp11_, GINT_TO_POINTER (_tmp12_), _tmp14_);
		result = (guint) wd;
		return result;
	}
}


void _fso_framework_inotifier_remove (FsoFrameworkINotifier* self, guint source) {
	GHashTable* _tmp0_;
	guint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	INotifyDelegateHolder* holder;
	INotifyDelegateHolder* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = source;
	_tmp2_ = g_hash_table_lookup (_tmp0_, GINT_TO_POINTER ((gint) _tmp1_));
	holder = (INotifyDelegateHolder*) _tmp2_;
	_tmp3_ = holder;
	if (_tmp3_ != NULL) {
		gint _tmp4_;
		guint _tmp5_;
		GHashTable* _tmp6_;
		guint _tmp7_;
		_tmp4_ = self->priv->fd;
		_tmp5_ = source;
		inotify_rm_watch (_tmp4_, (gint) _tmp5_);
		_tmp6_ = self->priv->delegates;
		_tmp7_ = source;
		g_hash_table_remove (_tmp6_, GINT_TO_POINTER ((gint) _tmp7_));
	}
}


guint fso_framework_inotifier_add (const gchar* path, int mask, FsoFrameworkINotifyNotifierFunc cb, void* cb_target) {
	guint result = 0U;
	FsoFrameworkINotifier* _tmp0_;
	FsoFrameworkINotifier* _tmp2_;
	const gchar* _tmp3_;
	int _tmp4_;
	FsoFrameworkINotifyNotifierFunc _tmp5_;
	void* _tmp5__target;
	guint _tmp6_ = 0U;
	g_return_val_if_fail (path != NULL, 0U);
	_tmp0_ = fso_framework_inotifier_instance;
	if (_tmp0_ == NULL) {
		FsoFrameworkINotifier* _tmp1_;
		_tmp1_ = fso_framework_inotifier_new ();
		_g_object_unref0 (fso_framework_inotifier_instance);
		fso_framework_inotifier_instance = _tmp1_;
	}
	_tmp2_ = fso_framework_inotifier_instance;
	_tmp3_ = path;
	_tmp4_ = mask;
	_tmp5_ = cb;
	_tmp5__target = cb_target;
	_tmp6_ = _fso_framework_inotifier_add (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp5__target);
	result = _tmp6_;
	return result;
}


void fso_framework_inotifier_remove (guint source) {
	FsoFrameworkINotifier* _tmp0_;
	FsoFrameworkINotifier* _tmp2_;
	guint _tmp3_;
	_tmp0_ = fso_framework_inotifier_instance;
	if (_tmp0_ == NULL) {
		FsoFrameworkINotifier* _tmp1_;
		_tmp1_ = fso_framework_inotifier_new ();
		_g_object_unref0 (fso_framework_inotifier_instance);
		fso_framework_inotifier_instance = _tmp1_;
	}
	_tmp2_ = fso_framework_inotifier_instance;
	_tmp3_ = source;
	_fso_framework_inotifier_remove (_tmp2_, _tmp3_);
}


static void fso_framework_inotifier_class_init (FsoFrameworkINotifierClass * klass) {
	fso_framework_inotifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkINotifierPrivate));
	G_OBJECT_CLASS (klass)->finalize = fso_framework_inotifier_finalize;
}


static void fso_framework_inotifier_instance_init (FsoFrameworkINotifier * self) {
	self->priv = FSO_FRAMEWORK_INOTIFIER_GET_PRIVATE (self);
	self->priv->fd = -1;
}


static void fso_framework_inotifier_finalize (GObject* obj) {
	FsoFrameworkINotifier * self;
	guint _tmp0_;
	gint _tmp2_;
	self = FSO_FRAMEWORK_INOTIFIER (obj);
	_tmp0_ = self->priv->watch;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->watch;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->fd;
	if (_tmp2_ != (-1)) {
		gint _tmp3_;
		_tmp3_ = self->priv->fd;
		close (_tmp3_);
	}
	_g_hash_table_unref0 (self->priv->delegates);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	G_OBJECT_CLASS (fso_framework_inotifier_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.INotifier
 **/
GType fso_framework_inotifier_get_type (void) {
	static volatile gsize fso_framework_inotifier_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_inotifier_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkINotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_inotifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkINotifier), 0, (GInstanceInitFunc) fso_framework_inotifier_instance_init, NULL };
		GType fso_framework_inotifier_type_id;
		fso_framework_inotifier_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkINotifier", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_inotifier_type_id__volatile, fso_framework_inotifier_type_id);
	}
	return fso_framework_inotifier_type_id__volatile;
}



